/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.imp.prefspecs.compiler.model.IPageMember;
import org.eclipse.imp.prefspecs.compiler.model.IPageMemberContainer;
import org.eclipse.imp.prefspecs.compiler.model.TabContainerBase;
import org.eclipse.imp.prefspecs.compiler.model.TabInfo;
import org.eclipse.ui.console.MessageConsoleStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageInfo
extends TabContainerBase
implements IPageMemberContainer {
    private final String name;
    private final List<IPageMember> fMembers = new LinkedList<IPageMember>();
    private boolean noDetails = false;

    public PageInfo(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean getNoDetails() {
        return this.noDetails;
    }

    public void setNoDetails(boolean noDetails) {
        this.noDetails = noDetails;
    }

    @Override
    public void addChild(IPageMember m) {
        if (m == null || this.fMembers.contains(m)) {
            return;
        }
        this.fMembers.add(m);
    }

    @Override
    public List<IPageMember> getChildren() {
        return Collections.unmodifiableList(this.fMembers);
    }

    public void dump(MessageConsoleStream out) {
        String indent = "  ";
        out.println("\n\t%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        out.println("PageInfo: '" + this.getName() + "'");
        out.println("Members:");
        for (IPageMember m : this.fMembers) {
            m.dump(indent, out);
        }
        out.println("Tabs:");
        for (TabInfo tab : this.fTabs) {
            tab.dump(indent, out);
        }
        out.println("\t%%%%\t%%%%\t%%%%\n");
    }

    public String toString() {
        return "page " + this.getName();
    }
}

