/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl;

import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.INumber;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedTypeException;
import org.eclipse.imp.pdb.facts.impl.Value;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;

public abstract class AbstractNumberValue
extends Value
implements INumber {
    public AbstractNumberValue(Type type) {
        super(type);
    }

    public INumber add(INumber other) {
        if (other.getType().isRealType()) {
            return this.add(other.toReal());
        }
        if (other.getType().isIntegerType()) {
            return this.add(other.toInteger());
        }
        throw new UnexpectedTypeException(TypeFactory.getInstance().numberType(), other.getType());
    }

    public INumber divide(INumber other, int precision) {
        if (other.getType().isRealType()) {
            return this.divide(other.toReal(), precision);
        }
        if (other.getType().isIntegerType()) {
            return this.divide(other.toInteger(), precision);
        }
        throw new UnexpectedTypeException(TypeFactory.getInstance().numberType(), other.getType());
    }

    public IBool greater(INumber other) {
        if (other.getType().isRealType()) {
            return this.greater(other.toReal());
        }
        if (other.getType().isIntegerType()) {
            return this.greater(other.toInteger());
        }
        throw new UnexpectedTypeException(TypeFactory.getInstance().numberType(), other.getType());
    }

    public IBool greaterEqual(INumber other) {
        if (other.getType().isRealType()) {
            return this.greaterEqual(other.toReal());
        }
        if (other.getType().isIntegerType()) {
            return this.greaterEqual(other.toInteger());
        }
        throw new UnexpectedTypeException(TypeFactory.getInstance().numberType(), other.getType());
    }

    public IBool less(INumber other) {
        if (other.getType().isRealType()) {
            return this.less(other.toReal());
        }
        if (other.getType().isIntegerType()) {
            return this.less(other.toInteger());
        }
        throw new UnexpectedTypeException(TypeFactory.getInstance().numberType(), other.getType());
    }

    public IBool lessEqual(INumber other) {
        if (other.getType().isRealType()) {
            return this.lessEqual(other.toReal());
        }
        if (other.getType().isIntegerType()) {
            return this.lessEqual(other.toInteger());
        }
        throw new UnexpectedTypeException(TypeFactory.getInstance().numberType(), other.getType());
    }

    public INumber multiply(INumber other) {
        if (other.getType().isRealType()) {
            return this.multiply(other.toReal());
        }
        if (other.getType().isIntegerType()) {
            return this.multiply(other.toInteger());
        }
        throw new UnexpectedTypeException(TypeFactory.getInstance().numberType(), other.getType());
    }

    public INumber subtract(INumber other) {
        if (other.getType().isRealType()) {
            return this.subtract(other.toReal());
        }
        if (other.getType().isIntegerType()) {
            return this.subtract(other.toInteger());
        }
        throw new UnexpectedTypeException(TypeFactory.getInstance().numberType(), other.getType());
    }
}

