/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.math.BigInteger;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.INumber;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.ICanBecomeABigInteger;
import org.eclipse.imp.pdb.facts.impl.fast.AbstractNumberValue;
import org.eclipse.imp.pdb.facts.impl.fast.BigIntegerValue;
import org.eclipse.imp.pdb.facts.impl.fast.ValueFactory;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerValue
extends AbstractNumberValue
implements IInteger,
ICanBecomeABigInteger {
    private static final Type INTEGER_TYPE = TypeFactory.getInstance().integerType();
    private static final int SEVEN_BITS_MASK = 127;
    private static final int FIFTEEN_BITS_MASK = Short.MAX_VALUE;
    private static final int TWENTYTHREE_BITS_MASK = 0x7FFFFF;
    protected final int value;

    public IntegerValue(int value) {
        this.value = value;
    }

    @Override
    public IInteger toInteger() {
        return this;
    }

    @Override
    public Type getType() {
        return INTEGER_TYPE;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public IReal toReal() {
        return ValueFactory.getInstance().real(this.value);
    }

    @Override
    public byte[] getTwosComplementRepresentation() {
        if ((this.value & 0x7F) == this.value) {
            byte[] data = new byte[]{(byte)(this.value & 0x7F)};
            return data;
        }
        if ((this.value & Short.MAX_VALUE) == this.value) {
            byte[] data = new byte[]{(byte)(this.value >> 8 & 0x7F), (byte)(this.value & 0xFF)};
            return data;
        }
        if ((this.value & 0x7FFFFF) == this.value) {
            byte[] data = new byte[]{(byte)(this.value >> 16 & 0x7F), (byte)(this.value >> 8 & 0xFF), (byte)(this.value & 0xFF)};
            return data;
        }
        byte[] data = new byte[]{(byte)(this.value >> 24 & 0xFF), (byte)(this.value >> 16 & 0xFF), (byte)(this.value >> 8 & 0xFF), (byte)(this.value & 0xFF)};
        return data;
    }

    @Override
    public BigInteger toBigInteger() {
        return new BigInteger(this.getTwosComplementRepresentation());
    }

    @Override
    public IInteger add(IInteger other) {
        if (other instanceof BigIntegerValue) {
            return other.add(this);
        }
        int otherIntValue = other.intValue();
        int result = this.value + otherIntValue;
        if (this.value < 0 && otherIntValue < 0 && result >= 0) {
            byte[] intValueData = new byte[]{-1, (byte)(result >>> 24 & 0xFF), (byte)(result >>> 16 & 0xFF), (byte)(result >>> 8 & 0xFF), (byte)(result & 0xFF)};
            return ValueFactory.getInstance().integer(new BigInteger(intValueData));
        }
        if (this.value > 0 && otherIntValue > 0 && result < 0) {
            byte[] intValueData = new byte[]{0, (byte)(result >>> 24 & 0xFF), (byte)(result >>> 16 & 0xFF), (byte)(result >>> 8 & 0xFF), (byte)(result & 0xFF)};
            return ValueFactory.getInstance().integer(new BigInteger(intValueData));
        }
        return ValueFactory.getInstance().integer(result);
    }

    @Override
    public IReal add(IReal other) {
        return (IReal)other.add(this);
    }

    @Override
    public INumber subtract(IReal other) {
        return this.toReal().subtract(other);
    }

    @Override
    public IInteger subtract(IInteger other) {
        if (other instanceof BigIntegerValue) {
            return other.negate().subtract(this.negate());
        }
        int otherIntValue = other.intValue();
        int result = this.value - otherIntValue;
        if (this.value < 0 && otherIntValue > 0 && result > 0) {
            byte[] intValueData = new byte[]{-1, (byte)(result >>> 24 & 0xFF), (byte)(result >>> 16 & 0xFF), (byte)(result >>> 8 & 0xFF), (byte)(result & 0xFF)};
            return ValueFactory.getInstance().integer(new BigInteger(intValueData));
        }
        if (this.value > 0 && otherIntValue < 0 && result < 0) {
            byte[] intValueData = new byte[]{0, (byte)(result >>> 24 & 0xFF), (byte)(result >>> 16 & 0xFF), (byte)(result >>> 8 & 0xFF), (byte)(result & 0xFF)};
            return ValueFactory.getInstance().integer(new BigInteger(intValueData));
        }
        return ValueFactory.getInstance().integer(result);
    }

    @Override
    public IInteger multiply(IInteger other) {
        boolean resultIsPositive;
        if (this.value == 0) {
            return this;
        }
        if (other instanceof BigIntegerValue) {
            return other.multiply(this);
        }
        int otherIntValue = other.intValue();
        if (otherIntValue == 0) {
            return other;
        }
        boolean bl = resultIsPositive = ((this.value ^ otherIntValue ^ Integer.MIN_VALUE) & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        if (resultIsPositive) {
            int div = Integer.MAX_VALUE / otherIntValue;
            if (this.value > 0 ? this.value <= div : this.value >= div) {
                return ValueFactory.getInstance().integer(this.value * other.intValue());
            }
        } else {
            int div = Integer.MIN_VALUE / otherIntValue;
            if (this.value > 0 ? this.value <= div : this.value >= div) {
                return ValueFactory.getInstance().integer(this.value * other.intValue());
            }
        }
        return ValueFactory.getInstance().integer(this.toBigInteger().multiply(((ICanBecomeABigInteger)((Object)other)).toBigInteger()));
    }

    @Override
    public IReal multiply(IReal other) {
        return (IReal)other.multiply(this);
    }

    @Override
    public IInteger divide(IInteger other) {
        if (other instanceof BigIntegerValue) {
            return ValueFactory.getInstance().integer(this.toBigInteger().divide(((ICanBecomeABigInteger)((Object)other)).toBigInteger()));
        }
        return ValueFactory.getInstance().integer(this.value / other.intValue());
    }

    @Override
    public INumber divide(IInteger other, int precision) {
        return this.toReal().divide(other, precision);
    }

    @Override
    public IReal divide(IReal other, int precision) {
        return this.toReal().divide(other, precision);
    }

    @Override
    public IInteger mod(IInteger other) {
        if (other instanceof BigIntegerValue) {
            if (this.value < 0) {
                return ValueFactory.getInstance().integer(~this.value + 1);
            }
            return this;
        }
        int newValue = this.value % other.intValue();
        newValue = newValue >= 0 ? newValue : ~newValue + 1;
        return ValueFactory.getInstance().integer(newValue);
    }

    @Override
    public IInteger remainder(IInteger other) {
        if (other instanceof BigIntegerValue) {
            return this;
        }
        return ValueFactory.getInstance().integer(this.value % other.intValue());
    }

    @Override
    public IInteger negate() {
        return ValueFactory.getInstance().integer(((long)this.value ^ 0xFFFFFFFFFFFFFFFFL) + 1L);
    }

    @Override
    public IBool greater(IInteger other) {
        return ValueFactory.getInstance().bool(this.compare(other) > 0);
    }

    @Override
    public IBool greater(IReal other) {
        return other.lessEqual(this);
    }

    @Override
    public IBool greaterEqual(IInteger other) {
        return ValueFactory.getInstance().bool(this.compare(other) >= 0);
    }

    @Override
    public IBool greaterEqual(IReal other) {
        return other.less(this);
    }

    @Override
    public IBool less(IInteger other) {
        return ValueFactory.getInstance().bool(this.compare(other) < 0);
    }

    @Override
    public IBool less(IReal other) {
        return other.greaterEqual(this);
    }

    @Override
    public IBool lessEqual(IInteger other) {
        return ValueFactory.getInstance().bool(this.compare(other) <= 0);
    }

    @Override
    public IBool lessEqual(IReal other) {
        return other.greater(this);
    }

    @Override
    public int compare(IInteger other) {
        if (other instanceof BigIntegerValue) {
            return ~other.compare(this) + 1;
        }
        if (this.value > other.intValue()) {
            return 1;
        }
        if (this.value < other.intValue()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compare(INumber other) {
        if (other.getType().isIntegerType()) {
            return this.compare(other.toInteger());
        }
        return this.toReal().compare(other);
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitInteger(this);
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            IntegerValue otherInteger = (IntegerValue)o;
            return this.value == otherInteger.value;
        }
        return false;
    }

    @Override
    public boolean isEqual(IValue value) {
        return this.equals(value);
    }

    @Override
    public String getStringRepresentation() {
        return Integer.toString(this.value);
    }

    @Override
    public int signum() {
        return this.value < 0 ? -1 : (this.value == 0 ? 0 : 1);
    }

    @Override
    public IInteger abs() {
        return new IntegerValue(Math.abs(this.value));
    }
}

