/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Iterator;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.ListWriter;
import org.eclipse.imp.pdb.facts.impl.fast.Value;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesList;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class List
extends Value
implements IList {
    protected static final TypeFactory typeFactory = TypeFactory.getInstance();
    protected final Type listType;
    protected final Type elementType;
    protected final ShareableValuesList data;
    protected int hashCode = 0;

    protected List(Type elementType, ShareableValuesList data) {
        this.listType = typeFactory.listType(elementType);
        this.elementType = elementType;
        this.data = data;
        this.hashCode = data.hashCode();
    }

    @Override
    public Type getType() {
        return this.listType;
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public int length() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public IValue get(int index) {
        return (IValue)this.data.get(index);
    }

    @Override
    public boolean contains(IValue element) {
        return this.data.contains(element);
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.data.iterator();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitList(this);
    }

    @Override
    public IList append(IValue element) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.append(element);
        Type newElementType = this.elementType.lub(element.getType());
        return new ListWriter(newElementType, newData).done();
    }

    @Override
    public IList concat(IList other) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        Iterator otherIterator = other.iterator();
        while (otherIterator.hasNext()) {
            newData.append(otherIterator.next());
        }
        Type newElementType = this.elementType.lub(other.getElementType());
        return new ListWriter(newElementType, newData).done();
    }

    @Override
    public IList insert(IValue element) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.insert(element);
        Type newElementType = this.elementType.lub(element.getType());
        return new ListWriter(newElementType, newData).done();
    }

    @Override
    public IList put(int index, IValue element) throws IndexOutOfBoundsException {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.set(index, element);
        Type newElementType = this.elementType.lub(element.getType());
        return new ListWriter(newElementType, newData).done();
    }

    @Override
    public IList delete(int index) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.remove(index);
        return new ListWriter(this.elementType, newData).done();
    }

    @Override
    public IList delete(IValue element) {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.remove(element);
        return new ListWriter(this.elementType, newData).done();
    }

    @Override
    public IList reverse() {
        ShareableValuesList newData = new ShareableValuesList(this.data);
        newData.reverse();
        return new ListWriter(this.elementType, newData).done();
    }

    @Override
    public IList sublist(int offset, int length) {
        ShareableValuesList newData = this.data.subList(offset, length);
        return new ListWriter(this.elementType, newData).done();
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            List otherList = (List)o;
            if (this.hashCode != otherList.hashCode) {
                return false;
            }
            if (this.listType != otherList.listType) {
                return false;
            }
            return this.data.equals(otherList.data);
        }
        return false;
    }

    @Override
    public boolean isEqual(IValue value) {
        if (value == this) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof List) {
            List otherList = (List)value;
            if (this.hashCode != otherList.hashCode) {
                return false;
            }
            if (!this.elementType.comparable(otherList.elementType)) {
                return false;
            }
            return this.data.isEqual(otherList.data);
        }
        return false;
    }
}

