/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IDateTime;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.IRelationWriter;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.ISourceLocation;
import org.eclipse.imp.pdb.facts.IString;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.exceptions.FactParseError;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedElementTypeException;
import org.eclipse.imp.pdb.facts.impl.fast.BigDecimalValue;
import org.eclipse.imp.pdb.facts.impl.fast.BigIntegerValue;
import org.eclipse.imp.pdb.facts.impl.fast.BoolValue;
import org.eclipse.imp.pdb.facts.impl.fast.Constructor;
import org.eclipse.imp.pdb.facts.impl.fast.DateTimeValue;
import org.eclipse.imp.pdb.facts.impl.fast.IntegerValue;
import org.eclipse.imp.pdb.facts.impl.fast.ListWriter;
import org.eclipse.imp.pdb.facts.impl.fast.MapWriter;
import org.eclipse.imp.pdb.facts.impl.fast.Node;
import org.eclipse.imp.pdb.facts.impl.fast.RelationWriter;
import org.eclipse.imp.pdb.facts.impl.fast.SetWriter;
import org.eclipse.imp.pdb.facts.impl.fast.SourceLocationValue;
import org.eclipse.imp.pdb.facts.impl.fast.StringValue;
import org.eclipse.imp.pdb.facts.impl.fast.Tuple;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.util.ShareableHashMap;

public class ValueFactory
implements IValueFactory {
    private static final TypeFactory tf = TypeFactory.getInstance();
    private static final Type EMPTY_TUPLE_TYPE = TypeFactory.getInstance().tupleEmpty();
    private static final String INTEGER_MAX_STRING = "2147483647";
    private static final String NEGATIVE_INTEGER_MAX_STRING = "-2147483648";

    protected ValueFactory() {
    }

    public static ValueFactory getInstance() {
        return InstanceKeeper.instance;
    }

    public IBool bool(boolean value) {
        return BoolValue.getBoolValue(value);
    }

    public IInteger integer(int value) {
        return new IntegerValue(value);
    }

    public IInteger integer(long value) {
        if ((value & Integer.MAX_VALUE) == value || (value & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return this.integer((int)value);
        }
        byte[] valueData = new byte[]{(byte)(value >>> 56 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value & 0xFFL)};
        return this.integer(valueData);
    }

    public IInteger integer(String integerValue) {
        if (integerValue.startsWith("-")) {
            if (integerValue.length() < 11 || integerValue.length() == 11 && integerValue.compareTo(NEGATIVE_INTEGER_MAX_STRING) <= 0) {
                return new IntegerValue(Integer.parseInt(integerValue));
            }
            return new BigIntegerValue(new BigInteger(integerValue));
        }
        if (integerValue.length() < 10 || integerValue.length() == 10 && integerValue.compareTo(INTEGER_MAX_STRING) <= 0) {
            return new IntegerValue(Integer.parseInt(integerValue));
        }
        return new BigIntegerValue(new BigInteger(integerValue));
    }

    public IInteger integer(byte[] integerData) {
        if (integerData.length <= 4) {
            int value = 0;
            int i = integerData.length - 1;
            int j = 0;
            while (i >= 0) {
                value |= (integerData[i] & 0xFF) << j * 8;
                --i;
                ++j;
            }
            return new IntegerValue(value);
        }
        return new BigIntegerValue(new BigInteger(integerData));
    }

    public IInteger integer(BigInteger value) {
        if (value.bitLength() > 31) {
            return new BigIntegerValue(value);
        }
        return new IntegerValue(value.intValue());
    }

    public IReal real(double value) {
        return new BigDecimalValue(BigDecimal.valueOf(value));
    }

    public IReal real(String doubleValue) {
        return new BigDecimalValue(new BigDecimal(doubleValue));
    }

    public IReal real(BigDecimal value) {
        return new BigDecimalValue(value);
    }

    public IString string(String value) {
        return new StringValue(value);
    }

    public ISourceLocation sourceLocation(URI url, int offset, int length, int beginLine, int endLine, int beginCol, int endCol) {
        return new SourceLocationValue(url, offset, length, beginLine, endLine, beginCol, endCol);
    }

    public ISourceLocation sourceLocation(String path, int offset, int length, int beginLine, int endLine, int beginCol, int endCol) {
        try {
            return this.sourceLocation(new URI("file://" + path), offset, length, beginLine, endLine, beginCol, endCol);
        }
        catch (URISyntaxException e) {
            throw new FactParseError("Illegal path syntax: " + path, e);
        }
    }

    public ISourceLocation sourceLocation(URI uri) {
        return this.sourceLocation(uri, -1, -1, -1, -1, -1, -1);
    }

    public ISourceLocation sourceLocation(String path) {
        return this.sourceLocation(path, -1, -1, -1, -1, -1, -1);
    }

    public IDateTime datetime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return new DateTimeValue(year, month, day, hour, minute, second, millisecond);
    }

    public IDateTime datetime(int year, int month, int day, int hour, int minute, int second, int millisecond, int timeZoneHourOffset, int timeZoneMinuteOffset) {
        return new DateTimeValue(year, month, day, hour, minute, second, millisecond, timeZoneHourOffset, timeZoneMinuteOffset);
    }

    public IDateTime date(int year, int month, int day) {
        return new DateTimeValue(year, month, day);
    }

    public IDateTime time(int hour, int minute, int second, int millisecond) {
        return new DateTimeValue(hour, minute, second, millisecond);
    }

    public IDateTime time(int hour, int minute, int second, int millisecond, int timeZoneHourOffset, int timeZoneMinuteOffset) {
        return new DateTimeValue(hour, minute, second, millisecond, timeZoneHourOffset, timeZoneMinuteOffset);
    }

    public IDateTime datetime(long instant) {
        return new DateTimeValue(instant);
    }

    public IListWriter listWriter(Type elementType) {
        return new ListWriter(elementType);
    }

    public IListWriter listWriter() {
        return new ListWriter();
    }

    public IMapWriter mapWriter(Type keyType, Type valueType) {
        return new MapWriter(keyType, valueType);
    }

    public IMapWriter mapWriter() {
        return new MapWriter();
    }

    public ISetWriter setWriter(Type elementType) {
        if (elementType.isTupleType()) {
            return this.relationWriter(elementType);
        }
        return new SetWriter(elementType);
    }

    public ISetWriter setWriter() {
        return new SetWriter();
    }

    public IRelationWriter relationWriter(Type tupleType) {
        return new RelationWriter(tupleType);
    }

    public IRelationWriter relationWriter() {
        return new RelationWriter();
    }

    public IList list(Type elementType) {
        return this.listWriter(elementType).done();
    }

    public IList list(IValue ... elements) {
        IListWriter listWriter = this.listWriter(ValueFactory.lub(elements));
        listWriter.append(elements);
        return listWriter.done();
    }

    public IMap map(Type keyType, Type valueType) {
        return this.mapWriter(keyType, valueType).done();
    }

    public ISet set(Type elementType) {
        return this.setWriter(elementType).done();
    }

    public ISet set(IValue ... elements) {
        Type elementType = ValueFactory.lub(elements);
        ISetWriter setWriter = this.setWriter(elementType);
        setWriter.insert(elements);
        return setWriter.done();
    }

    public IRelation relation(Type tupleType) {
        return this.relationWriter(tupleType).done();
    }

    public IRelation relation(IValue ... elements) {
        Type elementType = ValueFactory.lub(elements);
        if (!elementType.isTupleType()) {
            throw new UnexpectedElementTypeException(tf.tupleType(tf.voidType()), elementType);
        }
        IRelationWriter relationWriter = this.relationWriter(elementType);
        relationWriter.insert(elements);
        return relationWriter.done();
    }

    public INode node(String name) {
        return new Node(name, new IValue[0]);
    }

    public INode node(String name, IValue ... children) {
        return new Node(name, (IValue[])children.clone());
    }

    public IConstructor constructor(Type constructorType) {
        Type params = constructorType.getAbstractDataType().getTypeParameters();
        if (!params.isVoidType()) {
            ShareableHashMap<Type, Type> bindings = new ShareableHashMap<Type, Type>();
            for (Type p : params) {
                if (!p.isParameterType()) continue;
                bindings.put(p, TypeFactory.getInstance().voidType());
            }
            constructorType = constructorType.instantiate(bindings);
        }
        return new Constructor(constructorType, new IValue[0]);
    }

    public IConstructor constructor(Type constructorType, IValue ... children) {
        Type instantiatedType;
        if (!constructorType.getAbstractDataType().isParameterized()) {
            instantiatedType = constructorType;
        } else {
            ShareableHashMap<Type, Type> bindings = new ShareableHashMap<Type, Type>();
            TypeFactory tf = TypeFactory.getInstance();
            Type params = constructorType.getAbstractDataType().getTypeParameters();
            for (Type p : params) {
                if (!p.isParameterType()) continue;
                bindings.put(p, tf.voidType());
            }
            constructorType.getFieldTypes().match(tf.tupleType(children), bindings);
            instantiatedType = constructorType.instantiate(bindings);
        }
        return new Constructor(instantiatedType, (IValue[])children.clone());
    }

    public ITuple tuple() {
        return new Tuple(EMPTY_TUPLE_TYPE, new IValue[0]);
    }

    public ITuple tuple(IValue ... args) {
        int nrOfArgs = args.length;
        Type[] elementTypes = new Type[nrOfArgs];
        for (int i = nrOfArgs - 1; i >= 0; --i) {
            elementTypes[i] = args[i].getType();
        }
        return new Tuple(tf.tupleType(elementTypes), (IValue[])args.clone());
    }

    private static Type lub(IValue ... elements) {
        Type elementType = TypeFactory.getInstance().voidType();
        for (int i = elements.length - 1; i >= 0; --i) {
            elementType = elementType.lub(elements[i].getType());
        }
        return elementType;
    }

    private static class InstanceKeeper {
        public static final ValueFactory instance = new ValueFactory();

        private InstanceKeeper() {
        }
    }
}

