/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.reference;

import java.util.HashSet;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.IRelationWriter;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISetWriter;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.IllegalOperationException;
import org.eclipse.imp.pdb.facts.impl.reference.Set;
import org.eclipse.imp.pdb.facts.impl.reference.Tuple;
import org.eclipse.imp.pdb.facts.impl.reference.ValueFactory;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Relation
extends Set
implements IRelation {
    Relation(Type type, HashSet<IValue> content) {
        super(TypeFactory.getInstance().relTypeFromTuple(type), content);
    }

    @Override
    public int arity() {
        return this.getType().getArity();
    }

    @Override
    public IRelation closure() throws FactTypeUseException {
        this.getType().closure();
        IRelation tmp = this;
        int prevCount = 0;
        while (prevCount != tmp.size()) {
            prevCount = tmp.size();
            tmp = (IRelation)tmp.union(tmp.compose(tmp));
        }
        return tmp;
    }

    @Override
    public IRelation closureStar() throws FactTypeUseException {
        Type resultType = this.getType().closure();
        IRelationWriter reflex = Relation.createRelationWriter(resultType.getElementType());
        for (IValue e : this.carrier()) {
            reflex.insert(new Tuple(e, e));
        }
        return (IRelation)this.closure().union(reflex.done());
    }

    @Override
    public IRelation compose(IRelation other) throws FactTypeUseException {
        Type resultType = this.getType().compose(other.getType());
        IRelationWriter w = ValueFactory.getInstance().relationWriter(resultType.getFieldTypes());
        for (IValue v1 : this.content) {
            ITuple tuple1 = (ITuple)v1;
            for (IValue t2 : other) {
                ITuple tuple2 = (ITuple)t2;
                if (!tuple1.get(1).isEqual(tuple2.get(0))) continue;
                w.insert(new Tuple(tuple1.get(0), tuple2.get(1)));
            }
        }
        return w.done();
    }

    @Override
    public ISet carrier() {
        Type newType = this.getType().carrier();
        ISetWriter w = Set.createSetWriter(newType.getElementType());
        for (IValue t : this) {
            w.insertAll((ITuple)t);
        }
        return w.done();
    }

    @Override
    public ISet domain() {
        Type relType = this.getType();
        ISetWriter w = Set.createSetWriter(relType.getFieldType(0));
        for (IValue elem : this) {
            ITuple tuple = (ITuple)elem;
            w.insert(tuple.get(0));
        }
        return w.done();
    }

    @Override
    public ISet range() {
        Type relType = this.getType();
        int last = relType.getArity() - 1;
        ISetWriter w = Set.createSetWriter(relType.getFieldType(last));
        for (IValue elem : this) {
            ITuple tuple = (ITuple)elem;
            w.insert(tuple.get(last));
        }
        return w.done();
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitRelation(this);
    }

    @Override
    public Type getFieldTypes() {
        return this.fType.getFieldTypes();
    }

    public static IRelationWriter createRelationWriter(Type tupleType) {
        return new RelationWriter(tupleType);
    }

    public static IRelationWriter createRelationWriter() {
        return new RelationWriter();
    }

    @Override
    public ISet select(int ... fields) {
        Type eltType = this.getFieldTypes().select(fields);
        ISetWriter w = ValueFactory.getInstance().setWriter(eltType);
        for (IValue v : this) {
            w.insert(((ITuple)v).select(fields));
        }
        return w.done();
    }

    @Override
    public ISet select(String ... fields) {
        int[] indexes = new int[fields.length];
        int i = 0;
        if (this.getFieldTypes().hasFieldNames()) {
            for (String field : fields) {
                indexes[i++] = this.getFieldTypes().getFieldIndex(field);
            }
            return this.select(indexes);
        }
        throw new IllegalOperationException("select with field names", this.getType());
    }

    protected static class RelationWriter
    extends Set.SetWriter
    implements IRelationWriter {
        public RelationWriter(Type eltType) {
            super(eltType);
        }

        public RelationWriter() {
        }

        public IRelation done() {
            if (this.constructedSet == null) {
                this.constructedSet = new Relation(this.eltType, this.setContent);
            }
            return (IRelation)((Object)this.constructedSet);
        }
    }
}

