/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.imp.pdb.facts.IListWriter;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.IValueFactory;
import org.eclipse.imp.pdb.facts.IWriter;
import org.eclipse.imp.pdb.facts.exceptions.FactParseError;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.exceptions.OverloadingNotSupportedException;
import org.eclipse.imp.pdb.facts.exceptions.UnexpectedTypeException;
import org.eclipse.imp.pdb.facts.io.AbstractReader;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.type.TypeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTextReader
extends AbstractReader {
    private static final char START_OF_LOC = '|';
    private static final char START_OF_STRING = '\"';
    private static final char END_OF_STRING = '\"';
    private static final char START_OF_MAP = '(';
    private static final char START_OF_ARGUMENTS = '(';
    private static final char END_OF_ARGUMENTS = ')';
    private static final char START_OF_TUPLE = '<';
    private static final char START_OF_SET = '{';
    private static final char START_OF_LIST = '[';
    private static final char END_OF_TUPLE = '>';
    private static final char COMMA_SEPARATOR = ',';
    private static final char END_OF_MAP = ')';
    private static final char DOUBLE_DOT = '.';
    private static final char END_OF_SET = '}';
    private static final char END_OF_LIST = ']';
    private static final char END_OF_LOCATION = '|';
    private static final char START_OF_DATETIME = '$';
    private static final char NEGATIVE_SIGN = '-';
    private TypeStore store;
    private NoWhiteSpaceInputStream stream;
    private IValueFactory factory;
    private TypeFactory types;
    private int current;

    @Override
    public IValue read(IValueFactory factory, TypeStore store, Type type, InputStream stream) throws FactTypeUseException, IOException {
        this.store = store;
        this.stream = new NoWhiteSpaceInputStream(stream);
        this.factory = factory;
        this.types = TypeFactory.getInstance();
        this.current = stream.read();
        return this.readValue(type);
    }

    private IValue readValue(Type expected) throws IOException {
        IValue result = null;
        if (Character.isDigit(this.current) || this.current == 46 || this.current == 45) {
            result = this.readNumber(expected);
        } else if (Character.isJavaIdentifierStart(this.current) && 36 != this.current || this.current == 92) {
            result = this.readNode(expected);
        } else {
            switch (this.current) {
                case 34: {
                    result = this.readString(expected);
                    break;
                }
                case 91: {
                    result = this.readList(expected);
                    break;
                }
                case 123: {
                    result = this.readSet(expected);
                    break;
                }
                case 60: {
                    result = this.readTuple(expected);
                    break;
                }
                case 40: {
                    result = this.readMap(expected);
                    break;
                }
                case 124: {
                    result = this.readLocation(expected);
                    break;
                }
                case 36: {
                    result = this.readDateTime(expected);
                    break;
                }
                default: {
                    this.unexpected();
                }
            }
        }
        if (!result.getType().isSubtypeOf(expected)) {
            throw new UnexpectedTypeException(expected, result.getType());
        }
        if (this.current == 91) {
            if (result.getType().isSubtypeOf(this.types.nodeType())) {
                result = this.readAnnos(expected, (INode)result);
            } else {
                this.unexpected(93);
            }
        }
        return result;
    }

    private IValue readLocation(Type expected) throws IOException {
        try {
            String url = this.parseURL();
            if (this.current == 40) {
                ArrayList<IValue> args = new ArrayList<IValue>(4);
                this.readFixed(this.types.valueType(), ')', args);
                if (!args.get(0).getType().isSubtypeOf(this.types.integerType())) {
                    throw new UnexpectedTypeException(this.types.integerType(), args.get(0).getType());
                }
                if (!args.get(1).getType().isSubtypeOf(this.types.integerType())) {
                    throw new UnexpectedTypeException(this.types.integerType(), args.get(1).getType());
                }
                Type posType = this.types.tupleType(this.types.integerType(), this.types.integerType());
                if (!args.get(2).getType().isSubtypeOf(posType)) {
                    throw new UnexpectedTypeException(posType, args.get(2).getType());
                }
                if (!args.get(3).getType().isSubtypeOf(posType)) {
                    throw new UnexpectedTypeException(posType, args.get(3).getType());
                }
                int offset = Integer.parseInt(((Object)args.get(0)).toString());
                int length = Integer.parseInt(((Object)args.get(1)).toString());
                int beginLine = Integer.parseInt(((Object)((ITuple)args.get(2)).get(0)).toString());
                int beginColumn = Integer.parseInt(((Object)((ITuple)args.get(2)).get(1)).toString());
                int endLine = Integer.parseInt(((Object)((ITuple)args.get(3)).get(0)).toString());
                int endColumn = Integer.parseInt(((Object)((ITuple)args.get(3)).get(1)).toString());
                return this.factory.sourceLocation(new URI(url), offset, length, beginLine, endLine, beginColumn, endColumn);
            }
            return this.factory.sourceLocation(new URI(url));
        }
        catch (URISyntaxException e) {
            throw new FactParseError(e.getMessage(), this.stream.offset, e);
        }
    }

    private String parseURL() throws IOException {
        this.current = this.stream.read();
        StringBuilder result = new StringBuilder();
        while (this.current != 124) {
            result.append((char)this.current);
            this.current = this.stream.read();
            if (this.current != -1) continue;
            this.unexpected();
        }
        this.current = this.stream.read();
        return result.toString();
    }

    private IValue readMap(Type expected) throws IOException {
        Type keyType = expected.isMapType() ? expected.getKeyType() : this.types.valueType();
        Type valueType = expected.isMapType() ? expected.getValueType() : this.types.valueType();
        IMapWriter w = expected.isMapType() ? this.factory.mapWriter(keyType, valueType) : this.factory.mapWriter();
        this.checkAndRead('(');
        while (this.current != 41) {
            IValue key = this.readValue(keyType);
            this.checkAndRead(':');
            IValue value = this.readValue(valueType);
            w.put(key, value);
            if (this.current != 44 || this.current == 41) break;
            this.checkAndRead(',');
        }
        this.checkAndRead(')');
        return w.done();
    }

    private IValue readTuple(Type expected) throws IOException {
        ArrayList<IValue> arr = new ArrayList<IValue>();
        this.readFixed(expected, '>', arr);
        IValue[] result = new IValue[arr.size()];
        return this.factory.tuple(arr.toArray(result));
    }

    private IValue readSet(Type expected) throws FactTypeUseException, IOException {
        Type elemType = expected.isSetType() ? expected.getElementType() : this.types.valueType();
        return this.readContainer(elemType, expected.isSetType() ? this.factory.setWriter(elemType) : this.factory.setWriter(), '}');
    }

    private IValue readList(Type expected) throws FactTypeUseException, IOException {
        Type elemType = expected.isListType() ? expected.getElementType() : this.types.valueType();
        return this.readList(elemType, expected.isListType() ? this.factory.listWriter(expected.getElementType()) : this.factory.listWriter(), ']');
    }

    private IValue readNumber(Type expected) throws IOException {
        StringBuilder builder = new StringBuilder();
        do {
            builder.append((char)this.current);
            this.current = this.stream.read();
        } while (Character.isDigit(this.current) || this.current == 46);
        String val = builder.toString();
        try {
            return this.factory.integer(val);
        }
        catch (NumberFormatException e) {
            try {
                return this.factory.real(val);
            }
            catch (NumberFormatException e2) {
                this.unexpected(this.current);
                return null;
            }
        }
    }

    private IValue readNode(Type expected) throws IOException {
        String id = this.readIdentifier();
        if (id.equals("true")) {
            return this.factory.bool(true);
        }
        if (id.equals("false")) {
            return this.factory.bool(false);
        }
        if (this.current == 40) {
            ArrayList<IValue> arr = new ArrayList<IValue>();
            Type args = expected;
            if (expected.isAbstractDataType()) {
                Set<Type> alternatives = this.store.lookupConstructor(expected, id);
                if (alternatives.size() > 1) {
                    throw new OverloadingNotSupportedException(expected, id);
                }
                args = alternatives.size() == 0 ? this.types.valueType() : alternatives.iterator().next().getFieldTypes();
            }
            this.readFixed(args, ')', arr);
            IValue[] result = new IValue[arr.size()];
            result = arr.toArray(result);
            return expected.make(this.factory, this.store, id, result);
        }
        Type args = this.types.tupleType(new Type[0]);
        Type cons = expected.isAbstractDataType() ? this.store.lookupConstructor(expected, id, args) : this.store.lookupFirstConstructor(id, args);
        if (cons != null) {
            return cons.make(this.factory);
        }
        return this.factory.node(id);
    }

    private boolean readAndAppendIfNumeric(StringBuilder buf) throws IOException {
        this.current = this.stream.read();
        if (Character.isDigit(this.current)) {
            buf.append((char)this.current);
            return true;
        }
        return false;
    }

    private String readDate(char firstChar) throws IOException, FactParseError {
        boolean res;
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append(firstChar);
        for (i = 0; i < 3; ++i) {
            res = this.readAndAppendIfNumeric(buf);
            if (res) continue;
            throw new FactParseError("Error reading date, expected digit, found: " + this.current, this.stream.offset);
        }
        this.current = this.stream.read();
        if (45 != this.current) {
            throw new FactParseError("Error reading date, expected '-', found: " + this.current, this.stream.offset);
        }
        for (i = 0; i < 2; ++i) {
            res = this.readAndAppendIfNumeric(buf);
            if (res) continue;
            throw new FactParseError("Error reading date, expected digit, found: " + this.current, this.stream.offset);
        }
        this.current = this.stream.read();
        if (45 != this.current) {
            throw new FactParseError("Error reading date, expected '-', found: " + this.current, this.stream.offset);
        }
        for (i = 0; i < 2; ++i) {
            res = this.readAndAppendIfNumeric(buf);
            if (res) continue;
            throw new FactParseError("Error reading date, expected digit, found: " + this.current, this.stream.offset);
        }
        return buf.toString();
    }

    private String readTime() throws IOException, FactParseError {
        boolean res;
        int i;
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < 2; ++i) {
            res = this.readAndAppendIfNumeric(buf);
            if (res) continue;
            throw new FactParseError("Error reading time, expected digit, found: " + this.current, this.stream.offset);
        }
        this.current = this.stream.read();
        if (58 != this.current) {
            throw new FactParseError("Error reading time, expected ':', found: " + this.current, this.stream.offset);
        }
        for (i = 0; i < 2; ++i) {
            res = this.readAndAppendIfNumeric(buf);
            if (res) continue;
            throw new FactParseError("Error reading time, expected digit, found: " + this.current, this.stream.offset);
        }
        this.current = this.stream.read();
        if (58 != this.current) {
            throw new FactParseError("Error reading time, expected ':', found: " + this.current, this.stream.offset);
        }
        for (i = 0; i < 2; ++i) {
            res = this.readAndAppendIfNumeric(buf);
            if (res) continue;
            throw new FactParseError("Error reading time, expected digit, found: " + this.current, this.stream.offset);
        }
        this.current = this.stream.read();
        if (46 != this.current) {
            throw new FactParseError("Error reading time, expected '.', found: " + this.current, this.stream.offset);
        }
        for (i = 0; i < 3; ++i) {
            res = this.readAndAppendIfNumeric(buf);
            if (res) continue;
            throw new FactParseError("Error reading time, expected digit, found: " + this.current, this.stream.offset);
        }
        this.current = this.stream.read();
        if (43 != this.current && 45 != this.current) {
            throw new FactParseError("Error reading time, expected '+' or '-', found: " + this.current, this.stream.offset);
        }
        buf.append((char)this.current);
        for (i = 0; i < 2; ++i) {
            res = this.readAndAppendIfNumeric(buf);
            if (res) continue;
            throw new FactParseError("Error reading time, expected digit, found: " + this.current, this.stream.offset);
        }
        for (i = 0; i < 2; ++i) {
            res = this.readAndAppendIfNumeric(buf);
            if (res) continue;
            throw new FactParseError("Error reading time, expected digit, found: " + this.current, this.stream.offset);
        }
        return buf.toString();
    }

    private IValue readDateTime(Type expected) throws IOException, FactParseError {
        String formatString = "";
        String toParse = "";
        boolean isDate = false;
        boolean isTime = false;
        this.current = this.stream.read();
        if (84 == this.current || 116 == this.current) {
            toParse = this.readTime();
            formatString = "HHmmssSSSZZZZZ";
            isTime = true;
            this.current = this.stream.read();
        } else {
            toParse = this.readDate((char)this.current);
            this.current = this.stream.read();
            if (84 == this.current || 116 == this.current) {
                toParse = toParse + this.readTime();
                formatString = "yyyyMMddHHmmssSSSZZZZZ";
                this.current = this.stream.read();
            } else {
                formatString = "yyyyMMdd";
                isDate = true;
            }
        }
        SimpleDateFormat df = new SimpleDateFormat(formatString);
        try {
            Calendar cal = Calendar.getInstance();
            Date dt = df.parse(toParse);
            cal.setTime(dt);
            if (isDate) {
                return this.factory.date(cal.get(1), cal.get(2) + 1, cal.get(5));
            }
            int hourOffset = cal.get(15) / 3600000;
            int minuteOffset = cal.get(15) / 60000 % 60;
            if (isTime) {
                return this.factory.time(cal.get(11), cal.get(12), cal.get(13), cal.get(14), hourOffset, minuteOffset);
            }
            return this.factory.datetime(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), hourOffset, minuteOffset);
        }
        catch (ParseException pe) {
            throw new FactParseError("Unable to parse datatime string " + toParse + " using format string " + formatString, this.stream.offset, pe);
        }
    }

    private String readIdentifier() throws IOException {
        boolean escaped;
        StringBuilder builder = new StringBuilder();
        boolean bl = escaped = this.current == 92;
        if (escaped) {
            this.current = this.stream.read();
        }
        while (Character.isJavaIdentifierStart(this.current) || Character.isJavaIdentifierPart(this.current) || escaped && this.current == 45) {
            builder.append((char)this.current);
            this.current = this.stream.read();
        }
        return builder.toString();
    }

    private IValue readString(Type expected) throws IOException {
        StringBuilder builder = new StringBuilder();
        this.current = this.stream.read();
        while (this.current != 34) {
            if (this.current == 92) {
                this.current = this.stream.read();
                switch (this.current) {
                    case 110: {
                        builder.append('\n');
                        break;
                    }
                    case 116: {
                        builder.append('\t');
                        break;
                    }
                    case 114: {
                        builder.append('\r');
                        break;
                    }
                    case 34: {
                        builder.append('\"');
                        break;
                    }
                    case 62: {
                        builder.append('>');
                        break;
                    }
                    case 60: {
                        builder.append('<');
                        break;
                    }
                    case 39: {
                        builder.append('\'');
                        break;
                    }
                    case 92: {
                        builder.append('\\');
                    }
                }
                this.current = this.stream.read();
                continue;
            }
            builder.append((char)this.current);
            this.current = this.stream.read();
        }
        String str = builder.toString();
        this.current = this.stream.read();
        if (this.current == 40) {
            ArrayList<IValue> arr = new ArrayList<IValue>();
            this.readFixed(expected, ')', arr);
            IValue[] result = new IValue[arr.size()];
            result = arr.toArray(result);
            return this.factory.node(str, result);
        }
        return this.factory.string(str);
    }

    private IValue readAnnos(Type expected, INode result) throws IOException {
        this.current = this.stream.read();
        while (this.current != 93) {
            this.checkAndRead('@');
            String key = this.readIdentifier();
            this.checkAndRead('=');
            Type annoType = this.getAnnoType(expected, key);
            IValue value = this.readValue(annoType);
            result = result.setAnnotation(key, value);
            if (this.current == 93) {
                this.current = this.stream.read();
                break;
            }
            this.checkAndRead(',');
        }
        return result;
    }

    private Type getAnnoType(Type expected, String key) {
        Type annoType = expected.isAbstractDataType() || expected.isConstructorType() ? (expected.declaresAnnotation(this.store, key) ? this.store.getAnnotationType(expected, key) : this.types.valueType()) : this.types.valueType();
        return annoType;
    }

    private void readFixed(Type expected, char end, List<IValue> arr) throws IOException {
        this.current = this.stream.read();
        int i = 0;
        while (this.current != end) {
            Type exp = expected.isTupleType() ? expected.getFieldType(i) : this.types.valueType();
            arr.add(this.readValue(exp));
            if (this.current != 44 || this.current == end) break;
            this.current = this.stream.read();
            ++i;
        }
        this.checkAndRead(end);
    }

    private IValue readContainer(Type elemType, IWriter w, char end) throws FactTypeUseException, IOException {
        this.current = this.stream.read();
        int i = 0;
        while (this.current != end) {
            w.insert(this.readValue(elemType));
            if (this.current != 44 || this.current == end) break;
            this.current = this.stream.read();
            ++i;
        }
        this.checkAndRead(end);
        return w.done();
    }

    private IValue readList(Type elemType, IListWriter w, char end) throws FactTypeUseException, IOException {
        this.current = this.stream.read();
        int i = 0;
        while (this.current != end) {
            w.append(this.readValue(elemType));
            if (this.current != 44 || this.current == end) break;
            this.current = this.stream.read();
            ++i;
        }
        this.checkAndRead(end);
        return w.done();
    }

    private void checkAndRead(char c) throws IOException {
        if (this.current != c) {
            this.unexpected(c);
        }
        this.current = this.stream.read();
    }

    private void unexpected(int c) {
        throw new FactParseError("Expected " + (char)c + " but got " + (char)this.current, this.stream.getOffset());
    }

    private void unexpected() {
        throw new FactParseError("Unexpected " + (char)this.current, this.stream.getOffset());
    }

    private class NoWhiteSpaceInputStream
    extends InputStream {
        private InputStream wrapped;
        int offset;
        int line;
        int column;
        boolean inString = false;
        int prev = -1;

        public NoWhiteSpaceInputStream(InputStream wrapped) {
            this.wrapped = wrapped;
        }

        public int read() throws IOException {
            int r = this.wrapped.read();
            ++this.offset;
            ++this.column;
            if (!this.inString && r == 34) {
                this.inString = true;
            } else if (this.inString && this.prev != 92 && r == 34) {
                this.inString = false;
            }
            if (!this.inString) {
                while (Character.isWhitespace(r)) {
                    ++this.offset;
                    if (r == 10) {
                        ++this.line;
                        this.column = 0;
                    } else {
                        ++this.column;
                    }
                    r = this.wrapped.read();
                }
            }
            this.prev = r;
            return r;
        }

        int getOffset() {
            return this.offset;
        }
    }
}

