/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.io;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IBool;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IDateTime;
import org.eclipse.imp.pdb.facts.IExternalValue;
import org.eclipse.imp.pdb.facts.IInteger;
import org.eclipse.imp.pdb.facts.IList;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.INode;
import org.eclipse.imp.pdb.facts.IReal;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.ISourceLocation;
import org.eclipse.imp.pdb.facts.IString;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.io.IValueWriter;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeStore;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

public class StandardTextWriter
implements IValueWriter {
    private final boolean indent;
    private final int tabSize;

    public StandardTextWriter() {
        this(false);
    }

    public StandardTextWriter(boolean indent) {
        this(indent, 2);
    }

    public StandardTextWriter(boolean indent, int tabSize) {
        this.indent = indent;
        this.tabSize = tabSize;
    }

    public void write(IValue value, OutputStream stream) throws IOException {
        try {
            value.accept(new Writer(stream, this.indent, this.tabSize));
        }
        catch (VisitorException e) {
            throw (IOException)e.getCause();
        }
    }

    public void write(IValue value, OutputStream stream, TypeStore typeStore) throws IOException {
        this.write(value, stream);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Writer
    implements IValueVisitor<IValue> {
        private final OutputStream stream;
        private final int tabSize;
        private final boolean indent;
        private int tab = 0;

        public Writer(OutputStream stream, boolean indent, int tabSize) {
            this.stream = stream;
            this.indent = indent;
            this.tabSize = tabSize;
        }

        private void append(String string) throws VisitorException {
            try {
                this.stream.write(string.getBytes());
            }
            catch (IOException e) {
                throw new VisitorException(e);
            }
        }

        private void append(char c) throws VisitorException {
            try {
                this.stream.write(c);
            }
            catch (IOException e) {
                throw new VisitorException(e);
            }
        }

        private void tab() {
            ++this.tab;
        }

        private void untab() {
            --this.tab;
        }

        @Override
        public IValue visitBoolean(IBool boolValue) throws VisitorException {
            this.append(boolValue.getValue() ? "true" : "false");
            return boolValue;
        }

        @Override
        public IValue visitConstructor(IConstructor o) throws VisitorException {
            return this.visitNode(o);
        }

        @Override
        public IValue visitReal(IReal o) throws VisitorException {
            this.append(o.getStringRepresentation());
            return o;
        }

        @Override
        public IValue visitInteger(IInteger o) throws VisitorException {
            this.append(o.getStringRepresentation());
            return o;
        }

        @Override
        public IValue visitList(IList o) throws VisitorException {
            this.append('[');
            boolean indent = this.checkIndent(o);
            Iterator listIterator = o.iterator();
            this.tab();
            this.indent(indent);
            if (listIterator.hasNext()) {
                ((IValue)listIterator.next()).accept(this);
                while (listIterator.hasNext()) {
                    this.append(',');
                    if (indent) {
                        this.indent();
                    }
                    ((IValue)listIterator.next()).accept(this);
                }
            }
            this.untab();
            this.indent(indent);
            this.append(']');
            return o;
        }

        @Override
        public IValue visitMap(IMap o) throws VisitorException {
            this.append('(');
            this.tab();
            boolean indent = this.checkIndent(o);
            this.indent(indent);
            Iterator<IValue> mapIterator = o.iterator();
            if (mapIterator.hasNext()) {
                IValue key = mapIterator.next();
                key.accept(this);
                this.append(':');
                o.get(key).accept(this);
                while (mapIterator.hasNext()) {
                    this.append(',');
                    this.indent(indent);
                    key = mapIterator.next();
                    key.accept(this);
                    this.append(':');
                    o.get(key).accept(this);
                }
            }
            this.untab();
            this.indent(indent);
            this.append(')');
            return o;
        }

        @Override
        public IValue visitNode(INode o) throws VisitorException {
            String name = o.getName();
            if (name.indexOf(45) != -1) {
                this.append('\\');
            }
            this.append(name);
            boolean indent = this.checkIndent(o);
            this.append('(');
            this.tab();
            this.indent(indent);
            Iterator<IValue> it = o.iterator();
            while (it.hasNext()) {
                it.next().accept(this);
                if (!it.hasNext()) continue;
                this.append(',');
                this.indent(indent);
            }
            this.append(')');
            this.untab();
            if (o.hasAnnotations()) {
                this.append('[');
                this.tab();
                this.indent();
                int i = 0;
                Map<String, IValue> annotations = o.getAnnotations();
                for (String key : annotations.keySet()) {
                    this.append("@" + key + "=");
                    annotations.get(key).accept(this);
                    if (++i >= annotations.size()) continue;
                    this.append(",");
                    this.indent();
                }
                this.untab();
                this.indent();
                this.append(']');
            }
            return o;
        }

        private void indent() throws VisitorException {
            this.indent(this.indent);
        }

        private void indent(boolean indent) throws VisitorException {
            if (indent) {
                this.append('\n');
                for (int i = 0; i < this.tabSize * this.tab; ++i) {
                    this.append(' ');
                }
            }
        }

        @Override
        public IValue visitRelation(IRelation o) throws VisitorException {
            return this.visitSet(o);
        }

        @Override
        public IValue visitSet(ISet o) throws VisitorException {
            this.append('{');
            boolean indent = this.checkIndent(o);
            this.tab();
            this.indent(indent);
            Iterator setIterator = o.iterator();
            if (setIterator.hasNext()) {
                ((IValue)setIterator.next()).accept(this);
                while (setIterator.hasNext()) {
                    this.append(",");
                    this.indent(indent);
                    ((IValue)setIterator.next()).accept(this);
                }
            }
            this.untab();
            this.indent(indent);
            this.append('}');
            return o;
        }

        private boolean checkIndent(ISet o) {
            if (this.indent && o.size() > 1) {
                for (IValue x : o) {
                    Type type = x.getType();
                    if (!type.isNodeType() && !type.isTupleType() && !type.isListType() && !type.isSetType() && !type.isMapType() && !type.isRelationType()) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean checkIndent(IList o) {
            if (this.indent && o.length() > 1) {
                for (IValue x : o) {
                    Type type = x.getType();
                    if (!type.isNodeType() && !type.isTupleType() && !type.isListType() && !type.isSetType() && !type.isMapType() && !type.isRelationType()) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean checkIndent(INode o) {
            if (this.indent && o.arity() > 1) {
                for (IValue x : o) {
                    Type type = x.getType();
                    if (!type.isNodeType() && !type.isTupleType() && !type.isListType() && !type.isSetType() && !type.isMapType() && !type.isRelationType()) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean checkIndent(IMap o) {
            if (this.indent && o.size() > 1) {
                for (IValue x : o) {
                    Type type = x.getType();
                    Type vType = o.get(x).getType();
                    if (type.isNodeType() || type.isTupleType() || type.isListType() || type.isSetType() || type.isMapType() || type.isRelationType()) {
                        return true;
                    }
                    if (!vType.isNodeType() && !vType.isTupleType() && !vType.isListType() && !vType.isSetType() && !vType.isMapType() && !vType.isRelationType()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public IValue visitSourceLocation(ISourceLocation o) throws VisitorException {
            this.append('|');
            this.append(o.getURI().toString());
            this.append('|');
            if (o.getOffset() != -1) {
                this.append('(');
                this.append(Integer.toString(o.getOffset()));
                this.append(',');
                this.append(Integer.toString(o.getLength()));
                this.append(',');
                this.append('<');
                this.append(Integer.toString(o.getBeginLine()));
                this.append(',');
                this.append(Integer.toString(o.getBeginColumn()));
                this.append('>');
                this.append(',');
                this.append('<');
                this.append(Integer.toString(o.getEndLine()));
                this.append(',');
                this.append(Integer.toString(o.getEndColumn()));
                this.append('>');
                this.append(')');
            }
            return o;
        }

        @Override
        public IValue visitString(IString o) throws VisitorException {
            this.append('\"');
            block10: for (byte ch : o.getValue().getBytes()) {
                switch (ch) {
                    case 34: {
                        this.append('\\');
                        this.append('\"');
                        continue block10;
                    }
                    case 62: {
                        this.append('\\');
                        this.append('>');
                        continue block10;
                    }
                    case 60: {
                        this.append('\\');
                        this.append('<');
                        continue block10;
                    }
                    case 39: {
                        this.append('\\');
                        this.append('\'');
                    }
                    case 92: {
                        this.append('\\');
                        this.append('\\');
                        continue block10;
                    }
                    case 10: {
                        this.append('\\');
                        this.append('n');
                        continue block10;
                    }
                    case 13: {
                        this.append('\\');
                        this.append('r');
                        continue block10;
                    }
                    case 9: {
                        this.append('\\');
                        this.append('t');
                        continue block10;
                    }
                    default: {
                        this.append((char)ch);
                    }
                }
            }
            this.append('\"');
            return o;
        }

        @Override
        public IValue visitTuple(ITuple o) throws VisitorException {
            this.append('<');
            Iterator it = o.iterator();
            if (it.hasNext()) {
                ((IValue)it.next()).accept(this);
            }
            while (it.hasNext()) {
                this.append(',');
                ((IValue)it.next()).accept(this);
            }
            this.append('>');
            return o;
        }

        @Override
        public IValue visitExternal(IExternalValue externalValue) throws VisitorException {
            this.append(externalValue.toString());
            return externalValue;
        }

        @Override
        public IValue visitDateTime(IDateTime o) throws VisitorException {
            this.append("$");
            if (o.isDate()) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                this.append(df.format(new Date(o.getInstant())));
            } else if (o.isTime()) {
                SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSSZZZ");
                this.append("T");
                this.append(df.format(new Date(o.getInstant())));
            } else {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZ");
                this.append(df.format(new Date(o.getInstant())));
            }
            return o;
        }
    }
}

