/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.type;

import java.util.Map;
import org.eclipse.imp.pdb.facts.exceptions.FactMatchException;
import org.eclipse.imp.pdb.facts.exceptions.FactTypeUseException;
import org.eclipse.imp.pdb.facts.type.ITypeVisitor;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParameterType
extends Type {
    private final String fName;
    private final Type fBound;

    ParameterType(String name, Type bound) {
        this.fName = name;
        this.fBound = bound;
    }

    ParameterType(String name) {
        this.fName = name;
        this.fBound = TypeFactory.getInstance().valueType();
    }

    @Override
    public boolean isParameterType() {
        return true;
    }

    @Override
    public boolean isValueType() {
        return this.fBound.isValueType();
    }

    @Override
    public boolean isBoolType() {
        return this.fBound.isBoolType();
    }

    @Override
    public boolean isRealType() {
        return this.fBound.isRealType();
    }

    @Override
    public boolean isIntegerType() {
        return this.fBound.isIntegerType();
    }

    @Override
    public boolean isListType() {
        return this.fBound.isListType();
    }

    @Override
    public boolean isMapType() {
        return this.fBound.isMapType();
    }

    @Override
    public boolean isAbstractDataType() {
        return this.fBound.isAbstractDataType();
    }

    @Override
    public boolean isAliasType() {
        return this.fBound.isAliasType();
    }

    @Override
    public boolean isRelationType() {
        return this.fBound.isRelationType();
    }

    @Override
    public boolean isSetType() {
        return this.fBound.isSetType();
    }

    @Override
    public boolean isSourceLocationType() {
        return this.fBound.isSourceLocationType();
    }

    @Override
    public boolean isSourceRangeType() {
        return this.fBound.isSourceRangeType();
    }

    @Override
    public boolean isStringType() {
        return this.fBound.isStringType();
    }

    @Override
    public boolean isConstructorType() {
        return this.fBound.isConstructorType();
    }

    @Override
    public boolean isNodeType() {
        return this.fBound.isNodeType();
    }

    @Override
    public boolean isTupleType() {
        return this.fBound.isTupleType();
    }

    @Override
    public boolean isVoidType() {
        return this.fBound.isVoidType();
    }

    @Override
    public Type getBound() {
        return this.fBound;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public boolean isSubtypeOf(Type other) {
        if (other == this) {
            return true;
        }
        return this.fBound.isSubtypeOf(other);
    }

    @Override
    public Type lub(Type other) {
        if (other == this) {
            return this;
        }
        return this.getBound().lub(other);
    }

    public String toString() {
        return this.fBound.isValueType() ? "&" + this.fName : "&" + this.fName + "<:" + this.fBound.toString();
    }

    public int hashCode() {
        return 49991 + 49831 * this.fName.hashCode() + 133020331 * this.fBound.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ParameterType) {
            ParameterType other = (ParameterType)o;
            return this.fName.equals(other.fName) && this.fBound == other.fBound;
        }
        return false;
    }

    @Override
    public <T> T accept(ITypeVisitor<T> visitor) {
        return visitor.visitParameter(this);
    }

    @Override
    public void match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        super.match(matched, bindings);
        Type earlier = bindings.get(this);
        if (earlier != null) {
            Type lub = earlier.lub(matched);
            if (!lub.isSubtypeOf(this.getBound())) {
                throw new FactMatchException(this, matched);
            }
            bindings.put(this, lub);
        } else {
            bindings.put(this, matched);
        }
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        Type result = bindings.get(this);
        return result != null ? result : this;
    }
}

