/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.db;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.imp.pdb.analysis.AnalysisException;
import org.eclipse.imp.pdb.analysis.AnalysisManager;
import org.eclipse.imp.pdb.facts.IRelation;
import org.eclipse.imp.pdb.facts.ISet;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.db.IFactBaseListener;
import org.eclipse.imp.pdb.facts.db.IFactContext;
import org.eclipse.imp.pdb.facts.db.IFactKey;
import org.eclipse.imp.pdb.facts.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactBase {
    private static final FactBase sInstance = new FactBase();
    private Map<IFactKey, IValue> fFactDatabase = new HashMap<IFactKey, IValue>();
    private IFactKey masterKey = new IFactKey(){

        public IFactContext getContext() {
            throw new UnsupportedOperationException("masterKey");
        }

        public Type getType() {
            throw new UnsupportedOperationException("masterKey");
        }
    };
    private HashMap<IFactKey, Set<IFactBaseListener>> fListenerMap = new HashMap();

    public static FactBase getInstance() {
        return sInstance;
    }

    public Collection<IFactKey> getAllKeys() {
        return this.fFactDatabase.keySet();
    }

    public Collection<IValue> getAllFacts() {
        return this.fFactDatabase.values();
    }

    public ISet getSet(IFactKey key) throws AnalysisException {
        IValue factValue = this.fFactDatabase.get(key);
        if (factValue == null) {
            factValue = AnalysisManager.getInstance().produceFact(key);
        }
        return (ISet)factValue;
    }

    public void getSetAsync(IFactKey key, IFactBaseListener l) {
        throw new UnsupportedOperationException("NQS");
    }

    public IRelation getRelation(IFactKey key) throws AnalysisException {
        IValue factValue = this.fFactDatabase.get(key);
        if (factValue == null) {
            factValue = AnalysisManager.getInstance().produceFact(key);
        }
        return (IRelation)factValue;
    }

    public void getRelationAsync(IFactKey key, IFactBaseListener l) {
        throw new UnsupportedOperationException("NQS");
    }

    public IValue getFact(IFactKey key) throws AnalysisException {
        IValue factValue = this.fFactDatabase.get(key);
        if (factValue == null) {
            factValue = AnalysisManager.getInstance().produceFact(key);
        }
        return factValue;
    }

    public IValue queryFact(IFactKey key) {
        return this.fFactDatabase.get(key);
    }

    public void getFactAsync(IFactKey key, IFactBaseListener l) {
        throw new UnsupportedOperationException("NQS");
    }

    public void removeFact(IFactKey key) {
        this.fFactDatabase.remove(key);
        this.notifyListener(key, IFactBaseListener.Reason.FACT_REMOVED);
    }

    public void defineFact(IFactKey key, IValue value) {
        this.checkNull(value);
        this.fFactDatabase.put(key, value);
        this.notifyListener(key, IFactBaseListener.Reason.FACT_DEFINED);
    }

    public void updateFact(IFactKey key, IValue value) {
        if (this.fFactDatabase.get(key) == null) {
            throw new IllegalArgumentException("Can not update an undefined fact: " + key);
        }
        this.defineFact(key, value);
        this.notifyListener(key, IFactBaseListener.Reason.FACT_UPDATED);
    }

    public void addListener(IFactBaseListener listener) {
        this.addListener(this.masterKey, listener);
    }

    public void addListener(IFactKey key, IFactBaseListener listener) {
        Set<IFactBaseListener> set = this.fListenerMap.get(key);
        if (set == null) {
            set = new HashSet<IFactBaseListener>();
            this.fListenerMap.put(key, set);
        }
        set.add(listener);
    }

    private void notifyListener(IFactKey key, IFactBaseListener.Reason reason) {
        Set<IFactBaseListener> universalListeners;
        Set<IFactBaseListener> listenerSet = this.fListenerMap.get(key);
        if (listenerSet != null) {
            for (IFactBaseListener l : listenerSet) {
                l.factChanged(key, this.fFactDatabase.get(key), reason);
            }
        }
        if ((universalListeners = this.fListenerMap.get(this.masterKey)) != null) {
            for (IFactBaseListener l : universalListeners) {
                l.factChanged(key, this.fFactDatabase.get(key), reason);
            }
        }
    }

    private void checkNull(IValue value) {
        if (value == null) {
            throw new IllegalArgumentException("value should not be null");
        }
    }

    public void clear() {
        this.fFactDatabase.clear();
        for (Set<IFactBaseListener> listenerSet : this.fListenerMap.values()) {
            for (IFactBaseListener l : listenerSet) {
                l.factBaseCleared();
            }
        }
    }
}

