/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.bench;

import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MethodEditor;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassWriter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;

public class AddBytecodeDebug {
    private static OfflineInstrumenter instrumenter;

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 1; ++i) {
            ClassInstrumenter ci;
            instrumenter = new OfflineInstrumenter();
            BufferedWriter w = new BufferedWriter(new FileWriter("report", false));
            args = instrumenter.parseStandardArgs(args);
            instrumenter.setPassUnmodifiedClasses(true);
            instrumenter.beginTraversal();
            while ((ci = instrumenter.nextClass()) != null) {
                AddBytecodeDebug.doClass(ci, w);
            }
            instrumenter.close();
        }
    }

    private static void doClass(ClassInstrumenter ci, Writer w) throws Exception {
        String className = ci.getReader().getName();
        w.write("Class: " + className + "\n");
        w.flush();
        ci.enableFakeLineNumbers(10000);
        for (int m = 0; m < ci.getReader().getMethodCount(); ++m) {
            MethodData d = ci.visitMethod(m);
            if (d == null) continue;
            d.setHasChanged();
            MethodEditor me = new MethodEditor(d);
            me.beginPass();
            ExceptionHandler[][] handlers = me.getHandlers();
            boolean[] putDumperAt = new boolean[handlers.length];
            for (int i = 0; i < handlers.length; ++i) {
                for (int j = 0; j < handlers[i].length; ++j) {
                    int offset = handlers[i][j].getHandler();
                    if (putDumperAt[offset]) continue;
                    putDumperAt[offset] = true;
                    me.insertBefore(offset, new MethodEditor.Patch(){

                        public void emitTo(MethodEditor.Output w) {
                            w.emit(DupInstruction.make(0));
                            w.emit(Util.makeInvoke(Throwable.class, "printStackTrace", new Class[0]));
                        }
                    });
                }
            }
            me.applyPatches();
        }
        if (ci.isChanged()) {
            ClassWriter cw = ci.emitClass();
            instrumenter.outputModifiedClass(ci, cw);
        }
    }
}

