/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.box.interpreter;

import java.util.HashMap;
import java.util.Stack;
import lpg.runtime.IAst;
import org.eclipse.imp.box.Activator;
import org.eclipse.imp.box.interpreter.SpacingOptions;
import org.eclipse.imp.box.interpreter.SyntheticToken;
import org.eclipse.imp.box.parser.Ast.ASTNode;
import org.eclipse.imp.box.parser.Ast.ASTNodeToken;
import org.eclipse.imp.box.parser.Ast.BoxList;
import org.eclipse.imp.box.parser.Ast.BoxOperator__G_GroupOptionList;
import org.eclipse.imp.box.parser.Ast.BoxOperator__HOV_SpaceOptionList;
import org.eclipse.imp.box.parser.Ast.BoxOperator__HV_SpaceOptionList;
import org.eclipse.imp.box.parser.Ast.BoxOperator__H_SpaceOptionList;
import org.eclipse.imp.box.parser.Ast.BoxOperator__I_SpaceOptionList;
import org.eclipse.imp.box.parser.Ast.BoxOperator__SL_sep_EQUAL_STRING_SpaceOptionList;
import org.eclipse.imp.box.parser.Ast.BoxOperator__V_SpaceOptionList;
import org.eclipse.imp.box.parser.Ast.BoxOperator__WD;
import org.eclipse.imp.box.parser.Ast.Box__BoxOperator_LEFTBRACKET_BoxList_RIGHTBRACKET;
import org.eclipse.imp.box.parser.Ast.Box__STRING;
import org.eclipse.imp.box.parser.Ast.GroupOptionList;
import org.eclipse.imp.box.parser.Ast.GroupOption__gs_EQUAL_NUMBER;
import org.eclipse.imp.box.parser.Ast.GroupOption__op_EQUAL_BoxOperator;
import org.eclipse.imp.box.parser.Ast.IBox;
import org.eclipse.imp.box.parser.Ast.IBoxOperator;
import org.eclipse.imp.box.parser.Ast.IGroupOption;
import org.eclipse.imp.box.parser.Ast.ISpaceSymbol;
import org.eclipse.imp.box.parser.Ast.ISpaceValue;
import org.eclipse.imp.box.parser.Ast.SpaceOption;
import org.eclipse.imp.box.parser.Ast.SpaceOptionList;
import org.eclipse.imp.box.parser.Ast.SpaceSymbol__cs;
import org.eclipse.imp.box.parser.Ast.SpaceSymbol__hs;
import org.eclipse.imp.box.parser.Ast.SpaceSymbol__is;
import org.eclipse.imp.box.parser.Ast.SpaceSymbol__ts;
import org.eclipse.imp.box.parser.Ast.SpaceSymbol__vs;
import org.eclipse.imp.box.parser.Ast.SpaceValue__IDENT;
import org.eclipse.imp.box.parser.Ast.SpaceValue__NUMBER;
import org.eclipse.imp.box.parser.Ast.Visitor;

public class BoxInterpreter {
    private final Stack<LayoutEnvironment> fEnvStack = new Stack();
    private final Stack<Integer> fIndentStack = new Stack();
    private final BoxFormattingPrefs fFormattingPrefs;
    private int fCurWidth;

    public BoxInterpreter() {
        this(new BoxFormattingPrefs());
    }

    public BoxInterpreter(BoxFormattingPrefs prefs) {
        this.fFormattingPrefs = prefs;
        this.fCurWidth = this.fFormattingPrefs.PageWidth;
        this.fEnvStack.push(new LayoutEnvironment(0));
    }

    public BoxInterpreter(int pageWidth, boolean useSpacesForTabs, int tabWidth) {
        this(new BoxFormattingPrefs(pageWidth, useSpacesForTabs, tabWidth));
    }

    private void pushIndent(int indent) {
        this.fIndentStack.push(this.fCurWidth);
        this.fCurWidth -= indent;
    }

    private void popIndent() {
        if (this.fIndentStack.size() < 1) {
            Activator.getInstance().writeErrorMsg("Unmatched call to popIndent() in Box interpreter!");
            this.fCurWidth = this.fFormattingPrefs.PageWidth;
        } else {
            this.fCurWidth = this.fIndentStack.pop();
        }
    }

    public String interpret(IBox rootNode) {
        final HashMap translation = new HashMap();
        rootNode.accept(new Visitor(){
            {
                this.initline();
            }

            private void initline() {
                ((LayoutEnvironment)BoxInterpreter.this.fEnvStack.peek()).fColumn = 0;
            }

            private String spaces(int num) {
                StringBuilder sb = new StringBuilder(num);
                for (int i = 0; i < num; ++i) {
                    sb.append(' ');
                }
                return sb.toString();
            }

            private int column() {
                return ((LayoutEnvironment)BoxInterpreter.this.fEnvStack.peek()).fColumn;
            }

            private void consume(int cols) {
                ((LayoutEnvironment)BoxInterpreter.this.fEnvStack.peek()).fColumn += cols;
            }

            private int remain() {
                return BoxInterpreter.this.fCurWidth - this.column();
            }

            private String newlines(int num) {
                StringBuilder sb = new StringBuilder(num);
                for (int i = 0; i < num; ++i) {
                    sb.append('\n');
                }
                return sb.toString();
            }

            private void emit(String s, StringBuilder sb) {
                int len = s.length();
                sb.append(s);
                this.consume(len);
            }

            private void newlines(int num, StringBuilder sb) {
                sb.append(this.newlines(num));
                this.initline();
            }

            public boolean preVisit(IAst element) {
                return true;
            }

            public void postVisit(IAst element) {
            }

            public void endVisit(ASTNode n) {
            }

            public void endVisit(ASTNodeToken n) {
            }

            public void endVisit(BoxList n) {
            }

            public void endVisit(SpaceOptionList n) {
            }

            public void endVisit(SpaceOption n) {
            }

            public void endVisit(GroupOptionList n) {
            }

            public void endVisit(Box__STRING strLit) {
                String strLitStr = strLit.toString();
                String contents = strLitStr.substring(1, strLitStr.length() - 1);
                translation.put(strLit, contents);
            }

            public void endVisit(Box__BoxOperator_LEFTBRACKET_BoxList_RIGHTBRACKET n) {
                IBoxOperator op = n.getBoxOperator();
                BoxList children = n.getBoxList();
                String result = "";
                if (op instanceof BoxOperator__H_SpaceOptionList) {
                    BoxOperator__H_SpaceOptionList horizOp = (BoxOperator__H_SpaceOptionList)op;
                    result = this.handleHorizontal(this.processOptions(horizOp.getSpaceOptionList()), children);
                } else if (op instanceof BoxOperator__V_SpaceOptionList) {
                    BoxOperator__V_SpaceOptionList vertOp = (BoxOperator__V_SpaceOptionList)op;
                    result = this.handleVertical(this.processOptions(vertOp.getSpaceOptionList()), children);
                } else if (op instanceof BoxOperator__HV_SpaceOptionList) {
                    BoxOperator__HV_SpaceOptionList hvOp = (BoxOperator__HV_SpaceOptionList)op;
                    result = this.handleHV(this.processOptions(hvOp.getSpaceOptionList()), children);
                } else if (op instanceof BoxOperator__HOV_SpaceOptionList) {
                    BoxOperator__HOV_SpaceOptionList hovOp = (BoxOperator__HOV_SpaceOptionList)op;
                    result = this.handleHOV(this.processOptions(hovOp.getSpaceOptionList()), children);
                } else if (op instanceof BoxOperator__I_SpaceOptionList) {
                    BoxOperator__I_SpaceOptionList indentOp = (BoxOperator__I_SpaceOptionList)op;
                    result = this.handleIndent(this.processOptions(indentOp.getSpaceOptionList()), children);
                } else if (op instanceof BoxOperator__G_GroupOptionList) {
                    BoxOperator__G_GroupOptionList grpOp = (BoxOperator__G_GroupOptionList)op;
                    result = this.handleGroup(this.processOptions(grpOp.getGroupOptionList()), children);
                } else if (op instanceof BoxOperator__WD) {
                    BoxOperator__WD widOp = (BoxOperator__WD)op;
                    result = this.handleWidth(widOp, children);
                } else if (op instanceof BoxOperator__SL_sep_EQUAL_STRING_SpaceOptionList) {
                    BoxOperator__SL_sep_EQUAL_STRING_SpaceOptionList slOp = (BoxOperator__SL_sep_EQUAL_STRING_SpaceOptionList)op;
                    String sepStr = slOp.getsep().toString();
                    result = this.handleSeparatedList(sepStr.substring(1, sepStr.length() - 1), this.processOptions(slOp.getSpaceOptionList()), children);
                }
                translation.put(n, result);
                BoxInterpreter.this.fEnvStack.pop();
            }

            private SpacingOptions processOptions(SpaceOptionList optionList) {
                SpacingOptions result = new SpacingOptions();
                for (int i = 0; i < optionList.size(); ++i) {
                    SpaceOption opt = optionList.getSpaceOptionAt(i);
                    ISpaceSymbol sym = opt.getSpaceSymbol();
                    ISpaceValue val = opt.getSpaceValue();
                    int ival = Integer.valueOf(((SpaceValue__NUMBER)val).getNUMBER().toString());
                    if (sym instanceof SpaceSymbol__vs) {
                        result.fVerticalSpacing = ival;
                        continue;
                    }
                    if (sym instanceof SpaceSymbol__hs) {
                        result.fHorizontalSpacing = ival;
                        continue;
                    }
                    if (sym instanceof SpaceSymbol__is) {
                        result.fIndentationSpacing = ival;
                        continue;
                    }
                    if (sym instanceof SpaceSymbol__ts) {
                        result.fTabStopSpacing = ival;
                        continue;
                    }
                    if (!(sym instanceof SpaceSymbol__cs)) continue;
                    result.fSeparatorSpacing = ival;
                }
                return result;
            }

            private String handleHorizontal(SpacingOptions spaceOptions, BoxList children) {
                int hs = spaceOptions.horizontalSpacing();
                StringBuilder sb = new StringBuilder();
                int col = 0;
                for (int i = 0; i < children.size(); ++i) {
                    IBox child = children.getBoxAt(i);
                    String childStr = (String)translation.get(child);
                    String[] childLines = childStr.split("\n");
                    int maxChildWidth = this.maxWidth(childLines);
                    if (i > 0) {
                        this.emit(this.spaces(hs), sb);
                    }
                    for (int l = 0; l < childLines.length; ++l) {
                        if (l > 0) {
                            this.newlines(1, sb);
                            this.emit(this.spaces(col), sb);
                        }
                        this.emit(childLines[l], sb);
                    }
                    col += maxChildWidth + hs;
                }
                return sb.toString();
            }

            private int maxWidth(String[] lines) {
                int max = 0;
                for (String line : lines) {
                    if (line.length() <= max) continue;
                    max = line.length();
                }
                return max;
            }

            private String handleVertical(SpacingOptions spaceOptions, BoxList children) {
                int vs = spaceOptions.verticalSpacing() + 1;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < children.size(); ++i) {
                    IBox child = children.getBoxAt(i);
                    if (i > 0) {
                        this.newlines(vs, sb);
                    }
                    this.emit((String)translation.get(child), sb);
                }
                return sb.toString();
            }

            private String handleHV(SpacingOptions spaceOptions, BoxList children) {
                int hs = spaceOptions.horizontalSpacing();
                int vs = spaceOptions.verticalSpacing() + 1;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < children.size(); ++i) {
                    boolean childFits;
                    IBox child = children.getBoxAt(i);
                    String childStr = (String)translation.get(child);
                    int childWid = childStr.length();
                    boolean bl = childFits = this.remain() >= hs + childWid;
                    if (i > 0) {
                        if (childFits) {
                            this.emit(this.spaces(hs), sb);
                        } else {
                            this.newlines(vs, sb);
                        }
                    }
                    if (childFits) {
                        this.emit(childStr, sb);
                        continue;
                    }
                    if (this.column() == 0) {
                        this.emit(childStr, sb);
                        continue;
                    }
                    this.newlines(vs, sb);
                    this.emit(childStr, sb);
                }
                return sb.toString();
            }

            private String handleHOV(SpacingOptions spaceOptions, BoxList children) {
                int hs = spaceOptions.horizontalSpacing();
                int vs = spaceOptions.verticalSpacing() + 1;
                int totalWid = 0;
                for (int i = 0; i < children.size(); ++i) {
                    IBox child = children.getBoxAt(i);
                    totalWid += ((String)translation.get(child)).length() + (i > 0 ? hs : 0);
                }
                StringBuilder sb = new StringBuilder();
                if (totalWid <= this.remain()) {
                    for (int i = 0; i < children.size(); ++i) {
                        IBox child = children.getBoxAt(i);
                        String childStr = (String)translation.get(child);
                        if (i > 0) {
                            this.emit(this.spaces(hs), sb);
                        }
                        this.emit(childStr, sb);
                    }
                } else {
                    for (int i = 0; i < children.size(); ++i) {
                        IBox child = children.getBoxAt(i);
                        String childStr = (String)translation.get(child);
                        if (i > 0) {
                            this.emit(this.newlines(vs), sb);
                        }
                        this.emit(childStr, sb);
                    }
                }
                return sb.toString();
            }

            private String handleIndent(SpacingOptions spaceOptions, BoxList children) {
                if (children.size() != 1) {
                    throw new IllegalArgumentException("Indent operator only accepts 1 child node");
                }
                IBox child = children.getBoxAt(0);
                BoxInterpreter.this.popIndent();
                String childStr = (String)translation.get(child);
                StringBuilder sb = new StringBuilder();
                String[] childLines = childStr.split("\n");
                String indentSpaces = this.spaces(spaceOptions.indentationSpacing());
                int lineIdx = 0;
                for (String line : childLines) {
                    if (lineIdx++ > 0) {
                        sb.append('\n');
                    }
                    if (line.length() > 0) {
                        sb.append(indentSpaces);
                    }
                    sb.append(line);
                }
                return sb.toString();
            }

            private String handleSeparatedList(String sep, SpacingOptions spaceOptions, BoxList children) {
                SyntheticToken dummyToken = new SyntheticToken(16, "0");
                SpacingOptions hvOptions = SpacingOptions.hsvs(spaceOptions.horizontalSpacing(), spaceOptions.verticalSpacing());
                BoxList hvChildren = new BoxList(dummyToken, dummyToken, true);
                for (int i = 0; i < children.size() - 1; ++i) {
                    IBox child = children.getBoxAt(i);
                    BoxOperator__H_SpaceOptionList hOp = new BoxOperator__H_SpaceOptionList(dummyToken, dummyToken, new ASTNodeToken(new SyntheticToken(8, "H")), new SpaceOptionList(dummyToken, dummyToken, true));
                    Box__BoxOperator_LEFTBRACKET_BoxList_RIGHTBRACKET hBox = new Box__BoxOperator_LEFTBRACKET_BoxList_RIGHTBRACKET(dummyToken, dummyToken, hOp, new BoxList(dummyToken, dummyToken, true));
                    Box__STRING sepChild = new Box__STRING(new SyntheticToken(7, sep));
                    BoxList hBoxChildList = hBox.getBoxList();
                    hBoxChildList.add(child);
                    hBoxChildList.add(sepChild);
                    translation.put((IAst)sepChild, sep);
                    String hBoxStr = this.handleHorizontal(SpacingOptions.hs(spaceOptions.separatorSpacing()), hBoxChildList);
                    translation.put(hBox, hBoxStr);
                    hvChildren.add(hBox);
                }
                if (children.size() > 0) {
                    hvChildren.add(children.getBoxAt(children.size() - 1));
                }
                return this.handleHV(hvOptions, hvChildren);
            }

            private String handleWidth(BoxOperator__WD op, BoxList children) {
                throw new UnsupportedOperationException("WD operator not supported");
            }

            private GroupOptions processOptions(GroupOptionList optionList) {
                BoxOperator opEnum = BoxOperator.H;
                int groupSize = 1;
                for (int i = 0; i < optionList.size(); ++i) {
                    IGroupOption opt = optionList.getGroupOptionAt(i);
                    if (opt instanceof GroupOption__op_EQUAL_BoxOperator) {
                        GroupOption__op_EQUAL_BoxOperator opt0 = (GroupOption__op_EQUAL_BoxOperator)opt;
                        IBoxOperator op = opt0.getBoxOperator();
                        if (op instanceof BoxOperator__H_SpaceOptionList) {
                            opEnum = BoxOperator.H;
                            continue;
                        }
                        if (op instanceof BoxOperator__V_SpaceOptionList) {
                            opEnum = BoxOperator.V;
                            continue;
                        }
                        if (op instanceof BoxOperator__HV_SpaceOptionList) {
                            opEnum = BoxOperator.HV;
                            continue;
                        }
                        if (op instanceof BoxOperator__HOV_SpaceOptionList) {
                            opEnum = BoxOperator.HOV;
                            continue;
                        }
                        if (op instanceof BoxOperator__I_SpaceOptionList) {
                            opEnum = BoxOperator.I;
                            continue;
                        }
                        if (op instanceof BoxOperator__G_GroupOptionList) {
                            opEnum = BoxOperator.G;
                            continue;
                        }
                        if (!(op instanceof BoxOperator__WD)) continue;
                        opEnum = BoxOperator.WD;
                        continue;
                    }
                    if (!(opt instanceof GroupOption__gs_EQUAL_NUMBER)) continue;
                    GroupOption__gs_EQUAL_NUMBER opt1 = (GroupOption__gs_EQUAL_NUMBER)opt;
                    groupSize = Integer.parseInt(opt1.getNUMBER().toString());
                }
                return new GroupOptions(opEnum, groupSize);
            }

            private String handleGroup(GroupOptions groupOptions, BoxList children) {
                int gs = groupOptions.groupSize();
                StringBuilder sb = new StringBuilder();
                int rowIdx = 0;
                for (int i = 0; i < children.size(); ++i) {
                    IBox child = children.getBoxAt(i);
                    String childStr = (String)translation.get(child);
                    if (rowIdx >= gs) continue;
                }
                throw new UnsupportedOperationException("G operator unsupported");
            }

            public void endVisit(BoxOperator__G_GroupOptionList n) {
            }

            public void endVisit(BoxOperator__H_SpaceOptionList n) {
            }

            public void endVisit(BoxOperator__HOV_SpaceOptionList n) {
            }

            public void endVisit(BoxOperator__HV_SpaceOptionList n) {
            }

            public void endVisit(BoxOperator__I_SpaceOptionList n) {
            }

            public void endVisit(BoxOperator__SL_sep_EQUAL_STRING_SpaceOptionList n) {
            }

            public void endVisit(BoxOperator__V_SpaceOptionList n) {
            }

            public void endVisit(BoxOperator__WD n) {
            }

            public void endVisit(SpaceSymbol__cs n) {
            }

            public void endVisit(SpaceSymbol__hs n) {
            }

            public void endVisit(SpaceSymbol__is n) {
            }

            public void endVisit(SpaceSymbol__ts n) {
            }

            public void endVisit(SpaceSymbol__vs n) {
            }

            public void endVisit(SpaceValue__NUMBER n) {
            }

            public void endVisit(SpaceValue__IDENT n) {
            }

            public void endVisit(GroupOption__op_EQUAL_BoxOperator n) {
            }

            public void endVisit(GroupOption__gs_EQUAL_NUMBER n) {
            }

            public boolean visit(ASTNode n) {
                return true;
            }

            public boolean visit(ASTNodeToken n) {
                return true;
            }

            public boolean visit(BoxList n) {
                return true;
            }

            public boolean visit(SpaceOptionList n) {
                return true;
            }

            public boolean visit(SpaceOption n) {
                return true;
            }

            public boolean visit(GroupOptionList n) {
                return true;
            }

            public boolean visit(Box__STRING n) {
                return true;
            }

            public boolean visit(Box__BoxOperator_LEFTBRACKET_BoxList_RIGHTBRACKET n) {
                BoxInterpreter.this.fEnvStack.push(new LayoutEnvironment(this.column()));
                return true;
            }

            public boolean visit(BoxOperator__H_SpaceOptionList op) {
                return true;
            }

            public boolean visit(BoxOperator__V_SpaceOptionList op) {
                return true;
            }

            public boolean visit(BoxOperator__HV_SpaceOptionList op) {
                return true;
            }

            public boolean visit(BoxOperator__HOV_SpaceOptionList op) {
                return true;
            }

            public boolean visit(BoxOperator__I_SpaceOptionList op) {
                SpacingOptions spaceOptions = this.processOptions(op.getSpaceOptionList());
                BoxInterpreter.this.pushIndent(spaceOptions.indentationSpacing());
                return true;
            }

            public boolean visit(BoxOperator__G_GroupOptionList op) {
                return true;
            }

            public boolean visit(BoxOperator__SL_sep_EQUAL_STRING_SpaceOptionList n) {
                return true;
            }

            public boolean visit(BoxOperator__WD op) {
                return true;
            }

            public boolean visit(SpaceSymbol__cs n) {
                return true;
            }

            public boolean visit(SpaceSymbol__hs n) {
                return true;
            }

            public boolean visit(SpaceSymbol__is n) {
                return true;
            }

            public boolean visit(SpaceSymbol__ts n) {
                return true;
            }

            public boolean visit(SpaceSymbol__vs n) {
                return true;
            }

            public boolean visit(SpaceValue__NUMBER n) {
                return true;
            }

            public boolean visit(SpaceValue__IDENT n) {
                return true;
            }

            public boolean visit(GroupOption__op_EQUAL_BoxOperator n) {
                return true;
            }

            public boolean visit(GroupOption__gs_EQUAL_NUMBER n) {
                return true;
            }
        });
        return (String)translation.get(rootNode);
    }

    private static class LayoutEnvironment {
        private int fColumn;

        public LayoutEnvironment(int col) {
            this.fColumn = col;
        }

        public int column() {
            return this.fColumn;
        }
    }

    public static class BoxFormattingPrefs {
        public final int PageWidth;
        public final boolean UseSpacesForTabs;
        public final int TabWidth;

        public BoxFormattingPrefs() {
            this(80, true, 4);
        }

        public BoxFormattingPrefs(int pageWidth, boolean useSpacesForTabs, int tabWidth) {
            this.PageWidth = pageWidth;
            this.UseSpacesForTabs = useSpacesForTabs;
            this.TabWidth = tabWidth;
        }
    }

    public static class GroupOptions {
        private final BoxOperator fOperator;
        private final int fGroupSize;

        public GroupOptions(BoxOperator op, int gs) {
            this.fOperator = op;
            this.fGroupSize = gs;
        }

        public BoxOperator operator() {
            return this.fOperator;
        }

        public int groupSize() {
            return this.fGroupSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoxOperator {
        H,
        V,
        HV,
        HOV,
        I,
        G,
        WD,
        SL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;

    }
}

