/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.box.interpreter;

import org.eclipse.imp.box.interpreter.BoxInterpreter;

public class SpacingOptions {
    int fHorizontalSpacing = 1;
    int fVerticalSpacing = 0;
    int fIndentationSpacing = 4;
    int fTabStopSpacing = 4;
    int fSeparatorSpacing = 0;
    private int fGroupSize = 4;
    private BoxInterpreter.Alignment fAlignment = BoxInterpreter.Alignment.LEFT;

    SpacingOptions() {
    }

    public static SpacingOptions DEFAULT() {
        return new SpacingOptions();
    }

    public static SpacingOptions hs(int hs) {
        SpacingOptions opts = new SpacingOptions();
        opts.fHorizontalSpacing = hs;
        return opts;
    }

    public static SpacingOptions vs(int vs) {
        SpacingOptions opts = new SpacingOptions();
        opts.fVerticalSpacing = vs;
        return opts;
    }

    public static SpacingOptions hsvs(int hs, int vs) {
        SpacingOptions opts = new SpacingOptions();
        opts.fHorizontalSpacing = hs;
        opts.fVerticalSpacing = vs;
        return opts;
    }

    public static SpacingOptions is(int indent) {
        SpacingOptions opts = new SpacingOptions();
        opts.fIndentationSpacing = indent;
        return opts;
    }

    public static SpacingOptions ts(int tab) {
        SpacingOptions opts = new SpacingOptions();
        opts.fTabStopSpacing = tab;
        return opts;
    }

    public static SpacingOptions gs(int groupSize) {
        SpacingOptions opts = new SpacingOptions();
        opts.fGroupSize = groupSize;
        return opts;
    }

    public int horizontalSpacing() {
        return this.fHorizontalSpacing;
    }

    public int verticalSpacing() {
        return this.fVerticalSpacing;
    }

    public int indentationSpacing() {
        return this.fIndentationSpacing;
    }

    public int separatorSpacing() {
        return this.fSeparatorSpacing;
    }

    public int tabStopSpacing() {
        return this.fTabStopSpacing;
    }

    public int groupSize() {
        return this.fGroupSize;
    }

    public BoxInterpreter.Alignment alignment() {
        return this.fAlignment;
    }
}

