/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.editor;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.box.builders.BoxException;
import org.eclipse.imp.box.builders.BoxFactory;
import org.eclipse.imp.formatting.spec.BoxStringBuilder;
import org.eclipse.imp.formatting.spec.Item;
import org.eclipse.imp.formatting.spec.Parser;
import org.eclipse.imp.formatting.spec.Rule;
import org.eclipse.imp.formatting.spec.Separator;
import org.eclipse.imp.formatting.spec.SpaceOptionBinder;
import org.eclipse.imp.formatting.spec.Specification;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.utils.SavingMessageHandler;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class RuleTable
implements IEditorPart {
    private Table fRuleTable;
    private TableEditor fTableEditor;
    private final int STATUS_COLUMN = 0;
    private final int EDIT_COLUMN = 1;
    private final int PREVIEW_COLUMN = 2;
    private final int MARGIN = 2;
    private Item fActiveItem;
    private List<IPropertyListener> fListeners = new LinkedList<IPropertyListener>();
    private Specification fModel;
    private boolean fDirty = false;
    private IEditorSite fSite;
    private IEditorInput fInput;
    private Font fSeparatorCellFont;

    public void setModel(Specification model) {
        this.fModel = model;
        this.refresh();
    }

    public void addPropertyListener(IPropertyListener l) {
        this.fListeners.add(l);
    }

    private void firePropertyChange(int change) {
        for (IPropertyListener l : this.fListeners) {
            l.propertyChanged((Object)this, change);
        }
    }

    public IEditorInput getEditorInput() {
        return this.fInput;
    }

    public IEditorSite getEditorSite() {
        return this.fSite;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.fSite = site;
        this.fInput = input;
    }

    public void dispose() {
        this.fRuleTable.dispose();
        this.fSeparatorCellFont.dispose();
    }

    public IWorkbenchPartSite getSite() {
        return this.fSite;
    }

    public String getTitle() {
        return "Rules";
    }

    public Image getTitleImage() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.fListeners.remove(listener);
    }

    public void setFocus() {
        this.fRuleTable.setFocus();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(256));
        this.fRuleTable = new Table(parent, 65536);
        this.fRuleTable.setLinesVisible(true);
        this.fRuleTable.setHeaderVisible(true);
        TableColumn status = new TableColumn(this.fRuleTable, 2048);
        status.setText("Status");
        status.setResizable(true);
        TableColumn box = new TableColumn(this.fRuleTable, 2048);
        box.setText("Box");
        box.setResizable(true);
        TableColumn preview = new TableColumn(this.fRuleTable, 2048);
        preview.setText("Preview");
        preview.setResizable(true);
        status.pack();
        box.pack();
        preview.pack();
        this.createCellEditor();
        this.createCellPainter();
        this.createCellTooltip();
        this.fSeparatorCellFont = new Font((Device)parent.getDisplay(), "Monospace", 14, 1);
    }

    private void createCellEditor() {
        this.fTableEditor = new TableEditor(this.fRuleTable);
        this.fTableEditor.horizontalAlignment = 16384;
        this.fTableEditor.verticalAlignment = 128;
        this.fTableEditor.grabHorizontal = true;
        this.fTableEditor.grabVertical = true;
        this.fTableEditor.minimumWidth = 50;
        this.fRuleTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = RuleTable.this.fTableEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null) {
                    return;
                }
                RuleTable.this.fActiveItem = (Item)item.getData();
                final Text newEditor = new Text((Composite)RuleTable.this.fRuleTable, 2114);
                newEditor.setFont(item.getFont());
                newEditor.setText(item.getText(1));
                if (RuleTable.this.fActiveItem instanceof Rule) {
                    newEditor.addModifyListener((ModifyListener)new RuleModifier());
                } else if (RuleTable.this.fActiveItem instanceof Separator) {
                    newEditor.addModifyListener((ModifyListener)new SeparatorModifier());
                }
                newEditor.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        newEditor.dispose();
                    }
                });
                newEditor.setFocus();
                RuleTable.this.fTableEditor.setEditor((Control)newEditor, item, 1);
            }
        });
    }

    private void disposeTableEditor() {
        Control e = this.fTableEditor.getEditor();
        if (e != null) {
            e.dispose();
        }
    }

    private void createCellTooltip() {
        this.fRuleTable.setToolTipText("");
        Listener tooltipListener = new Listener(){
            Shell tip = null;
            Label label = null;
            Display display = RuleTable.access$200(RuleTable.this).getDisplay();
            Shell shell = RuleTable.access$200(RuleTable.this).getShell();

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TableItem item = RuleTable.this.fRuleTable.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        this.tip = new Shell(this.shell, 16388);
                        this.tip.setLayout((Layout)new FillLayout());
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(this.display.getSystemColor(28));
                        this.label.setBackground(RuleTable.this.fRuleTable.getDisplay().getSystemColor(29));
                        String text = (String)item.getData("tooltip");
                        if (text == null) break;
                        this.label.setText(text);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = RuleTable.this.fRuleTable.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x + size.y, pt.y - size.y, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        this.fRuleTable.addListener(1, tooltipListener);
        this.fRuleTable.addListener(12, tooltipListener);
        this.fRuleTable.addListener(32, tooltipListener);
        this.fRuleTable.addListener(5, tooltipListener);
    }

    private void createCellPainter() {
        this.fRuleTable.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                event.gc.setFont(item.getFont());
                Point size = event.gc.textExtent(text, 2);
                event.width = size.x + 4;
                event.height = size.y + 2;
            }
        });
        this.fRuleTable.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFEF;
            }
        });
        this.fRuleTable.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String text = item.getText(event.index);
                event.gc.setFont(item.getFont());
                event.gc.drawText(text, event.x + 2, event.y + 2, true);
            }
        });
    }

    public void addSeparator() {
        Separator s = new Separator();
        if (this.fActiveItem != null) {
            this.disposeTableEditor();
            int i = this.fModel.getRules().indexOf(this.fActiveItem);
            this.fModel.addSeparator(i, s);
            TableItem item = new TableItem(this.fRuleTable, 0, i);
            this.initSeparatorTableItem(s, item);
            this.fRuleTable.select(i);
            this.fActiveItem = s;
        } else {
            this.fModel.addRule((Item)s);
            TableItem item = new TableItem(this.fRuleTable, 0);
            this.initSeparatorTableItem(s, item);
            this.fRuleTable.select(this.fRuleTable.getChildren().length);
        }
    }

    private void initSeparatorTableItem(Separator s, TableItem item) {
        item.setData((Object)s);
        this.updateSeparatorTableItem(item, s.getLabel());
    }

    private void updateSeparatorTableItem(TableItem item, String label) {
        item.setText(1, label);
        item.setText(2, "");
        item.setText(0, "---");
        item.setFont(this.fSeparatorCellFont);
    }

    public void refresh() {
        this.fRuleTable.removeAll();
        Iterator iter = this.fModel.ruleIterator();
        while (iter.hasNext()) {
            Item i = (Item)iter.next();
            TableItem item = new TableItem(this.fRuleTable, 0);
            if (i instanceof Rule) {
                this.initRuleTableItem((Rule)i, item, false);
                continue;
            }
            if (!(i instanceof Separator)) continue;
            this.initSeparatorTableItem((Separator)i, item);
        }
        for (TableColumn c : this.fRuleTable.getColumns()) {
            c.pack();
        }
    }

    public void setDirty(boolean b) {
        if (this.fDirty != b) {
            this.fDirty = b;
            this.firePropertyChange(257);
        }
    }

    private void initRuleTableItem(Rule rule, TableItem item, boolean recompute) {
        item.setData((Object)rule);
        this.updateRuleTableItem(item, rule, recompute);
    }

    private void updateRuleTableItem(TableItem item, Rule rule, boolean recompute) {
        String boxString = rule.getBoxString();
        item.setText(1, boxString == null ? "\n" : boxString);
        if (boxString != null) {
            Parser parser = this.fModel.getParser();
            parser.getMessageHandler().clearMessages();
            if (parser.parseBox(boxString) != null) {
                String formatted;
                if (recompute) {
                    try {
                        formatted = this.getFormattedBox(boxString);
                    }
                    catch (BoxException e) {
                        this.setItemAttribs(item, e.getMessage(), e.getBoxString());
                        return;
                    }
                    if (formatted != null && formatted.length() > 0) {
                        rule.setPatternString(formatted);
                    }
                } else {
                    formatted = rule.getPatternString();
                    if (formatted == null) {
                        formatted = "";
                    }
                }
                item.setText(2, formatted);
                Object ast = parser.parseObject(formatted);
                if (ast == null) {
                    SavingMessageHandler smh = (SavingMessageHandler)parser.getMessageHandler();
                    if (smh.getMessages().size() == 1 && smh.getConcatenatedMessages().contains("Unable to parse formatted text:")) {
                        this.setItemAttribs(item, "Unable to parse formatted text: no parser", "");
                    } else {
                        this.setItemAttribs(item, "Syntax error in formatted output", smh.getConcatenatedMessages());
                    }
                } else {
                    rule.setPatternAst(ast);
                    this.setItemAttribs(item, "Ok", ast.getClass().getName());
                }
            } else {
                SavingMessageHandler smh = (SavingMessageHandler)parser.getMessageHandler();
                this.setItemAttribs(item, "Syntax error in box rule", smh.getConcatenatedMessages());
            }
        } else {
            this.setItemAttribs(item, "Empty box rule", "");
        }
    }

    private void setItemAttribs(TableItem item, String text, String tooltip) {
        item.setText(0, text);
        item.setData("tooltip", (Object)tooltip);
    }

    private String getFormattedBox(String boxString) throws BoxException {
        if (boxString != null && boxString.length() > 0) {
            SpaceOptionBinder binder = new SpaceOptionBinder(this.fModel);
            String boundString = binder.bind(boxString);
            SavingMessageHandler smh = new SavingMessageHandler();
            String result = BoxFactory.box2Text((String)boundString, (IMessageHandler)smh);
            if (smh.getMessages().size() > 0) {
                throw new BoxException(smh.getConcatenatedMessages(), boxString, null);
            }
            return result;
        }
        return "";
    }

    public void move(int diff) {
        if (this.fActiveItem != null && this.fActiveItem instanceof Rule) {
            Rule r = (Rule)this.fActiveItem;
            List rules = this.fModel.getRules();
            int cur = rules.indexOf(this.fActiveItem);
            if (cur + diff >= 0) {
                this.disposeTableEditor();
                this.fRuleTable.remove(cur);
                this.fModel.removeRule(this.fActiveItem);
                this.fModel.addRule(cur + diff, (Item)r);
                TableItem item = new TableItem(this.fRuleTable, 0, cur + diff);
                this.initRuleTableItem(r, item, false);
                this.fRuleTable.select(cur + diff);
                this.setDirty(true);
            }
        }
    }

    public void deleteRule() {
        if (this.fActiveItem != null) {
            this.disposeTableEditor();
            int i = this.fModel.getRules().indexOf(this.fActiveItem);
            this.fRuleTable.deselectAll();
            this.fRuleTable.remove(i);
            this.fModel.removeRule(i);
            this.setDirty(true);
        }
    }

    public void newRule() {
        Rule r = new Rule();
        if (this.fActiveItem != null) {
            this.disposeTableEditor();
            int i = this.fModel.getRules().indexOf(this.fActiveItem);
            if (i < 0) {
                i = 0;
            }
            this.fModel.addRule(i, (Item)r);
            TableItem item = new TableItem(this.fRuleTable, 0, i);
            this.initRuleTableItem(r, item, false);
            this.fRuleTable.select(i);
            this.fActiveItem = r;
            this.setDirty(true);
        } else {
            this.fModel.addRule((Item)r);
            TableItem item = new TableItem(this.fRuleTable, 0);
            this.initRuleTableItem(r, item, false);
            this.fRuleTable.select(this.fRuleTable.getChildren().length);
            this.setDirty(true);
        }
    }

    public void formatRule() {
        if (this.fActiveItem != null && this.fActiveItem instanceof Rule) {
            Rule rule = (Rule)this.fActiveItem;
            this.disposeTableEditor();
            String box = rule.getBoxString();
            try {
                String formatted = BoxFactory.formatBox((String)box);
                if (formatted != null) {
                    rule.setBoxString(formatted);
                    int i = this.fModel.getRules().indexOf(rule);
                    this.fRuleTable.getItem(i).setText(1, formatted);
                    this.setDirty(true);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void addRuleFromExample() {
        String result;
        this.disposeTableEditor();
        IInputValidator v = new IInputValidator(){

            public String isValid(String newText) {
                Parser parser = RuleTable.this.fModel.getParser();
                if (parser.parseObject(newText) != null) {
                    return null;
                }
                return "Not a valid string";
            }
        };
        InputDialog dialog = new InputDialog(this.fRuleTable.getShell(), "provide your example", "", null, v);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.getReturnCode() == 0 && (result = dialog.getValue()) != null) {
            this.newRule();
            Rule rule = (Rule)this.fActiveItem;
            String box = BoxStringBuilder.exampleToBox((String)result);
            rule.setBoxString(box);
            int i = this.fModel.getRules().indexOf(this.fActiveItem);
            TableItem item = this.fRuleTable.getItem(i);
            this.updateRuleTableItem(item, rule, true);
            this.setDirty(true);
        }
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    private final class SeparatorModifier
    implements ModifyListener {
        private SeparatorModifier() {
        }

        public void modifyText(ModifyEvent e) {
            Text text = (Text)RuleTable.this.fTableEditor.getEditor();
            String l = text.getText();
            TableItem i = RuleTable.this.fTableEditor.getItem();
            i.setText(1, l);
            Separator sep = (Separator)RuleTable.this.fTableEditor.getItem().getData();
            sep.setLabel(l);
            RuleTable.this.updateSeparatorTableItem(i, l);
            RuleTable.this.setDirty(true);
        }
    }

    private final class RuleModifier
    implements ModifyListener {
        private RuleModifier() {
        }

        public void modifyText(ModifyEvent e) {
            Text text = (Text)RuleTable.this.fTableEditor.getEditor();
            String b = text.getText();
            TableItem i = RuleTable.this.fTableEditor.getItem();
            i.setText(1, b);
            Rule rule = (Rule)RuleTable.this.fTableEditor.getItem().getData();
            rule.setBoxString(b);
            RuleTable.this.updateRuleTableItem(i, rule, true);
            RuleTable.this.setDirty(true);
        }
    }
}

