/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.editor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.imp.formatting.spec.Specification;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class SpaceOptionTable
implements IEditorPart {
    private Table optionTable;
    private final int NAME_COLUMN = 0;
    private final int VALUE_COLUMN = 1;
    private static final String NAME_PROPERTY = "name";
    private static final String VALUE_PROPERTY = "value";
    private TableItem activeOption;
    private List<IPropertyListener> listeners;
    private Specification model;
    private boolean dirty = false;
    private IEditorSite site;
    private IEditorInput input;
    private TableViewer tableViewer;

    public SpaceOptionTable(Specification model) {
        this.model = model;
        this.listeners = new LinkedList<IPropertyListener>();
    }

    public void setModel(Specification model) {
        this.model = model;
        this.refresh();
    }

    public void addPropertyListener(IPropertyListener l) {
        this.listeners.add(l);
    }

    private void firePropertyChange(int change) {
        for (IPropertyListener l : this.listeners) {
            l.propertyChanged((Object)this, change);
        }
    }

    public IEditorInput getEditorInput() {
        return this.input;
    }

    public IEditorSite getEditorSite() {
        return this.site;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.site = site;
        this.input = input;
    }

    public void dispose() {
        this.optionTable.dispose();
    }

    public IWorkbenchPartSite getSite() {
        return this.site;
    }

    public String getTitle() {
        return "Options";
    }

    public Image getTitleImage() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove(listener);
    }

    public void setFocus() {
        this.optionTable.setFocus();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        this.optionTable = new Table(parent, 65536);
        this.optionTable.setLinesVisible(true);
        this.optionTable.setHeaderVisible(true);
        TableColumn name = new TableColumn(this.optionTable, 0);
        name.setText("Key");
        name.setResizable(true);
        TableColumn value = new TableColumn(this.optionTable, 0);
        value.setText("Value");
        value.setResizable(true);
        this.tableViewer = new TableViewer(this.optionTable);
        name.pack();
        value.pack();
        this.createCellEditor();
    }

    private void createCellEditor() {
        this.tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                if (SpaceOptionTable.NAME_PROPERTY.equals(property)) {
                    return ((EditableTableItem)element).getName();
                }
                return ((EditableTableItem)element).getValue().toString();
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                EditableTableItem data = (EditableTableItem)tableItem.getData();
                if (SpaceOptionTable.NAME_PROPERTY.equals(property)) {
                    data.setName(value.toString());
                } else {
                    data.setValue(Integer.parseInt(value.toString()));
                }
                SpaceOptionTable.this.setDirty(true);
                SpaceOptionTable.this.tableViewer.refresh((Object)data);
            }
        });
        TextCellEditor nameEditor = new TextCellEditor((Composite)this.optionTable, 2048);
        ((Text)nameEditor.getControl()).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                int start = 0;
                e.doit = true;
                if (e.start == 0) {
                    e.doit = e.text.startsWith("$");
                    start = 1;
                }
                for (int i = start; i < e.text.length() && e.doit; ++i) {
                    e.doit = Character.isLetter(e.text.charAt(i));
                }
            }
        });
        TextCellEditor valueEditor = new TextCellEditor((Composite)this.optionTable, 2048);
        ((Text)valueEditor.getControl()).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
                for (int i = 0; i < e.text.length() && e.doit; ++i) {
                    e.doit = Character.isDigit(e.text.charAt(i));
                }
            }
        });
        this.tableViewer.setCellEditors(new CellEditor[]{nameEditor, valueEditor});
        this.tableViewer.setColumnProperties(new String[]{NAME_PROPERTY, VALUE_PROPERTY});
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((EditableTableItem)element).getName();
                    }
                    case 1: {
                        return "" + ((EditableTableItem)element).getValue();
                    }
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
    }

    public void refresh() {
        this.optionTable.removeAll();
        Iterator iter = this.model.getSpaceOptions();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            EditableTableItem item = new EditableTableItem(this.model, name, this.model.getSpaceOption(name));
            this.tableViewer.add((Object)item);
        }
        for (TableColumn c : this.optionTable.getColumns()) {
            c.pack();
        }
    }

    public void setDirty(boolean b) {
        if (this.dirty != b) {
            this.dirty = b;
            this.firePropertyChange(257);
        }
    }

    public void newOption() {
        this.model.setSpaceOption("$exampleKey", 1);
        EditableTableItem item = new EditableTableItem(this.model, "$exampleKey", 1);
        this.tableViewer.add((Object)item);
        this.setDirty(true);
    }

    public void deleteOption() {
        if (this.activeOption != null) {
            this.model.removeSpaceOption(this.activeOption.getText(0));
            this.optionTable.remove(this.optionTable.indexOf(this.activeOption));
            this.activeOption = null;
            this.setDirty(true);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private class EditableTableItem {
        private String name;
        private Integer value;
        private Specification model;

        public EditableTableItem(Specification m, String n, Integer v) {
            this.model = m;
            this.name = n;
            this.value = v;
        }

        public String getName() {
            return this.name;
        }

        public Integer getValue() {
            return this.value;
        }

        public void setName(String name) {
            Integer value = this.model.getSpaceOption(this.name);
            this.model.removeSpaceOption(this.name);
            this.model.setSpaceOption(name, value.intValue());
            this.name = name;
        }

        public void setValue(Integer value) {
            this.model.setSpaceOption(this.name, value.intValue());
            this.value = value;
        }
    }
}

