/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.formatting.spec;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.IASTAdapter;
import org.eclipse.imp.utils.ExtensionFactory;

public class ExtensionPointBinder {
    private Language fLanguage;
    private IParseController objectParser;
    private IASTAdapter adapter;
    private IPath specificationPath;

    public ExtensionPointBinder(Language language) throws Exception {
        this.fLanguage = language;
        this.adapter = (IASTAdapter)ExtensionFactory.createServiceExtensionForPlugin((Language)this.fLanguage, (String)"org.eclipse.imp.formatting", (String)"formattingSpecification", (String)"astAdapter");
        if (this.adapter == null) {
            throw new Exception("Can not find extension for astAdapter");
        }
        this.objectParser = (IParseController)ExtensionFactory.createServiceExtensionForPlugin((Language)this.fLanguage, (String)"org.eclipse.imp.formatting", (String)"formattingSpecification", (String)"parseController");
        if (this.objectParser == null) {
            throw new Exception("Can not find extension for parser");
        }
    }

    public Language getLanguage() {
        return this.fLanguage;
    }

    public IParseController getObjectParser() {
        return this.objectParser;
    }

    public IASTAdapter getASTAdapter() {
        return this.adapter;
    }

    public IPath getSpecificationPath() {
        if (this.specificationPath == null) {
            try {
                IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.imp.formatting", "formattingSpecification");
                URL url = ExtensionFactory.createResourceURL((String)this.fLanguage.getName(), (IExtensionPoint)extensionPoint, (String)"file");
                this.specificationPath = new Path(FileLocator.toFileURL((URL)url).getPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.specificationPath;
    }

    public void dispose() {
    }
}

