/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.java.hosted;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class BuildPathUtils {
    public static String getBareName(IFile file, IJavaProject project) throws JavaModelException {
        return BuildPathUtils.getBareName(file.getFullPath(), project);
    }

    public static String getBareName(String path, IJavaProject project) throws JavaModelException {
        return BuildPathUtils.getBareName((IPath)new Path(path), project);
    }

    public static String getBareName(IPath filePath, IJavaProject project) throws JavaModelException {
        for (IClasspathEntry cpEntry : project.getRawClasspath()) {
            if (cpEntry.getEntryKind() != 3 || !cpEntry.getPath().isPrefixOf(filePath) || BuildPathUtils.isExcluded(filePath, cpEntry)) continue;
            return filePath.makeRelativeTo(cpEntry.getPath()).removeFileExtension().toOSString();
        }
        return null;
    }

    public static boolean isExcluded(IPath filePath, IClasspathEntry srcEntry) {
        IPath[] exclusionPatterns;
        IPath relFilePath = filePath.makeRelativeTo(srcEntry.getPath());
        IPath[] inclusionPatterns = srcEntry.getInclusionPatterns();
        if (inclusionPatterns != null && inclusionPatterns.length != 0) {
            boolean foundMatch = false;
            for (IPath pattern : inclusionPatterns) {
                if (!BuildPathUtils.matches(relFilePath, pattern)) continue;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                return true;
            }
        }
        if ((exclusionPatterns = srcEntry.getExclusionPatterns()) != null && exclusionPatterns.length != 0) {
            for (IPath pattern : exclusionPatterns) {
                if (!BuildPathUtils.matches(relFilePath, pattern)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExcluded(IPath filePath, IJavaProject project) {
        try {
            if (project == null) {
                return true;
            }
            IPath workspace = project.getProject().getLocation().removeLastSegments(1);
            if (workspace.isPrefixOf(filePath)) {
                filePath = filePath.makeRelativeTo(workspace);
            }
            for (IClasspathEntry cpEntry : project.getRawClasspath()) {
                if (cpEntry.getEntryKind() != 3 || !cpEntry.getPath().isPrefixOf(filePath) || BuildPathUtils.isExcluded(filePath, cpEntry)) continue;
                return false;
            }
        }
        catch (JavaModelException e) {
            return true;
        }
        return true;
    }

    private static boolean matches(IPath path, IPath pattern) {
        if (path.equals(pattern)) {
            return true;
        }
        if (pattern.segmentCount() == 1 && pattern.segment(0).equals("**")) {
            return true;
        }
        if (path.isEmpty() && !pattern.isEmpty()) {
            if (!pattern.segment(0).equals("**")) {
                return false;
            }
            return BuildPathUtils.matches(path, pattern.removeFirstSegments(1));
        }
        if (!path.isEmpty() && pattern.isEmpty()) {
            return false;
        }
        if (pattern.isPrefixOf(path)) {
            return true;
        }
        String pathFirst = path.segment(0);
        String patternFirst = pattern.segment(0);
        if (patternFirst.equals("**")) {
            IPath patternNext = pattern.removeFirstSegments(1);
            for (int i = 0; i < path.segmentCount(); ++i) {
                if (!BuildPathUtils.matches(path.removeFirstSegments(i), patternNext)) continue;
                return true;
            }
            return false;
        }
        if (!BuildPathUtils.segMatches(pathFirst, patternFirst)) {
            return false;
        }
        return BuildPathUtils.matches(path.removeFirstSegments(1), pattern.removeFirstSegments(1));
    }

    private static boolean segMatches(String seg, String pattern) {
        if (seg.equals(pattern) || pattern.equals("*")) {
            return true;
        }
        if (seg.equals("") && !pattern.equals("")) {
            if (pattern.charAt(0) != '*') {
                return false;
            }
            return BuildPathUtils.segMatches(seg, pattern.substring(1));
        }
        if (!seg.equals("") && pattern.equals("")) {
            return false;
        }
        char patternFirst = pattern.charAt(0);
        char segFirst = seg.charAt(0);
        if (patternFirst == '*') {
            String patternNext = pattern.substring(1);
            for (int i = 0; i < seg.length(); ++i) {
                if (!BuildPathUtils.segMatches(seg.substring(i), patternNext)) continue;
                return true;
            }
            return false;
        }
        if (patternFirst == '?') {
            return BuildPathUtils.segMatches(seg.substring(1), pattern.substring(1));
        }
        if (patternFirst != segFirst) {
            return false;
        }
        return BuildPathUtils.segMatches(seg.substring(1), pattern.substring(1));
    }
}

