/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.editor;

import java.util.ArrayList;
import java.util.HashSet;
import lpg.runtime.IAst;
import lpg.runtime.IToken;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.imp.lpg.parser.LPGParser;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.services.ISourceFormatter;

public class LPGFormatter
implements ILanguageService,
ISourceFormatter {
    private int fIndentSize = 6;
    private String fIndentString;
    private boolean fIndentProducesToWidestNonTerm = false;
    private SegmentKeywordCase fSegmentKeywordCase = SegmentKeywordCase.Capitalized;

    public void formatterStarts(String initialIndentation) {
        this.fIndentSize = 4;
        StringBuffer buff = new StringBuffer(this.fIndentSize);
        for (int i = 0; i < this.fIndentSize; ++i) {
            buff.append(' ');
        }
        this.fIndentString = buff.toString();
        this.fIndentProducesToWidestNonTerm = false;
    }

    public String format(IParseController parseController, String content, boolean isLineStart, String indentation, int[] positions) {
        final StringBuffer fBuff = new StringBuffer();
        final HashSet fAdjunctTokens = new HashSet();
        final IAst[] adjunctNode = new LPGParser.ASTNode[1];
        final ArrayList fFollowingAdjuncts = new ArrayList();
        LPGParser.LPG root = (LPGParser.LPG)parseController.getCurrentAst();
        root.accept(new LPGParser.AbstractVisitor(){
            private int prodCount;
            private int prodIndent;

            public void unimplementedVisitor(String s) {
                System.out.println("Unhandled node type: " + s);
            }

            public boolean preVisit(IAst n) {
                IToken[] precAdjuncts;
                IToken left = n.getLeftIToken();
                for (IToken adjunct : precAdjuncts = left.getPrecedingAdjuncts()) {
                    if (!fAdjunctTokens.contains(adjunct)) {
                        fBuff.append("    ");
                        fBuff.append(adjunct);
                        fBuff.append('\n');
                    }
                    fAdjunctTokens.add(adjunct);
                }
                if (fFollowingAdjuncts.size() == 0) {
                    IToken[] follAdjuncts;
                    IToken right = n.getRightIToken();
                    for (IToken adjunct : follAdjuncts = right.getFollowingAdjuncts()) {
                        if (fAdjunctTokens.contains(adjunct)) continue;
                        fFollowingAdjuncts.add(adjunct);
                        fAdjunctTokens.add(adjunct);
                    }
                    adjunctNode[0] = n;
                }
                return true;
            }

            public void postVisit(IAst n) {
                if (n == adjunctNode[0]) {
                    for (IToken adjunct : fFollowingAdjuncts) {
                        fBuff.append("    ");
                        fBuff.append(adjunct);
                        fBuff.append('\n');
                    }
                    fFollowingAdjuncts.clear();
                }
            }

            public void endVisit(LPGParser.option_specList n) {
                fBuff.append('\n');
            }

            public boolean visit(LPGParser.option_spec n) {
                fBuff.append("%options ");
                return true;
            }

            private void emitSegmentKeyword(String keyword) {
                fBuff.append('%');
                switch (LPGFormatter.this.fSegmentKeywordCase) {
                    case Lowercase: {
                        fBuff.append(keyword.toLowerCase());
                        break;
                    }
                    case Uppercase: {
                        fBuff.append(keyword.toUpperCase());
                        break;
                    }
                    case Capitalized: {
                        String lowerKey = keyword.toLowerCase();
                        String capKey = Character.toUpperCase(lowerKey.charAt(0)) + lowerKey.substring(1);
                        fBuff.append(capKey);
                    }
                }
                fBuff.append('\n');
            }

            public boolean visit(LPGParser.optionList n) {
                for (int i = 0; i < n.size(); ++i) {
                    if (i > 0) {
                        fBuff.append(",");
                    }
                    LPGParser.option opt = n.getoptionAt(i);
                    opt.accept(this);
                }
                return false;
            }

            public void endVisit(LPGParser.option_spec n) {
                fBuff.append('\n');
            }

            public boolean visit(LPGParser.option n) {
                fBuff.append(n.getSYMBOL());
                return true;
            }

            public boolean visit(LPGParser.option_value__EQUAL_SYMBOL n) {
                fBuff.append("=" + n.getSYMBOL());
                return false;
            }

            public boolean visit(LPGParser.option_value__EQUAL_LEFT_PAREN_symbol_list_RIGHT_PAREN n) {
                fBuff.append('(');
                LPGParser.SYMBOLList symList = n.getsymbol_list();
                for (int i = 0; i < symList.size(); ++i) {
                    if (i > 0) {
                        fBuff.append(',');
                    }
                    fBuff.append(symList.getSYMBOLAt(i));
                }
                fBuff.append(')');
                return false;
            }

            public boolean visit(LPGParser.NoticeSeg n) {
                this.emitSegmentKeyword("Notice");
                return true;
            }

            public void endVisit(LPGParser.NoticeSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.GlobalsSeg n) {
                this.emitSegmentKeyword("Globals");
                fBuff.append(LPGFormatter.this.fIndentString);
                return true;
            }

            public void endVisit(LPGParser.GlobalsSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.HeadersSeg n) {
                this.emitSegmentKeyword("Headers");
                return true;
            }

            public void endVisit(LPGParser.HeadersSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.IdentifierSeg n) {
                this.emitSegmentKeyword("Identifier");
                return true;
            }

            public void endVisit(LPGParser.IdentifierSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.EofSeg n) {
                this.emitSegmentKeyword("EOF");
                return true;
            }

            public void endVisit(LPGParser.EofSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.terminal_symbol__SYMBOL n) {
                fBuff.append(LPGFormatter.this.fIndentString);
                fBuff.append(n.getSYMBOL());
                fBuff.append('\n');
                return false;
            }

            public boolean visit(LPGParser.DefineSeg n) {
                this.emitSegmentKeyword("Define");
                return true;
            }

            public void endVisit(LPGParser.DefineSeg n) {
                this.appendSegmentEnd();
            }

            public void endVisit(LPGParser.defineSpec n) {
                fBuff.append(LPGFormatter.this.fIndentString);
                fBuff.append(n.getmacro_name_symbol());
                fBuff.append(' ');
                fBuff.append(n.getmacro_segment());
                fBuff.append('\n');
            }

            public boolean visit(LPGParser.TerminalsSeg n) {
                this.emitSegmentKeyword("Terminals");
                return true;
            }

            public void endVisit(LPGParser.TerminalsSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.terminal n) {
                fBuff.append(LPGFormatter.this.fIndentString + n.getterminal_symbol());
                if (n.getoptTerminalAlias() != null) {
                    fBuff.append(" ::= " + n.getoptTerminalAlias().getname());
                }
                fBuff.append('\n');
                return false;
            }

            public boolean visit(LPGParser.StartSeg n) {
                this.emitSegmentKeyword("Start");
                return true;
            }

            public void endVisit(LPGParser.StartSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.start_symbol__SYMBOL n) {
                fBuff.append(LPGFormatter.this.fIndentString);
                fBuff.append(n.getSYMBOL());
                fBuff.append('\n');
                return false;
            }

            public boolean visit(LPGParser.start_symbol__MACRO_NAME n) {
                fBuff.append(n.getMACRO_NAME());
                return false;
            }

            public boolean visit(LPGParser.AstSeg n) {
                this.emitSegmentKeyword("AST");
                return true;
            }

            public void endVisit(LPGParser.AstSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.EolSeg n) {
                this.emitSegmentKeyword("EOL");
                return true;
            }

            public void endVisit(LPGParser.EolSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.ErrorSeg n) {
                this.emitSegmentKeyword("Error");
                return true;
            }

            public void endVisit(LPGParser.ErrorSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.ExportSeg n) {
                this.emitSegmentKeyword("Export");
                return true;
            }

            public void endVisit(LPGParser.ExportSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.ImportSeg n) {
                this.emitSegmentKeyword("Import");
                return true;
            }

            public boolean visit(LPGParser.import_segment n) {
                fBuff.append(n.getSYMBOL());
                fBuff.append('\n');
                return super.visit(n);
            }

            public boolean visit(LPGParser.drop_command__DROPRULES_KEY_drop_rules n) {
                fBuff.append(n.getDROPRULES_KEY());
                return true;
            }

            public boolean visit(LPGParser.drop_rule n) {
                fBuff.append(n.getSYMBOL());
                if (n.getoptMacroName() != null) {
                    fBuff.append(' ');
                    fBuff.append(n.getoptMacroName());
                }
                fBuff.append(' ');
                fBuff.append(n.getproduces());
                fBuff.append(' ');
                return super.visit(n);
            }

            public void endVisit(LPGParser.ImportSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.IncludeSeg n) {
                this.emitSegmentKeyword("Include");
                return true;
            }

            public boolean visit(LPGParser.include_segment n) {
                fBuff.append(LPGFormatter.this.fIndentString);
                fBuff.append(n.getSYMBOL());
                fBuff.append('\n');
                return false;
            }

            public void endVisit(LPGParser.IncludeSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.KeywordsSeg n) {
                this.emitSegmentKeyword("Keywords");
                return true;
            }

            public boolean visit(LPGParser.keywordSpec n) {
                fBuff.append(n.getname());
                if (n.getproduces() != null) {
                    fBuff.append(' ');
                    fBuff.append(n.getproduces());
                    fBuff.append(' ');
                    fBuff.append(n.getterminal_symbol());
                    fBuff.append('\n');
                }
                return super.visit(n);
            }

            public void endVisit(LPGParser.KeywordsSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.NamesSeg n) {
                this.emitSegmentKeyword("Names");
                return true;
            }

            public boolean visit(LPGParser.nameSpec n) {
                fBuff.append(n.getname());
                fBuff.append(' ');
                fBuff.append(n.getproduces());
                fBuff.append(' ');
                fBuff.append(n.getname3());
                fBuff.append('\n');
                return super.visit(n);
            }

            public void endVisit(LPGParser.NamesSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.PredecessorSeg n) {
                this.emitSegmentKeyword("Predecessor");
                return true;
            }

            public void endVisit(LPGParser.PredecessorSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.RecoverSeg n) {
                this.emitSegmentKeyword("Recover");
                return true;
            }

            public boolean visit(LPGParser.recover_symbol n) {
                fBuff.append(n.getSYMBOL());
                fBuff.append('\n');
                return false;
            }

            public void endVisit(LPGParser.RecoverSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.SoftKeywordsSeg n) {
                this.emitSegmentKeyword("SoftKeywords");
                return true;
            }

            public void endVisit(LPGParser.SoftKeywordsSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.TrailersSeg n) {
                this.emitSegmentKeyword("Trailers");
                return true;
            }

            public void endVisit(LPGParser.TrailersSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.TypesSeg n) {
                this.emitSegmentKeyword("Types");
                return true;
            }

            public void endVisit(LPGParser.TypesSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.RulesSeg n) {
                this.emitSegmentKeyword("Rules");
                if (LPGFormatter.this.fIndentProducesToWidestNonTerm) {
                    LPGParser.rules_segment rulesSegment = n.getrules_segment();
                    LPGParser.nonTermList nonTermList2 = rulesSegment.getnonTermList();
                    int maxLHSSymWid = 0;
                    for (int i = 0; i < nonTermList2.size(); ++i) {
                        int lhsSymWid = nonTermList2.getElementAt(i).getLeftIToken().toString().length();
                        if (lhsSymWid <= maxLHSSymWid) continue;
                        maxLHSSymWid = lhsSymWid;
                    }
                    this.prodIndent = LPGFormatter.this.fIndentSize + maxLHSSymWid + 1;
                }
                return true;
            }

            public void endVisit(LPGParser.RulesSeg n) {
                this.appendSegmentEnd();
            }

            public boolean visit(LPGParser.nonTerm n) {
                fBuff.append(LPGFormatter.this.fIndentString);
                LPGParser.RuleName lhsName = n.getruleNameWithAttributes();
                fBuff.append(lhsName);
                if (LPGFormatter.this.fIndentProducesToWidestNonTerm) {
                    for (int i = lhsName.toString().length() + LPGFormatter.this.fIndentSize + 1; i <= this.prodIndent; ++i) {
                        fBuff.append(' ');
                    }
                } else {
                    fBuff.append(' ');
                }
                fBuff.append(n.getproduces());
                this.prodCount = 0;
                if (!LPGFormatter.this.fIndentProducesToWidestNonTerm) {
                    this.prodIndent = LPGFormatter.this.fIndentSize + lhsName.toString().length() + 1;
                }
                return true;
            }

            public boolean visit(LPGParser.RuleName n) {
                return true;
            }

            public void endVisit(LPGParser.nonTerm n) {
                fBuff.append('\n');
            }

            public boolean visit(LPGParser.rule n) {
                if (this.prodCount > 0) {
                    fBuff.append('\n');
                    for (int i = 0; i < this.prodIndent; ++i) {
                        fBuff.append(' ');
                    }
                    fBuff.append("|  ");
                }
                ++this.prodCount;
                return true;
            }

            public boolean visit(LPGParser.action_segment n) {
                fBuff.append(' ');
                fBuff.append(n.getBLOCK());
                fBuff.append('\n');
                return false;
            }

            public boolean visit(LPGParser.AliasSeg n) {
                fBuff.append("%Alias");
                return true;
            }

            public void endVisit(LPGParser.AliasSeg n) {
                this.appendSegmentEnd();
            }

            private void appendSegmentEnd() {
                this.emitSegmentKeyword("End");
                fBuff.append('\n');
            }

            public boolean visit(LPGParser.symWithAttrs__EMPTY_KEY n) {
                fBuff.append(' ');
                fBuff.append(n.getEMPTY_KEY());
                return false;
            }

            public boolean visit(LPGParser.symWithAttrs__SYMBOL_optAttrList n) {
                fBuff.append(' ');
                fBuff.append(n.getSYMBOL());
                LPGParser.symAttrs attr = n.getoptAttrList();
                if (attr != null && attr.getMACRO_NAME() != null) {
                    fBuff.append(attr.getMACRO_NAME());
                }
                return false;
            }

            public boolean visit(LPGParser.symAttrs n) {
                fBuff.append(' ');
                fBuff.append(n.getMACRO_NAME());
                return false;
            }
        });
        return fBuff.toString();
    }

    public void formatterStops() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SegmentKeywordCase {
        Uppercase,
        Lowercase,
        Capitalized;

    }
}

