/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.lpg.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.imp.lpg.search.LPGSearchContentProvider;
import org.eclipse.imp.lpg.search.LPGSearchResultPage;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class LPGSearchTreeContentProvider
extends LPGSearchContentProvider
implements ITreeContentProvider {
    private Map fChildrenMap;

    public LPGSearchTreeContentProvider(LPGSearchResultPage page) {
        super(page);
    }

    public void elementsChanged(Object[] updatedElements) {
        AbstractTreeViewer viewer = (AbstractTreeViewer)this.getPage().getViewer();
        if (this.fResult == null) {
            return;
        }
        HashSet toRemove = new HashSet();
        HashSet toUpdate = new HashSet();
        HashMap toAdd = new HashMap();
        for (int i = 0; i < updatedElements.length; ++i) {
            if (this.getPage().getDisplayedMatchCount(updatedElements[i]) > 0) {
                this.insert(toAdd, toUpdate, updatedElements[i]);
                continue;
            }
            this.remove(toRemove, toUpdate, updatedElements[i]);
        }
        viewer.remove(toRemove.toArray());
        for (Object parent : toAdd.keySet()) {
            HashSet children = (HashSet)toAdd.get(parent);
            viewer.add(parent, children.toArray());
        }
        Iterator elementsToUpdate = toUpdate.iterator();
        while (elementsToUpdate.hasNext()) {
            viewer.refresh(elementsToUpdate.next());
        }
    }

    protected void insert(Map toAdd, Set toUpdate, Object child) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (toAdd != null) {
                    this.insertInto(parent, child, toAdd);
                }
            } else {
                if (toUpdate != null) {
                    toUpdate.add(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild((Object)this.fResult, child) && toAdd != null) {
            this.insertInto((Object)this.fResult, child, toAdd);
        }
    }

    private boolean insertChild(Object parent, Object child) {
        return this.insertInto(parent, child, this.fChildrenMap);
    }

    private boolean insertInto(Object parent, Object child, Map map) {
        HashSet<Object> children = (HashSet<Object>)map.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            map.put(parent, children);
        }
        return children.add(child);
    }

    protected void remove(Set toRemove, Set toUpdate, Object element) {
        if (this.hasChildren(element)) {
            if (toUpdate != null) {
                toUpdate.add(element);
            }
        } else if (this.getPage().getDisplayedMatchCount(element) == 0) {
            this.fChildrenMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                if (this.removeFromSiblings(element, parent)) {
                    this.remove(toRemove, toUpdate, parent);
                }
            } else if (this.removeFromSiblings(element, (Object)this.fResult) && toRemove != null) {
                toRemove.add(element);
            }
        } else if (toUpdate != null) {
            toUpdate.add(element);
        }
    }

    private boolean removeFromSiblings(Object element, Object parent) {
        Set siblings = (Set)this.fChildrenMap.get(parent);
        if (siblings != null) {
            return siblings.remove(element);
        }
        return false;
    }

    public void clear() {
        this.initialize(this.fResult);
        this.getPage().getViewer().refresh();
    }

    public Object[] getChildren(Object parentElement) {
        return EMPTY_ARR;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }
}

