/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Map;
import org.eclipse.imp.pdb.facts.IConstructor;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.AnnotatedConstructorBase;
import org.eclipse.imp.pdb.facts.impl.fast.Constructor;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.util.ShareableHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedConstructor
extends AnnotatedConstructorBase {
    protected final ShareableHashMap<String, IValue> annotations;

    public static Constructor createAnnotatedConstructor(Type constructorType, IValue[] children, ShareableHashMap<String, IValue> annotations) {
        int aSize = annotations.size();
        if (1 == aSize) {
            String keyOne = (String)annotations.keySet().toArray()[0];
            return new AnnotatedConstructorOne(constructorType, children, keyOne, annotations.get(keyOne));
        }
        if (2 == aSize) {
            Object[] anns = annotations.keySet().toArray();
            return new AnnotatedConstructorTwo(constructorType, children, (String)anns[0], annotations.get((String)anns[0]), (String)anns[1], annotations.get((String)anns[1]));
        }
        if (3 == aSize) {
            Object[] anns = annotations.keySet().toArray();
            return new AnnotatedConstructorThree(constructorType, children, (String)anns[0], annotations.get((String)anns[0]), (String)anns[1], annotations.get((String)anns[1]), (String)anns[2], annotations.get((String)anns[2]));
        }
        return new AnnotatedConstructor(constructorType, children, annotations);
    }

    protected AnnotatedConstructor(Type constructorType, IValue[] children, ShareableHashMap<String, IValue> annotations) {
        super(constructorType, children);
        this.annotations = annotations;
    }

    @Override
    public IConstructor set(int i, IValue arg) {
        IValue[] newChildren = (IValue[])this.children.clone();
        newChildren[i] = arg;
        return new AnnotatedConstructor(this.constructorType, newChildren, this.annotations);
    }

    @Override
    public boolean hasAnnotation(String label) {
        return this.annotations.containsKey(label);
    }

    @Override
    public IValue getAnnotation(String label) {
        return this.annotations.get(label);
    }

    @Override
    public Map<String, IValue> getAnnotations() {
        return new ShareableHashMap<String, IValue>(this.annotations);
    }

    @Override
    public IConstructor set(String label, IValue newChild) {
        IValue[] newChildren = (IValue[])this.children.clone();
        newChildren[this.constructorType.getFieldIndex((String)label)] = newChild;
        return new AnnotatedConstructor(this.constructorType, newChildren, this.annotations);
    }

    @Override
    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label, IValue value) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>(this.annotations);
        newAnnotations.put(label, value);
        return newAnnotations;
    }

    @Override
    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>(this.annotations);
        newAnnotations.remove(label);
        return newAnnotations;
    }

    @Override
    protected ShareableHashMap<String, IValue> getUpdatedAnnotations(Map<String, IValue> newAnnos) {
        ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>(this.annotations);
        for (Map.Entry<String, IValue> entry : newAnnos.entrySet()) {
            String key = entry.getKey();
            IValue value = entry.getValue();
            newAnnotations.put(key, value);
        }
        return newAnnotations;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            AnnotatedConstructor other = (AnnotatedConstructor)o;
            return this.annotations.equals(other.annotations);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotatedConstructorThree
    extends AnnotatedConstructorBase {
        private String annotationLabelOne;
        private IValue annotationValueOne;
        private String annotationLabelTwo;
        private IValue annotationValueTwo;
        private String annotationLabelThree;
        private IValue annotationValueThree;

        protected AnnotatedConstructorThree(Type constructorType, IValue[] children, String annLabelOne, IValue annValueOne, String annLabelTwo, IValue annValueTwo, String annLabelThree, IValue annValueThree) {
            super(constructorType, children);
            this.annotationLabelOne = annLabelOne;
            this.annotationValueOne = annValueOne;
            this.annotationLabelTwo = annLabelTwo;
            this.annotationValueTwo = annValueTwo;
            this.annotationLabelThree = annLabelThree;
            this.annotationValueThree = annValueThree;
        }

        @Override
        public IConstructor set(int i, IValue arg) {
            IValue[] newChildren = (IValue[])this.children.clone();
            newChildren[i] = arg;
            return new AnnotatedConstructorThree(this.constructorType, newChildren, this.annotationLabelOne, this.annotationValueOne, this.annotationLabelTwo, this.annotationValueTwo, this.annotationLabelThree, this.annotationValueThree);
        }

        @Override
        public IConstructor set(String label, IValue newChild) {
            IValue[] newChildren = (IValue[])this.children.clone();
            newChildren[this.constructorType.getFieldIndex((String)label)] = newChild;
            return new AnnotatedConstructorThree(this.constructorType, newChildren, this.annotationLabelOne, this.annotationValueOne, this.annotationLabelTwo, this.annotationValueTwo, this.annotationLabelThree, this.annotationValueThree);
        }

        @Override
        public boolean hasAnnotation(String label) {
            return this.annotationLabelOne.equals(label) || this.annotationLabelTwo.equals(label) || this.annotationLabelThree.equals(label);
        }

        @Override
        public IValue getAnnotation(String label) {
            return this.annotationLabelOne.equals(label) ? this.annotationValueOne : (this.annotationLabelTwo.equals(label) ? this.annotationValueTwo : (this.annotationLabelThree.equals(label) ? this.annotationValueThree : null));
        }

        @Override
        public Map<String, IValue> getAnnotations() {
            ShareableHashMap<String, IValue> shm = new ShareableHashMap<String, IValue>();
            shm.put(this.annotationLabelOne, this.annotationValueOne);
            shm.put(this.annotationLabelTwo, this.annotationValueTwo);
            shm.put(this.annotationLabelThree, this.annotationValueThree);
            return shm;
        }

        @Override
        protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label, IValue value) {
            ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
            if (!this.annotationLabelOne.equals(label)) {
                newAnnotations.put(this.annotationLabelOne, this.annotationValueOne);
            }
            if (!this.annotationLabelTwo.equals(label)) {
                newAnnotations.put(this.annotationLabelTwo, this.annotationValueTwo);
            }
            if (!this.annotationLabelThree.equals(label)) {
                newAnnotations.put(this.annotationLabelThree, this.annotationValueThree);
            }
            newAnnotations.put(label, value);
            return newAnnotations;
        }

        @Override
        protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label) {
            ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
            if (!this.annotationLabelOne.equals(label)) {
                newAnnotations.put(this.annotationLabelOne, this.annotationValueOne);
            }
            if (!this.annotationLabelTwo.equals(label)) {
                newAnnotations.put(this.annotationLabelTwo, this.annotationValueTwo);
            }
            if (!this.annotationLabelThree.equals(label)) {
                newAnnotations.put(this.annotationLabelThree, this.annotationValueThree);
            }
            return newAnnotations;
        }

        @Override
        protected ShareableHashMap<String, IValue> getUpdatedAnnotations(Map<String, IValue> newAnnos) {
            ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
            boolean foundAnnotationLabelOne = false;
            boolean foundAnnotationLabelTwo = false;
            boolean foundAnnotationLabelThree = false;
            for (Map.Entry<String, IValue> entry : newAnnos.entrySet()) {
                String key = entry.getKey();
                IValue value = entry.getValue();
                if (key.equals(this.annotationLabelOne)) {
                    foundAnnotationLabelOne = true;
                }
                if (key.equals(this.annotationLabelTwo)) {
                    foundAnnotationLabelTwo = true;
                }
                if (key.equals(this.annotationLabelThree)) {
                    foundAnnotationLabelThree = true;
                }
                newAnnotations.put(key, value);
            }
            if (!foundAnnotationLabelOne) {
                newAnnotations.put(this.annotationLabelOne, this.annotationValueOne);
            }
            if (!foundAnnotationLabelTwo) {
                newAnnotations.put(this.annotationLabelTwo, this.annotationValueTwo);
            }
            if (!foundAnnotationLabelThree) {
                newAnnotations.put(this.annotationLabelThree, this.annotationValueThree);
            }
            return newAnnotations;
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o)) {
                AnnotatedConstructorThree other = (AnnotatedConstructorThree)o;
                return this.annotationLabelOne.equals(other.annotationLabelOne) && ((Object)this.annotationValueOne).equals(other.annotationValueOne) && this.annotationLabelTwo.equals(other.annotationLabelTwo) && ((Object)this.annotationValueTwo).equals(other.annotationValueTwo) && this.annotationLabelThree.equals(other.annotationLabelThree) && ((Object)this.annotationValueThree).equals(other.annotationValueThree);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotatedConstructorTwo
    extends AnnotatedConstructorBase {
        private String annotationLabelOne;
        private IValue annotationValueOne;
        private String annotationLabelTwo;
        private IValue annotationValueTwo;

        protected AnnotatedConstructorTwo(Type constructorType, IValue[] children, String annLabelOne, IValue annValueOne, String annLabelTwo, IValue annValueTwo) {
            super(constructorType, children);
            this.annotationLabelOne = annLabelOne;
            this.annotationValueOne = annValueOne;
            this.annotationLabelTwo = annLabelTwo;
            this.annotationValueTwo = annValueTwo;
        }

        @Override
        public IConstructor set(int i, IValue arg) {
            IValue[] newChildren = (IValue[])this.children.clone();
            newChildren[i] = arg;
            return new AnnotatedConstructorTwo(this.constructorType, newChildren, this.annotationLabelOne, this.annotationValueOne, this.annotationLabelTwo, this.annotationValueTwo);
        }

        @Override
        public IConstructor set(String label, IValue newChild) {
            IValue[] newChildren = (IValue[])this.children.clone();
            newChildren[this.constructorType.getFieldIndex((String)label)] = newChild;
            return new AnnotatedConstructorTwo(this.constructorType, newChildren, this.annotationLabelOne, this.annotationValueOne, this.annotationLabelTwo, this.annotationValueTwo);
        }

        @Override
        public boolean hasAnnotation(String label) {
            return this.annotationLabelOne.equals(label) || this.annotationLabelTwo.equals(label);
        }

        @Override
        public IValue getAnnotation(String label) {
            return this.annotationLabelOne.equals(label) ? this.annotationValueOne : (this.annotationLabelTwo.equals(label) ? this.annotationValueTwo : null);
        }

        @Override
        public Map<String, IValue> getAnnotations() {
            ShareableHashMap<String, IValue> shm = new ShareableHashMap<String, IValue>();
            shm.put(this.annotationLabelOne, this.annotationValueOne);
            shm.put(this.annotationLabelTwo, this.annotationValueTwo);
            return shm;
        }

        @Override
        protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label, IValue value) {
            ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
            if (!this.annotationLabelOne.equals(label)) {
                newAnnotations.put(this.annotationLabelOne, this.annotationValueOne);
            }
            if (!this.annotationLabelTwo.equals(label)) {
                newAnnotations.put(this.annotationLabelTwo, this.annotationValueTwo);
            }
            newAnnotations.put(label, value);
            return newAnnotations;
        }

        @Override
        protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label) {
            ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
            if (!this.annotationLabelOne.equals(label)) {
                newAnnotations.put(this.annotationLabelOne, this.annotationValueOne);
            }
            if (!this.annotationLabelTwo.equals(label)) {
                newAnnotations.put(this.annotationLabelTwo, this.annotationValueTwo);
            }
            return newAnnotations;
        }

        @Override
        protected ShareableHashMap<String, IValue> getUpdatedAnnotations(Map<String, IValue> newAnnos) {
            ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
            boolean foundAnnotationLabelOne = false;
            boolean foundAnnotationLabelTwo = false;
            for (Map.Entry<String, IValue> entry : newAnnos.entrySet()) {
                String key = entry.getKey();
                IValue value = entry.getValue();
                if (key.equals(this.annotationLabelOne)) {
                    foundAnnotationLabelOne = true;
                }
                if (key.equals(this.annotationLabelTwo)) {
                    foundAnnotationLabelTwo = true;
                }
                newAnnotations.put(key, value);
            }
            if (!foundAnnotationLabelOne) {
                newAnnotations.put(this.annotationLabelOne, this.annotationValueOne);
            }
            if (!foundAnnotationLabelTwo) {
                newAnnotations.put(this.annotationLabelTwo, this.annotationValueTwo);
            }
            return newAnnotations;
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o)) {
                AnnotatedConstructorTwo other = (AnnotatedConstructorTwo)o;
                return this.annotationLabelOne.equals(other.annotationLabelOne) && ((Object)this.annotationValueOne).equals(other.annotationValueOne) && this.annotationLabelTwo.equals(other.annotationLabelTwo) && ((Object)this.annotationValueTwo).equals(other.annotationValueTwo);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotatedConstructorOne
    extends AnnotatedConstructorBase {
        private String annotationLabelOne;
        private IValue annotationValueOne;

        protected AnnotatedConstructorOne(Type constructorType, IValue[] children, String annLabelOne, IValue annValueOne) {
            super(constructorType, children);
            this.annotationLabelOne = annLabelOne;
            this.annotationValueOne = annValueOne;
        }

        @Override
        public IConstructor set(int i, IValue arg) {
            IValue[] newChildren = (IValue[])this.children.clone();
            newChildren[i] = arg;
            return new AnnotatedConstructorOne(this.constructorType, newChildren, this.annotationLabelOne, this.annotationValueOne);
        }

        @Override
        public IConstructor set(String label, IValue newChild) {
            IValue[] newChildren = (IValue[])this.children.clone();
            newChildren[this.constructorType.getFieldIndex((String)label)] = newChild;
            return new AnnotatedConstructorOne(this.constructorType, newChildren, this.annotationLabelOne, this.annotationValueOne);
        }

        @Override
        public boolean hasAnnotation(String label) {
            return this.annotationLabelOne.equals(label);
        }

        @Override
        public IValue getAnnotation(String label) {
            return this.annotationLabelOne.equals(label) ? this.annotationValueOne : null;
        }

        @Override
        public Map<String, IValue> getAnnotations() {
            ShareableHashMap<String, IValue> shm = new ShareableHashMap<String, IValue>();
            shm.put(this.annotationLabelOne, this.annotationValueOne);
            return shm;
        }

        @Override
        protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label, IValue value) {
            ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
            if (!this.annotationLabelOne.equals(label)) {
                newAnnotations.put(this.annotationLabelOne, this.annotationValueOne);
            }
            newAnnotations.put(label, value);
            return newAnnotations;
        }

        @Override
        protected ShareableHashMap<String, IValue> getUpdatedAnnotations(String label) {
            ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
            if (!this.annotationLabelOne.equals(label)) {
                newAnnotations.put(this.annotationLabelOne, this.annotationValueOne);
            }
            return newAnnotations;
        }

        @Override
        protected ShareableHashMap<String, IValue> getUpdatedAnnotations(Map<String, IValue> newAnnos) {
            ShareableHashMap<String, IValue> newAnnotations = new ShareableHashMap<String, IValue>();
            boolean foundAnnotationLabelOne = false;
            for (Map.Entry<String, IValue> entry : newAnnos.entrySet()) {
                String key = entry.getKey();
                IValue value = entry.getValue();
                if (key.equals(this.annotationLabelOne)) {
                    foundAnnotationLabelOne = true;
                }
                newAnnotations.put(key, value);
            }
            if (!foundAnnotationLabelOne) {
                newAnnotations.put(this.annotationLabelOne, this.annotationValueOne);
            }
            return newAnnotations;
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o)) {
                AnnotatedConstructorOne other = (AnnotatedConstructorOne)o;
                return this.annotationLabelOne.equals(other.annotationLabelOne) && ((Object)this.annotationValueOne).equals(other.annotationValueOne);
            }
            return false;
        }
    }
}

