/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.imp.pdb.facts.IMap;
import org.eclipse.imp.pdb.facts.IMapWriter;
import org.eclipse.imp.pdb.facts.ITuple;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Map;
import org.eclipse.imp.pdb.facts.impl.util.collections.ShareableValuesHashMap;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapWriter
implements IMapWriter {
    protected Type keyType;
    protected Type valueType;
    protected final ShareableValuesHashMap data;
    protected IMap constructedMap;
    protected final boolean inferred;

    protected MapWriter(Type keyType, Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.inferred = false;
        this.data = new ShareableValuesHashMap();
        this.constructedMap = null;
    }

    protected MapWriter() {
        this.keyType = TypeFactory.getInstance().voidType();
        this.valueType = TypeFactory.getInstance().voidType();
        this.inferred = true;
        this.data = new ShareableValuesHashMap();
        this.constructedMap = null;
    }

    protected MapWriter(Type keyType, Type valueType, ShareableValuesHashMap data) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.data = data;
        this.inferred = false;
        this.constructedMap = null;
    }

    @Override
    public void put(IValue key, IValue value) {
        this.checkMutation();
        this.updateTypes(key, value);
        this.data.put(key, value);
    }

    private void updateTypes(IValue key, IValue value) {
        if (this.inferred) {
            this.keyType = this.keyType.lub(key.getType());
            this.valueType = this.valueType.lub(value.getType());
        }
    }

    @Override
    public void putAll(IMap map) {
        this.checkMutation();
        Iterator<Map.Entry<IValue, IValue>> entryIterator = map.entryIterator();
        while (entryIterator.hasNext()) {
            Map.Entry<IValue, IValue> entry = entryIterator.next();
            IValue key = entry.getKey();
            IValue value = entry.getValue();
            this.updateTypes(key, value);
            this.data.put(key, value);
        }
    }

    @Override
    public void putAll(java.util.Map<IValue, IValue> map) {
        this.checkMutation();
        for (Map.Entry<IValue, IValue> entry : map.entrySet()) {
            IValue key = entry.getKey();
            IValue value = entry.getValue();
            this.updateTypes(key, value);
            this.data.put(key, value);
        }
    }

    @Override
    public void insert(IValue ... values) {
        this.checkMutation();
        for (int i = values.length - 1; i >= 0; --i) {
            IValue value = values[i];
            if (!(value instanceof ITuple)) {
                throw new IllegalArgumentException("Argument must be of ITuple type.");
            }
            ITuple tuple = (ITuple)value;
            if (tuple.arity() != 2) {
                throw new IllegalArgumentException("Tuple must have an arity of 2.");
            }
            IValue key = tuple.get(0);
            IValue value2 = tuple.get(1);
            this.updateTypes(key, value2);
            this.put(key, value2);
        }
    }

    @Override
    public void insertAll(Iterable<IValue> collection) {
        this.checkMutation();
        for (IValue value : collection) {
            if (!(value instanceof ITuple)) {
                throw new IllegalArgumentException("Argument must be of ITuple type.");
            }
            ITuple tuple = (ITuple)value;
            if (tuple.arity() != 2) {
                throw new IllegalArgumentException("Tuple must have an arity of 2.");
            }
            IValue key = tuple.get(0);
            IValue value2 = tuple.get(1);
            this.updateTypes(key, value2);
            this.put(key, value2);
        }
    }

    protected void checkMutation() {
        if (this.constructedMap != null) {
            throw new UnsupportedOperationException("Mutation of a finalized map is not supported.");
        }
    }

    @Override
    public IMap done() {
        if (this.constructedMap == null) {
            this.constructedMap = new Map(this.keyType, this.valueType, this.data);
        }
        return this.constructedMap;
    }
}

