/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.facts.impl.fast;

import org.eclipse.imp.pdb.facts.IString;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.impl.fast.Value;
import org.eclipse.imp.pdb.facts.impl.fast.ValueFactory;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.facts.type.TypeFactory;
import org.eclipse.imp.pdb.facts.visitors.IValueVisitor;
import org.eclipse.imp.pdb.facts.visitors.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringValue
extends Value
implements IString {
    private static final Type STRING_TYPE = TypeFactory.getInstance().stringType();
    protected final String value;

    protected StringValue(String value) {
        this.value = value;
    }

    @Override
    public Type getType() {
        return STRING_TYPE;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public IString concat(IString other) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.value);
        buffer.append(other.getValue());
        return ValueFactory.getInstance().string(buffer.toString());
    }

    @Override
    public int compare(IString other) {
        int result = this.value.compareTo(other.getValue());
        if (result > 0) {
            return 1;
        }
        if (result < 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public <T> T accept(IValueVisitor<T> v) throws VisitorException {
        return v.visitString(this);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o.getClass() == this.getClass()) {
            StringValue otherString = (StringValue)o;
            return this.value.equals(otherString.value);
        }
        return false;
    }

    @Override
    public boolean isEqual(IValue value) {
        return this.equals(value);
    }
}

