/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.pdb.indexing;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.imp.editor.IResourceDocumentMapListener;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.parser.IModelListener;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.pdb.PDBPlugin;
import org.eclipse.imp.pdb.analysis.AnalysisException;
import org.eclipse.imp.pdb.analysis.AnalysisManager;
import org.eclipse.imp.pdb.analysis.IFactGenerator;
import org.eclipse.imp.pdb.analysis.IFactGeneratorFactory;
import org.eclipse.imp.pdb.analysis.IFactUpdater;
import org.eclipse.imp.pdb.facts.IValue;
import org.eclipse.imp.pdb.facts.db.FactBase;
import org.eclipse.imp.pdb.facts.db.IFactContext;
import org.eclipse.imp.pdb.facts.db.IFactKey;
import org.eclipse.imp.pdb.facts.db.context.ISourceEntityContext;
import org.eclipse.imp.pdb.facts.type.Type;
import org.eclipse.imp.pdb.indexing.IResourceKeyFactory;
import org.eclipse.imp.pdb.indexing.IResourcePredicate;
import org.eclipse.imp.pdb.indexing.IndexedDocumentDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;

public class Indexer
extends Job
implements IResourceDocumentMapListener {
    public static final int DOC_RESCAN_DELAY_MSEC_DEFAULT = 100;
    public static final int DOC_CHANGE_DELAY_DEFAULT = 1000;
    public static final int RESCHEDULE_DELAY_MSEC = 100;
    private final FactBase fFactBase = new FactBase();
    private final List<KeyManager> fKeyManagers = new LinkedList<KeyManager>();
    private final Map<IProject, Set<KeyManager>> fTrackedProjects = new HashMap<IProject, Set<KeyManager>>();
    private final Map<IResource, IDocument> fResourceToDocumentMap = new HashMap<IResource, IDocument>();
    private final Map<IDocument, IResource> fDocumentToResourceMap = new HashMap<IDocument, IResource>();
    private final Map<IResource, IndexedDocumentDescriptor> fDocumentMap = new HashMap<IResource, IndexedDocumentDescriptor>();
    private final DocumentChangeHandler fDocChangeHandler = new DocumentChangeHandler();
    private final Map<IPath, Set<IndexerDescriptor>> fScannerMap = new HashMap<IPath, Set<IndexerDescriptor>>();
    private final Map<IDocument, Long> fDocumentChangeTime = new HashMap<IDocument, Long>();
    private final Stack<WorkItem> fWorkQueue = new Stack();
    private final ChangedResourceHandler fListener = new ChangedResourceHandler();
    private final IModelListener fModelListener = new IndexModelListener();
    private final Object fJobFamily;
    private long fDocRescanDelay = 100L;
    private long fDocChangeDelay = 1000L;
    private long fQueueScanScheduleDelay = 100L;
    private boolean fInitialized = false;
    private boolean fIsWorking = false;

    public Indexer(String indexerName) {
        this(indexerName, null);
    }

    public Indexer(String indexerName, Object familyID) {
        super(indexerName);
        this.fJobFamily = familyID;
        this.setSystem(true);
    }

    public FactBase getFactBase() {
        return this.fFactBase;
    }

    public boolean belongsTo(Object family) {
        return this.fJobFamily == family;
    }

    public void initialize(long initialDelayMSecs) {
        this.initialize(initialDelayMSecs, 100L, 1000L, 100L);
    }

    public void initialize(long initialDelayMSecs, long docChangeDelayMSecs, long docRescanDelayMSecs, long queueScanDelayMSecs) {
        this.start(initialDelayMSecs);
        this.fDocChangeDelay = docChangeDelayMSecs;
        this.fDocRescanDelay = docRescanDelayMSecs;
        this.fQueueScanScheduleDelay = queueScanDelayMSecs;
    }

    public void shutdown() {
        this.stop();
    }

    private void start(long initialDelayMSecs) {
        if (!this.fInitialized) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fListener, 1);
            this.schedule(initialDelayMSecs);
            new DocumentChangeProcessor().schedule();
            this.fInitialized = true;
        }
    }

    private void stop() {
        this.cancel();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fListener);
    }

    public void manageKeysForProjects(IResourcePredicate projectFilter, IResourceKeyFactory keyFactory) {
        KeyManager mgr = new KeyManager(projectFilter, keyFactory);
        this.fKeyManagers.add(mgr);
        this.initialScan(mgr);
    }

    private void initialScan(KeyManager mgr) {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < allProjects.length; ++i) {
            IProject project = allProjects[i];
            if (!project.isAccessible()) continue;
            this.checkAddTrackedProject(project, mgr);
        }
    }

    private void checkAddTrackedProject(IProject project, KeyManager mgr) {
        if (mgr.projectFilter.satisfies((IResource)project)) {
            IFactKey key = mgr.keyFactory.createKeyForResource((IResource)project);
            this.keepFactUpdated(key);
            this.addTrackedProject(project, mgr);
        }
    }

    private void addTrackedProject(IProject project, KeyManager mgr) {
        Set<KeyManager> interestedMgrs = this.fTrackedProjects.get(project);
        if (interestedMgrs == null) {
            interestedMgrs = new HashSet<KeyManager>();
            this.fTrackedProjects.put(project, interestedMgrs);
        }
        interestedMgrs.add(mgr);
    }

    public void registerDocument(IDocument doc, IResource res, IEditorPart editor) {
        this.fResourceToDocumentMap.put(res, doc);
        this.fDocumentToResourceMap.put(doc, res);
        if (editor instanceof UniversalEditor) {
            UniversalEditor univEditor = (UniversalEditor)editor;
            univEditor.addModelListener(this.fModelListener);
        } else {
            doc.addDocumentListener((IDocumentListener)this.fDocChangeHandler);
        }
    }

    public void unregisterDocument(IDocument doc) {
        IResource res = this.fDocumentToResourceMap.get(doc);
        if (res != null) {
            this.fDocumentToResourceMap.remove(doc);
            this.fResourceToDocumentMap.remove(res);
            this.fDocumentMap.remove(res);
        }
        doc.removeDocumentListener((IDocumentListener)this.fDocChangeHandler);
    }

    public void updateResourceDocumentMap(IDocument doc, IResource res, IEditorPart editor) {
        this.fDocumentToResourceMap.put(doc, res);
        this.fResourceToDocumentMap.put(res, doc);
        if (!(editor instanceof UniversalEditor)) {
            doc.addDocumentListener((IDocumentListener)this.fDocChangeHandler);
        }
    }

    public void removeDocument(IDocument doc) {
        this.fDocumentToResourceMap.remove(doc);
        doc.removeDocumentListener((IDocumentListener)this.fDocChangeHandler);
    }

    public void keepFactUpdated(IFactKey key) {
        Type resultType = key.getType();
        IFactContext context = key.getContext();
        if (!(context instanceof ISourceEntityContext)) {
            throw new IllegalArgumentException("Fact key has non-resource context");
        }
        ISourceEntityContext srcContext = (ISourceEntityContext)context;
        IResource r = srcContext.getEntity().getResource();
        IFactGeneratorFactory genFactory = AnalysisManager.getInstance().findGeneratorFactory(key);
        if (genFactory == null) {
            throw new IllegalArgumentException("No factory registered for fact type: " + resultType);
        }
        IndexerDescriptor indexerDesc = new IndexerDescriptor(key, genFactory.create(resultType));
        if (!FactBase.getInstance().getAllKeys().contains(key)) {
            this.fWorkQueue.push(new WorkItem(indexerDesc, r, 1));
        }
        this.addIndexer(r.getFullPath(), indexerDesc);
    }

    private void addIndexer(IPath path, IndexerDescriptor desc) {
        Set<IndexerDescriptor> indexers = this.fScannerMap.get(path);
        if (indexers == null) {
            indexers = new HashSet<IndexerDescriptor>();
            this.fScannerMap.put(path, indexers);
        }
        indexers.add(desc);
    }

    public void cancelFactUpdating(IFactKey key) {
        IFactContext context = key.getContext();
        if (!(context instanceof ISourceEntityContext)) {
            throw new IllegalArgumentException("Fact key has non-resource context");
        }
        ISourceEntityContext srcContext = (ISourceEntityContext)context;
        IResource r = srcContext.getEntity().getResource();
        this.removeIndexer(r.getFullPath(), key);
    }

    public boolean isAvailable() {
        return !this.hasWork() && !this.isWorking();
    }

    public boolean hasWork() {
        return !this.fWorkQueue.isEmpty();
    }

    public boolean isWorking() {
        return this.fIsWorking;
    }

    private void removeIndexer(IPath path, IFactKey key) {
        Set<IndexerDescriptor> indexers = this.fScannerMap.get(path);
        if (indexers == null) {
            return;
        }
        Iterator<IndexerDescriptor> iter = indexers.iterator();
        while (iter.hasNext()) {
            IndexerDescriptor indexerDesc = iter.next();
            if (!indexerDesc.fKey.equals(key)) continue;
            iter.remove();
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.fIsWorking = true;
        while (!this.fWorkQueue.isEmpty()) {
            WorkItem workItem = this.fWorkQueue.pop();
            try {
                IFactUpdater updater;
                IndexerDescriptor indexer = workItem.fIndexer;
                IResource res = workItem.fResource;
                IFactKey key = indexer.fKey;
                IFactGenerator generator = indexer.fGenerator;
                Map<IResource, IndexedDocumentDescriptor> workingCopySet = Collections.unmodifiableMap(this.fDocumentMap);
                if (workItem.fDocument != null) {
                    if (!(generator instanceof IFactUpdater)) {
                        PDBPlugin.getInstance().writeErrorMsg("Document update received for " + res.getName() + " but the registered fact generator is not an updater.");
                        continue;
                    }
                    updater = (IFactUpdater)((Object)generator);
                    updater.update(this.fFactBase, key.getType(), key.getContext(), res, workingCopySet);
                    continue;
                }
                if (generator instanceof IFactUpdater) {
                    updater = (IFactUpdater)((Object)generator);
                    updater.update(this.fFactBase, key.getType(), key.getContext(), res, workItem.fChangeKind, workingCopySet);
                    continue;
                }
                IValue value = generator.generate(key.getType(), key.getContext(), workingCopySet);
                this.fFactBase.defineFact(key, value);
            }
            catch (AnalysisException e) {
                e.printStackTrace();
            }
        }
        this.fIsWorking = false;
        this.schedule(this.fQueueScanScheduleDelay);
        return new Status(0, "org.eclipse.imp.pdb", "");
    }

    private class WorkItem {
        private final IndexerDescriptor fIndexer;
        private final IResource fResource;
        private final IDocument fDocument;
        private final int fChangeKind;

        public WorkItem(IndexerDescriptor indexer2, IResource r, int changeKind) {
            this.fIndexer = indexer2;
            this.fResource = r;
            this.fDocument = null;
            this.fChangeKind = changeKind;
        }

        public WorkItem(IndexerDescriptor indexer2, IResource r, IDocument doc) {
            this.fIndexer = indexer2;
            this.fResource = r;
            this.fChangeKind = 4;
            this.fDocument = doc;
        }

        public String toString() {
            return "Indexer work item for <" + this.fIndexer + "> for " + (this.fDocument != null ? "document " : "") + "change to resource " + this.fResource.getFullPath().toPortableString();
        }
    }

    private class IndexerDescriptor {
        private IFactKey fKey;
        private IFactGenerator fGenerator;

        public IndexerDescriptor(IFactKey key, IFactGenerator gen) {
            this.fKey = key;
            this.fGenerator = gen;
        }

        public String toString() {
            return "Indexer for key " + this.fKey + " via generator " + this.fGenerator;
        }
    }

    private final class ChangedResourceHandler
    implements IResourceChangeListener {
        private ChangedResourceHandler() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta rootResourceDelta = event.getDelta();
            block6: for (IResourceDelta resourceDelta : rootResourceDelta.getAffectedChildren()) {
                if (resourceDelta.getResource().getType() != 4) continue;
                final IProject project = resourceDelta.getResource().getProject();
                switch (resourceDelta.getKind()) {
                    case 1: {
                        for (KeyManager mgr : Indexer.this.fKeyManagers) {
                            Indexer.this.checkAddTrackedProject(project, mgr);
                        }
                        continue block6;
                    }
                    case 4: {
                        if (Indexer.this.fTrackedProjects.containsKey(project)) {
                            try {
                                resourceDelta.accept(new IResourceDeltaVisitor(){

                                    public boolean visit(IResourceDelta delta) throws CoreException {
                                        Set indexers;
                                        if (delta.getResource().getType() == 1 && (indexers = (Set)Indexer.this.fScannerMap.get(project.getFullPath())) != null) {
                                            int changeKind = delta.getKind();
                                            for (IndexerDescriptor indexer : indexers) {
                                                Indexer.this.fWorkQueue.push(new WorkItem(indexer, delta.getResource(), changeKind));
                                            }
                                        }
                                        return true;
                                    }
                                });
                            }
                            catch (CoreException except) {
                                PDBPlugin.getInstance().getLog().log((IStatus)new MultiStatus("org.eclipse.imp.pdb", 4, new IStatus[]{except.getStatus()}, "Indexing error while visiting resource delta", null));
                            }
                            continue block6;
                        }
                        for (KeyManager mgr : Indexer.this.fKeyManagers) {
                            Indexer.this.checkAddTrackedProject(project, mgr);
                        }
                        continue block6;
                    }
                }
            }
        }
    }

    private class IndexModelListener
    implements IModelListener {
        private IndexModelListener() {
        }

        public IModelListener.AnalysisRequired getAnalysisRequired() {
            return IModelListener.AnalysisRequired.NAME_ANALYSIS;
        }

        private String firstNLinesOf(IDocument doc, int N) {
            try {
                int lastLine = Math.min(N - 1, doc.getNumberOfLines() - 1);
                IRegion lineInfo = doc.getLineInformation(lastLine);
                int endOffset = lineInfo.getOffset() + lineInfo.getLength();
                return doc.get(0, endOffset);
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }

        public void update(IParseController parseController, IProgressMonitor monitor) {
            IDocument doc = parseController.getDocument();
            Object astRoot = parseController.getCurrentAst();
            IResource res = (IResource)Indexer.this.fDocumentToResourceMap.get(doc);
            if (res == null) {
                System.out.println("Indexer received document update for unregistered document: " + doc + " ==> " + this.firstNLinesOf(doc, 1));
                System.out.println("Currently registered documents:");
                for (IDocument d : Indexer.this.fDocumentToResourceMap.keySet()) {
                    System.out.println("  doc " + d + " ==> " + this.firstNLinesOf(doc, 1));
                }
                return;
            }
            IProject project = res.getProject();
            Set indexers = (Set)Indexer.this.fScannerMap.get(project.getFullPath());
            Indexer.this.fDocumentMap.put(res, new IndexedDocumentDescriptor(doc, res, astRoot));
            for (IndexerDescriptor indexer : indexers) {
                Indexer.this.fWorkQueue.push(new WorkItem(indexer, res, doc));
            }
        }
    }

    private class DocumentChangeProcessor
    extends Job {
        public DocumentChangeProcessor() {
            super("IMP Program Database Document Change Processor");
        }

        protected IStatus run(IProgressMonitor monitor) {
            long curTime = System.currentTimeMillis();
            for (IDocument doc : Indexer.this.fDocumentChangeTime.keySet()) {
                if (curTime - (Long)Indexer.this.fDocumentChangeTime.get(doc) < Indexer.this.fDocChangeDelay) continue;
                IResource res = (IResource)Indexer.this.fDocumentToResourceMap.get(doc);
                IProject project = res.getProject();
                Set indexers = (Set)Indexer.this.fScannerMap.get(project.getFullPath());
                for (IndexerDescriptor indexer : indexers) {
                    Indexer.this.fWorkQueue.push(new WorkItem(indexer, res, doc));
                }
                Indexer.this.fDocumentMap.put(res, new IndexedDocumentDescriptor(doc, res, null));
                Indexer.this.fDocumentChangeTime.remove(doc);
            }
            this.schedule(Indexer.this.fDocRescanDelay);
            return Status.OK_STATUS;
        }
    }

    private final class DocumentChangeHandler
    implements IDocumentListener {
        private DocumentChangeHandler() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            IDocument doc = event.fDocument;
            IResource res = (IResource)Indexer.this.fDocumentToResourceMap.get(doc);
            if (res != null) {
                IProject project = res.getProject();
                Set indexers = (Set)Indexer.this.fScannerMap.get(project.getFullPath());
                if (indexers != null) {
                    long curTime = System.currentTimeMillis();
                    Indexer.this.fDocumentChangeTime.put(doc, curTime);
                }
            }
        }
    }

    private static class KeyManager {
        public final IResourcePredicate projectFilter;
        public final IResourceKeyFactory keyFactory;

        public KeyManager(IResourcePredicate projectFilter, IResourceKeyFactory keyFactory) {
            this.projectFilter = projectFilter;
            this.keyFactory = keyFactory;
        }
    }
}

