/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler.codegen;

import org.eclipse.imp.prefspecs.compiler.codegen.FieldCodeGenerator;
import org.eclipse.imp.prefspecs.compiler.model.ColorFieldInfo;
import org.eclipse.imp.prefspecs.compiler.model.PageInfo;

public class ColorFieldCodeGenerator
extends FieldCodeGenerator {
    private final ColorFieldInfo fColorFieldInfo;

    public ColorFieldCodeGenerator(ColorFieldInfo fieldInfo) {
        super(fieldInfo);
        this.fColorFieldInfo = fieldInfo;
    }

    public void genPreferenceInitializer(StringBuilder srcText, String prefKeysClassName) {
        srcText.append("\t\tservice.setStringPreference(IPreferencesService.DEFAULT_LEVEL, " + prefKeysClassName + "." + this.getPreferenceKey() + ", \"" + this.fColorFieldInfo.getDefaultColor() + "\");\n");
    }

    public String getFieldEditorTypeName() {
        return "ColorFieldEditor";
    }

    public void genTextToCreateField(StringBuilder srcText, PageInfo pageInfo, String tabLevel, String parentComposite) {
        boolean editable = !tabLevel.equals("project");
        String label = this.fFieldInfo.getLabel() != null ? this.fFieldInfo.getLabel() : this.createLabelFor(this.fFieldInfo.getName());
        String toolTip = this.fFieldInfo.getToolTipText();
        String result = "\n";
        srcText.append("\t\tColorFieldEditor " + this.fFieldInfo.getName() + " = fPrefUtils.makeNewColorField(\n");
        srcText.append("\t\t\tpage, this, fPrefService,\n");
        srcText.append("\t\t\t\"" + tabLevel + "\", \"" + this.fFieldInfo.getName() + "\", \"" + label + "\",\n");
        srcText.append("\t\t\t\"" + (toolTip != null ? toolTip : "") + "\",\n");
        srcText.append("\t\t\t" + parentComposite + ",\n");
        srcText.append("\t\t\t" + editable + ", " + editable + ",\n");
        srcText.append("\t\t\t" + this.fFieldInfo.getIsRemovable() + ");\n");
        srcText.append("\t\tfields.add(" + this.fFieldInfo.getName() + ");\n\n");
        if (!pageInfo.getNoDetails()) {
            String linkName = this.fFieldInfo.getName() + "DetailsLink";
            result = result + "\t\tLink " + linkName + " = fPrefUtils.createDetailsLink(parent, " + this.fFieldInfo.getName() + ", " + this.fFieldInfo.getName() + ".getChangeControl().getParent()" + ", \"Details ...\");\n\n";
            srcText.append("\t\t" + linkName + ".setEnabled(" + editable + ");\n");
            srcText.append("\t\tfDetailsLinks.add(" + linkName + ");\n\n");
        }
    }
}

