/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.prefspecs.compiler.model;

import org.eclipse.imp.preferences.IPreferencesService;
import org.eclipse.imp.prefspecs.compiler.model.ITabContainer;
import org.eclipse.ui.console.MessageConsoleStream;

public class TabInfo {
    private ITabContainer parent = null;
    private String name = null;
    private boolean isEditable = true;
    private boolean isRemovable = true;
    private boolean isUsed = true;

    public TabInfo(ITabContainer parent, String name) {
        if (name == null) {
            throw new IllegalArgumentException("PreferencesTabInfo(..): name is null; not allowed");
        }
        if (!this.isNameOK(name)) {
            throw new IllegalArgumentException("PreferencesTabInfo.PreferencesTabInfo(..): name = '" + name + "' does not correspond to a legal tab name");
        }
        if (parent.hasTabInfo(name)) {
            throw new IllegalArgumentException("PreferencesTabInfo.PreferencesTabInfo(..): name = '" + name + "' represents a duplicate tab; not allowed");
        }
        this.parent = parent;
        parent.addTabInfo(this);
        this.name = name;
    }

    private boolean isNameOK(String name) {
        String[] levels = IPreferencesService.levels;
        boolean nameOK = false;
        for (int i = 0; i < levels.length; ++i) {
            if (!name.equals(levels[i])) continue;
            nameOK = true;
            break;
        }
        return nameOK;
    }

    public ITabContainer getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public void setIsEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public boolean getIsEditable() {
        return this.isEditable;
    }

    public void setIsRemovable(boolean isRemovable) {
        if (this.getName().equals("default") && isRemovable) {
            throw new IllegalArgumentException("PreferencesTabInfo.setIsRemovable(..):  cannot set isRemovable ");
        }
        this.isRemovable = isRemovable;
    }

    public boolean getIsRemovable() {
        if (this.getName().equals("default")) {
            return false;
        }
        return this.isRemovable;
    }

    public void setIsUsed(boolean isUsed) {
        this.isUsed = isUsed;
    }

    public boolean getIsUsed() {
        return this.isUsed;
    }

    public void dump(String prefix, MessageConsoleStream out) {
        String indent = prefix + "  ";
        out.println(prefix + "Tab '" + this.getName() + "'");
        out.println(indent + "isUsed = " + this.getIsUsed());
        out.println(indent + "isEditable = " + this.getIsEditable());
        out.println(indent + "isRemovable = " + this.getIsRemovable());
        out.println(indent + "Fields:");
    }
}

