/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public abstract class ConstantInstruction
extends Instruction {
    ConstantInstruction(short opcode) {
        super(opcode);
    }

    ConstantPoolReader getLazyConstantPool() {
        return null;
    }

    int getCPIndex() {
        return 0;
    }

    public abstract Object getValue();

    public abstract String getType();

    public static ConstantInstruction make(String type, Object constant) throws IllegalArgumentException {
        if (type == null && constant != null) {
            throw new IllegalArgumentException("(type == null) and (constant != null)");
        }
        if (constant == null) {
            return ConstNull.makeInternal();
        }
        if (type.equals("Ljava/lang/String;")) {
            return ConstantInstruction.makeString((String)constant);
        }
        if (type.equals("Ljava/lang/Class;")) {
            return ConstantInstruction.makeClass((String)constant);
        }
        switch (Util.getTypeIndex(type)) {
            case 0: {
                return ConstantInstruction.make(((Number)constant).intValue());
            }
            case 1: {
                return ConstantInstruction.make(((Number)constant).longValue());
            }
            case 2: {
                return ConstantInstruction.make(((Number)constant).floatValue());
            }
            case 3: {
                return ConstantInstruction.make(((Number)constant).doubleValue());
            }
        }
        throw new IllegalArgumentException("Invalid type for constant: " + type);
    }

    public static ConstantInstruction make(int i) {
        return ConstInt.makeInternal(i);
    }

    public static ConstantInstruction make(long l) {
        return ConstLong.makeInternal(l);
    }

    public static ConstantInstruction make(float f) {
        return ConstFloat.makeInternal(f);
    }

    public static ConstantInstruction make(double d) {
        return ConstDouble.makeInternal(d);
    }

    public static ConstantInstruction makeString(String s) {
        return s == null ? ConstNull.makeInternal() : ConstString.makeInternal(s);
    }

    public static ConstantInstruction makeClass(String s) {
        return ConstClass.makeInternal(s);
    }

    static ConstantInstruction make(ConstantPoolReader cp, int index) {
        switch (cp.getConstantPoolItemType(index)) {
            case 3: {
                return new LazyInt(19, cp, index);
            }
            case 5: {
                return new LazyLong(20, cp, index);
            }
            case 4: {
                return new LazyFloat(19, cp, index);
            }
            case 6: {
                return new LazyDouble(20, cp, index);
            }
            case 8: {
                return new LazyString(19, cp, index);
            }
            case 7: {
                return new LazyClass(19, cp, index);
            }
        }
        return null;
    }

    public final boolean equals(Object o) {
        if (o instanceof ConstantInstruction) {
            ConstantInstruction i = (ConstantInstruction)o;
            return i.getType().equals(this.getType()) && i.getValue().equals(this.getValue());
        }
        return false;
    }

    public final String getPushedType(String[] types) {
        return this.getType();
    }

    public final byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public final int hashCode() {
        return this.getType().hashCode() + 14411 * this.getValue().hashCode();
    }

    public final void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitConstant(this);
    }

    private static String quote(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            StringBuffer buf = new StringBuffer("\"");
            int len = s.length();
            block5: for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        buf.append('\\');
                        buf.append(ch);
                        continue block5;
                    }
                    case '\n': {
                        buf.append("\\\n");
                        continue block5;
                    }
                    case '\t': {
                        buf.append("\\\t");
                        continue block5;
                    }
                    default: {
                        buf.append(ch);
                    }
                }
            }
            buf.append("\"");
            return buf.toString();
        }
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    public final String toString() {
        return "Constant(" + this.getType() + "," + ConstantInstruction.quote(this.getValue()) + ")";
    }

    public boolean isPEI() {
        return false;
    }

    static final class LazyClass
    extends ConstClass {
        private final ConstantPoolReader cp;
        private final int index;

        protected LazyClass(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, null);
            this.cp = cp;
            this.index = index;
        }

        public Object getValue() {
            if (this.typeName == null) {
                this.typeName = this.cp.getConstantPoolClassType(this.index);
            }
            return this.typeName;
        }

        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstClass
    extends ConstantInstruction {
        protected String typeName;

        protected ConstClass(short opcode, String typeName) {
            super(opcode);
            this.typeName = typeName;
        }

        static ConstClass makeInternal(String v) {
            return new ConstClass(19, v);
        }

        public Object getValue() {
            return this.typeName;
        }

        public final String getType() {
            return "Ljava/lang/Class;";
        }
    }

    static final class LazyString
    extends ConstString {
        private final ConstantPoolReader cp;
        private final int index;

        protected LazyString(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, null);
            this.cp = cp;
            this.index = index;
        }

        public Object getValue() {
            if (this.value == null) {
                this.value = this.cp.getConstantPoolString(this.index);
            }
            return this.value;
        }

        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstString
    extends ConstantInstruction {
        protected String value;

        protected ConstString(short opcode, String value) {
            super(opcode);
            this.value = value;
        }

        static ConstString makeInternal(String v) {
            return new ConstString(19, v);
        }

        public Object getValue() {
            return this.value;
        }

        public final String getType() {
            return "Ljava/lang/String;";
        }
    }

    static final class LazyDouble
    extends ConstDouble {
        private final ConstantPoolReader cp;
        private final int index;
        private boolean isSet;

        protected LazyDouble(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, 0.0);
            this.cp = cp;
            this.index = index;
            this.isSet = false;
        }

        public double getDoubleValue() {
            if (!this.isSet) {
                this.value = this.cp.getConstantPoolDouble(this.index);
                this.isSet = true;
            }
            return this.value;
        }

        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstDouble
    extends ConstantInstruction {
        protected double value;
        private static final ConstDouble[] preallocated = ConstDouble.preallocate();

        protected ConstDouble(short opcode, double value) {
            super(opcode);
            this.value = value;
        }

        private static ConstDouble[] preallocate() {
            ConstDouble[] r = new ConstDouble[]{new ConstDouble(14, 0.0), new ConstDouble(15, 1.0)};
            return r;
        }

        static ConstDouble makeInternal(double v) {
            if (v == 0.0 || v == 1.0) {
                return preallocated[(int)v];
            }
            return new ConstDouble(20, v);
        }

        public final Object getValue() {
            return new Double(this.getDoubleValue());
        }

        public final String getType() {
            return "D";
        }

        public double getDoubleValue() {
            return this.value;
        }
    }

    static final class LazyFloat
    extends ConstFloat {
        private final ConstantPoolReader cp;
        private final int index;
        private boolean isSet;

        protected LazyFloat(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, 0.0f);
            this.cp = cp;
            this.index = index;
            this.isSet = false;
        }

        public float getFloatValue() {
            if (!this.isSet) {
                this.value = this.cp.getConstantPoolFloat(this.index);
                this.isSet = true;
            }
            return this.value;
        }

        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstFloat
    extends ConstantInstruction {
        protected float value;
        private static final ConstFloat[] preallocated = ConstFloat.preallocate();

        protected ConstFloat(short opcode, float value) {
            super(opcode);
            this.value = value;
        }

        private static ConstFloat[] preallocate() {
            ConstFloat[] r = new ConstFloat[]{new ConstFloat(11, 0.0f), new ConstFloat(12, 1.0f), new ConstFloat(13, 2.0f)};
            return r;
        }

        static ConstFloat makeInternal(float v) {
            if ((double)v == 0.0 || (double)v == 1.0 || (double)v == 2.0) {
                return preallocated[(int)v];
            }
            return new ConstFloat(19, v);
        }

        public final Object getValue() {
            return new Float(this.getFloatValue());
        }

        public final String getType() {
            return "F";
        }

        public float getFloatValue() {
            return this.value;
        }
    }

    static final class LazyLong
    extends ConstLong {
        private final ConstantPoolReader cp;
        private final int index;
        private boolean isSet;

        protected LazyLong(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, 0L);
            this.cp = cp;
            this.index = index;
            this.isSet = false;
        }

        public long getLongValue() {
            if (!this.isSet) {
                this.value = this.cp.getConstantPoolLong(this.index);
                this.isSet = true;
            }
            return this.value;
        }

        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstLong
    extends ConstantInstruction {
        protected long value;
        private static final ConstLong[] preallocated = ConstLong.preallocate();

        protected ConstLong(short opcode, long value) {
            super(opcode);
            this.value = value;
        }

        private static ConstLong[] preallocate() {
            ConstLong[] r = new ConstLong[]{new ConstLong(9, 0L), new ConstLong(10, 1L)};
            return r;
        }

        static ConstLong makeInternal(long v) {
            if (v == 0L || v == 1L) {
                return preallocated[(int)v];
            }
            return new ConstLong(20, v);
        }

        public final Object getValue() {
            return this.getLongValue();
        }

        public final String getType() {
            return "J";
        }

        public long getLongValue() {
            return this.value;
        }
    }

    static final class LazyInt
    extends ConstInt {
        private final ConstantPoolReader cp;
        private final int index;
        private boolean isSet;

        protected LazyInt(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, 0);
            this.cp = cp;
            this.index = index;
            this.isSet = false;
        }

        public int getIntValue() {
            if (!this.isSet) {
                this.value = this.cp.getConstantPoolInteger(this.index);
                this.isSet = true;
            }
            return this.value;
        }

        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        public int getCPIndex() {
            return this.index;
        }
    }

    static class ConstInt
    extends ConstantInstruction {
        protected int value;
        private static final ConstInt[] preallocated = ConstInt.preallocate();

        protected ConstInt(short opcode, int value) {
            super(opcode);
            this.value = value;
        }

        private static ConstInt[] preallocate() {
            int i;
            ConstInt[] r = new ConstInt[256];
            for (i = 0; i < r.length; ++i) {
                r[i] = new ConstInt(16, i - 128);
            }
            for (i = -1; i <= 5; ++i) {
                r[i + 128] = new ConstInt((short)(i - -1 + 2), i);
            }
            return r;
        }

        static ConstInt makeInternal(int i) {
            if ((byte)i == i) {
                return preallocated[i + 128];
            }
            if ((short)i == i) {
                return new ConstInt(17, i);
            }
            return new ConstInt(19, i);
        }

        public final Object getValue() {
            return this.getIntValue();
        }

        public final String getType() {
            return "I";
        }

        public int getIntValue() {
            return this.value;
        }
    }

    static final class ConstNull
    extends ConstantInstruction {
        private static final ConstNull preallocated = new ConstNull();

        protected ConstNull() {
            super((short)1);
        }

        static ConstNull makeInternal() {
            return preallocated;
        }

        public Object getValue() {
            return null;
        }

        public String getType() {
            return "L;";
        }
    }
}

