/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class UnaryOpInstruction
extends Instruction
implements IUnaryOpInstruction {
    private static final UnaryOpInstruction[] preallocated = UnaryOpInstruction.preallocate();

    protected UnaryOpInstruction(short opcode) {
        super(opcode);
    }

    private static UnaryOpInstruction[] preallocate() {
        UnaryOpInstruction[] r = new UnaryOpInstruction[4];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new UnaryOpInstruction((short)(116 + i));
        }
        return r;
    }

    public static UnaryOpInstruction make(String type, IUnaryOpInstruction.Operator operator) throws IllegalArgumentException {
        int t = Util.getTypeIndex(type);
        if (t < 0 || t > 3) {
            throw new IllegalArgumentException("Type " + type + " cannot have a unary operator applied");
        }
        return preallocated[t];
    }

    public boolean equals(Object o) {
        if (o instanceof UnaryOpInstruction) {
            UnaryOpInstruction i = (UnaryOpInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    public IUnaryOpInstruction.Operator getOperator() {
        return IUnaryOpInstruction.Operator.NEG;
    }

    public int hashCode() {
        return this.opcode;
    }

    public int getPoppedCount() {
        return 1;
    }

    public String getPushedType(String[] types) {
        return this.getType();
    }

    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public String getType() {
        return indexedTypes[this.opcode - 116];
    }

    public void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitUnaryOp(this);
    }

    public String toString() {
        return "UnaryOp(" + this.getType() + "," + this.getOperator() + ")";
    }

    public boolean isPEI() {
        return false;
    }
}

