/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.BinaryOpInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ShiftInstruction
extends Instruction {
    private static final ShiftInstruction[] preallocated = ShiftInstruction.preallocate();

    protected ShiftInstruction(short opcode) {
        super(opcode);
    }

    private static ShiftInstruction[] preallocate() {
        ShiftInstruction[] r = new ShiftInstruction[6];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new ShiftInstruction((short)(i + 120));
        }
        return r;
    }

    public static ShiftInstruction make(String type, Operator operator) throws IllegalArgumentException {
        if (operator == null) {
            throw new IllegalArgumentException("operator is null");
        }
        int t = Util.getTypeIndex(type);
        if (t < 0 || t > 1) {
            throw new IllegalArgumentException("Cannot apply shift to type " + type);
        }
        return preallocated[(operator.ordinal() - Operator.SHL.ordinal()) * 2 + t];
    }

    public boolean equals(Object o) {
        if (o instanceof ShiftInstruction) {
            ShiftInstruction i = (ShiftInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    public Operator getOperator() {
        return Operator.values()[(this.opcode - 120) / 2];
    }

    public int hashCode() {
        return this.opcode;
    }

    public int getPoppedCount() {
        return 2;
    }

    public String getPushedType(String[] types) {
        return this.getType();
    }

    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public String getType() {
        return indexedTypes[this.opcode - 120 & 1];
    }

    public void visit(Instruction.Visitor v) throws NullPointerException {
        v.visitShift(this);
    }

    public String toString() {
        return "Shift(" + this.getType() + "," + this.getOperator() + ")";
    }

    public boolean isPEI() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator implements BinaryOpInstruction.IOperator
    {
        SHL,
        SHR,
        USHR;

    }
}

