/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.bench;

import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;

public class Statistics {
    private static OfflineInstrumenter instrumenter;

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 1; ++i) {
            ClassInstrumenter ci;
            instrumenter = new OfflineInstrumenter();
            BufferedWriter w = new BufferedWriter(new FileWriter("report", false));
            args = instrumenter.parseStandardArgs(args);
            instrumenter.beginTraversal();
            while ((ci = instrumenter.nextClass()) != null) {
                Statistics.doClass(ci, w);
            }
            instrumenter.close();
            ((Writer)w).close();
        }
    }

    private static void doClass(ClassInstrumenter ci, Writer w) throws Exception {
        ClassReader cr = ci.getReader();
        String className = cr.getName();
        w.write("Class: " + className + "\n");
        boolean allPrivateConstructors = true;
        boolean methodCallsConstructor = false;
        boolean classInitCallsConstructor = false;
        for (int m = 0; m < cr.getMethodCount(); ++m) {
            int f;
            MethodData d = ci.visitMethod(m);
            if (d == null) continue;
            if (d.getName().equals("<init>") && ((f = cr.getMethodAccessFlags(m)) & 2) == 0 && ((f & 4) == 0 || (cr.getAccessFlags() & 0x10) == 0)) {
                allPrivateConstructors = false;
            }
            int constructorCalls = 0;
            Instruction[] instrs = d.getInstructions();
            for (int i = 0; i < instrs.length; ++i) {
                InvokeInstruction invoke;
                if (!(instrs[i] instanceof InvokeInstruction) || !(invoke = (InvokeInstruction)instrs[i]).getMethodName().equals("<init>") || !invoke.getClassType().equals(Util.makeType(className))) continue;
                ++constructorCalls;
            }
            if (!d.getName().equals("<init>") && !d.getName().equals("<clinit>")) {
                if (constructorCalls <= 0) continue;
                methodCallsConstructor = true;
                continue;
            }
            if (!d.getName().equals("<clinit>")) continue;
            classInitCallsConstructor = true;
        }
        if (allPrivateConstructors && !methodCallsConstructor && classInitCallsConstructor) {
            w.write("Restricted Creation\n");
        }
    }
}

