/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT;

import com.ibm.wala.shrikeBT.Compiler;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeCT.ClassWriter;
import java.util.Random;

public final class CTCompiler
extends Compiler {
    private final ClassWriter cw;

    private CTCompiler(ClassWriter cw, MethodData md) {
        super(md);
        this.cw = cw;
    }

    protected int allocateConstantPoolInteger(int v) {
        return this.cw.addCPInt(v);
    }

    protected int allocateConstantPoolFloat(float v) {
        return this.cw.addCPFloat(v);
    }

    protected int allocateConstantPoolLong(long v) {
        return this.cw.addCPLong(v);
    }

    protected int allocateConstantPoolDouble(double v) {
        return this.cw.addCPDouble(v);
    }

    protected int allocateConstantPoolString(String v) {
        return this.cw.addCPString(v);
    }

    protected int allocateConstantPoolClassType(String c) {
        return this.cw.addCPClass(CTCompiler.convertTypeToClass(c));
    }

    public static String convertTypeToClass(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (s.length() > 0 && s.charAt(0) == 'L') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static CTCompiler make(ClassWriter cw, MethodData md) {
        if (md == null) {
            throw new IllegalArgumentException("md is null");
        }
        return new CTCompiler(cw, md);
    }

    protected int allocateConstantPoolField(String c, String name, String type) {
        return this.cw.addCPFieldRef(CTCompiler.convertTypeToClass(c), name, type);
    }

    protected int allocateConstantPoolMethod(String c, String name, String sig) {
        return this.cw.addCPMethodRef(CTCompiler.convertTypeToClass(c), name, sig);
    }

    protected int allocateConstantPoolInterfaceMethod(String c, String name, String sig) {
        return this.cw.addCPInterfaceMethodRef(CTCompiler.convertTypeToClass(c), name, sig);
    }

    protected String createHelperMethod(boolean isStatic, String sig) {
        long r = Math.abs(new Random().nextLong());
        String name = "_helper_" + r;
        return name;
    }
}

