/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;

public final class InnerClassesWriter
extends ClassWriter.Element {
    private final int attrID;
    private int[] table;

    public InnerClassesWriter(ClassWriter w) {
        if (w == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = w.addCPUtf8("InnerClasses");
    }

    public int getSize() {
        return this.table == null ? 8 : 8 + this.table.length * 2;
    }

    public int copyInto(byte[] buf, int offset) throws IllegalArgumentException {
        ClassWriter.setUShort(buf, offset, this.attrID);
        ClassWriter.setInt(buf, offset + 2, this.getSize() - 6);
        ClassWriter.setUShort(buf, offset + 6, this.table == null ? 0 : this.table.length);
        offset += 8;
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                ClassWriter.setUShort(buf, offset, this.table[i]);
                offset += 2;
            }
        }
        return offset;
    }

    public void setRawTable(int[] classes) throws NullPointerException {
        if (classes == null) {
            throw new IllegalArgumentException("classes is null");
        }
        if (classes.length % 4 != 0) {
            throw new IllegalArgumentException("Invalid raw table length: " + classes.length);
        }
        for (int i = 0; i < classes.length; i += 4) {
            if (classes[i] < 1 || classes[i] > 65535) {
                throw new IllegalArgumentException("Invalid CP index: " + classes[i]);
            }
            if (classes[i + 1] < 0 || classes[i + 1] > 65535) {
                throw new IllegalArgumentException("Invalid CP index: " + classes[i]);
            }
            if (classes[i + 2] >= 0 && classes[i + 2] <= 65535) continue;
            throw new IllegalArgumentException("Invalid CP index: " + classes[i]);
        }
        this.table = classes;
    }
}

