/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class UnaryOpInstruction
extends Instruction {
    private static final UnaryOpInstruction[] preallocated = UnaryOpInstruction.preallocate();

    protected UnaryOpInstruction(short opcode) {
        super(opcode);
    }

    private static UnaryOpInstruction[] preallocate() {
        UnaryOpInstruction[] r = new UnaryOpInstruction[4];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new UnaryOpInstruction((short)(116 + i));
        }
        return r;
    }

    public static UnaryOpInstruction make(String type, Operator operator) throws IllegalArgumentException {
        int t = Util.getTypeIndex(type);
        if (t < 0 || t > 3) {
            throw new IllegalArgumentException("Type " + type + " cannot have a unary operator applied");
        }
        return preallocated[t];
    }

    public boolean equals(Object o) {
        if (o instanceof UnaryOpInstruction) {
            UnaryOpInstruction i = (UnaryOpInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    public Operator getOperator() {
        return Operator.NEG;
    }

    public int hashCode() {
        return this.opcode;
    }

    public int getPoppedCount() {
        return 1;
    }

    public String getPushedType(String[] types) {
        return this.getType();
    }

    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public String getType() {
        return indexedTypes[this.opcode - 116];
    }

    public void visit(Instruction.Visitor v) throws NullPointerException {
        v.visitUnaryOp(this);
    }

    public String toString() {
        return "UnaryOp(" + this.getType() + "," + this.getOperator() + ")";
    }

    public boolean isPEI() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator implements IOperator
    {
        NEG;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static interface IOperator {
    }
}

