/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ComparisonInstruction
extends Instruction {
    private static final ComparisonInstruction preallocatedLCMP = new ComparisonInstruction(148);
    private static final ComparisonInstruction[] preallocatedFloatingCompares = ComparisonInstruction.preallocateFloatingCompares();

    protected ComparisonInstruction(short opcode) {
        super(opcode);
    }

    private static ComparisonInstruction[] preallocateFloatingCompares() {
        ComparisonInstruction[] r = new ComparisonInstruction[4];
        for (short i = 149; i <= 152; i = (short)(i + 1)) {
            r[i - 149] = new ComparisonInstruction(i);
        }
        return r;
    }

    public static ComparisonInstruction make(String type, Operator operator) throws IllegalArgumentException {
        int t = Util.getTypeIndex(type);
        switch (t) {
            case 1: {
                if (operator != Operator.CMP) {
                    throw new IllegalArgumentException("Operator " + (Object)((Object)operator) + " is not a valid comparison operator for longs");
                }
                return preallocatedLCMP;
            }
            case 2: 
            case 3: {
                if (operator == Operator.CMP) {
                    throw new IllegalArgumentException("Operator " + (Object)((Object)operator) + " is not a valid comparison operator for floating point values");
                }
                return preallocatedFloatingCompares[operator.ordinal() - Operator.CMPL.ordinal() + (t - 2) * 2];
            }
        }
        throw new IllegalArgumentException("Type " + type + " cannot be compared");
    }

    public boolean equals(Object o) {
        if (o instanceof ComparisonInstruction) {
            ComparisonInstruction i = (ComparisonInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    public Operator getOperator() {
        switch (this.opcode) {
            case 148: {
                return Operator.CMP;
            }
            case 149: 
            case 151: {
                return Operator.CMPL;
            }
            case 150: 
            case 152: {
                return Operator.CMPG;
            }
        }
        throw new Error("Unknown opcode");
    }

    public String getType() {
        switch (this.opcode) {
            case 148: {
                return "J";
            }
            case 149: 
            case 150: {
                return "F";
            }
            case 151: 
            case 152: {
                return "D";
            }
        }
        throw new Error("Unknown opcode");
    }

    public int hashCode() {
        return this.opcode + 1391901;
    }

    public int getPoppedCount() {
        return 2;
    }

    public String getPushedType(String[] types) {
        return "Z";
    }

    public byte getPushedWordSize() {
        return 1;
    }

    public void visit(Instruction.Visitor v) throws NullPointerException {
        v.visitComparison(this);
    }

    public String toString() {
        return "Comparison(" + this.getType() + "," + (Object)((Object)this.getOperator()) + ")";
    }

    public boolean isPEI() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        CMP,
        CMPL,
        CMPG;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

