/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.constraints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.imp.analysis.constraints.IConstraint;
import org.eclipse.imp.analysis.constraints.IConstraintFactory;
import org.eclipse.imp.analysis.constraints.IConstraintOperator;
import org.eclipse.imp.analysis.constraints.IConstraintVariable;
import org.eclipse.imp.analysis.constraints.OrConstraint;
import org.eclipse.imp.analysis.constraints.SimpleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintFactory
implements IConstraintFactory {
    private Map<IConstraintVariable, Map<IConstraintVariable, Map<IConstraintOperator, IConstraint>>> fSimpleConstraints = new HashMap<IConstraintVariable, Map<IConstraintVariable, Map<IConstraintOperator, IConstraint>>>();
    private Map<IConstraintVariable, Map<String, OrConstraint>> fOrConstraints = new HashMap<IConstraintVariable, Map<String, OrConstraint>>();
    protected static final boolean PRINT_STATS = false;
    protected int fNrCreated = 0;
    protected int fNrFiltered = 0;
    protected int fNrRetrieved = 0;

    private SimpleConstraint doCreateSimpleConstraint(IConstraintVariable v1, IConstraintVariable v2, IConstraintOperator operator) {
        if (this.fSimpleConstraints.containsKey(v1)) {
            Map<IConstraintVariable, Map<IConstraintOperator, IConstraint>> m2 = this.fSimpleConstraints.get(v1);
            if (m2.containsKey(v2)) {
                Map<IConstraintOperator, IConstraint> m3 = m2.get(v2);
                if (m3.containsKey(operator)) {
                    return (SimpleConstraint)m3.get(operator);
                }
                return this.storeConstraint(v1, v2, operator, m3);
            }
            HashMap<IConstraintOperator, IConstraint> m3 = new HashMap<IConstraintOperator, IConstraint>();
            m2.put(v2, m3);
            return this.storeConstraint(v1, v2, operator, m3);
        }
        HashMap<IConstraintVariable, HashMap<IConstraintOperator, IConstraint>> m2 = new HashMap<IConstraintVariable, HashMap<IConstraintOperator, IConstraint>>();
        this.fSimpleConstraints.put(v1, m2);
        HashMap<IConstraintOperator, IConstraint> m3 = new HashMap<IConstraintOperator, IConstraint>();
        m2.put(v2, m3);
        return this.storeConstraint(v1, v2, operator, m3);
    }

    private SimpleConstraint storeConstraint(IConstraintVariable v1, IConstraintVariable v2, IConstraintOperator operator, Map<IConstraintOperator, IConstraint> m3) {
        SimpleConstraint constraint = new SimpleConstraint(v1, v2, operator);
        m3.put(operator, constraint);
        return constraint;
    }

    public IConstraint[] createSimpleConstraint(IConstraintVariable v1, IConstraintVariable v2, IConstraintOperator operator) {
        if (this.filterSimple(v1, v2, operator)) {
            return new IConstraint[0];
        }
        return new IConstraint[]{this.doCreateSimpleConstraint(v1, v2, operator)};
    }

    public boolean filterSimple(IConstraintVariable v1, IConstraintVariable v2, IConstraintOperator operator) {
        return v1 == v2;
    }

    public OrConstraint createOrConstraint(IConstraint[] constraints) {
        OrConstraint constraint;
        IConstraintVariable left = ((SimpleConstraint)constraints[0]).getLeft();
        String signature = "";
        for (int i = 0; i < constraints.length; ++i) {
            IConstraintVariable right = ((SimpleConstraint)constraints[i]).getRight();
            String varName = right.toString();
            signature = signature + varName + ",";
        }
        if (this.fOrConstraints.containsKey(left)) {
            Map<String, OrConstraint> m2 = this.fOrConstraints.get(left);
            if (m2.containsKey(signature)) {
                return m2.get(signature);
            }
            constraint = new OrConstraint(constraints);
            m2.put(signature, constraint);
            return constraint;
        }
        HashMap<String, OrConstraint> m2 = new HashMap<String, OrConstraint>();
        this.fOrConstraints.put(left, m2);
        constraint = new OrConstraint(constraints);
        m2.put(signature, constraint);
        return constraint;
    }

    protected void dumpStats() {
        System.out.println("Constraints: " + this.fNrCreated + " created, " + this.fNrRetrieved + " retrieved, " + this.fNrFiltered + " filtered");
    }
}

