/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.imp.analysis.constraints.IConstraintOperator;
import org.eclipse.imp.core.Assert;

public class TypeConstraintOperator
implements IConstraintOperator {
    private final String fOperatorString;
    private final int fOperatorCode;
    private static final int CODE_SUBTYPE = 0;
    private static final int CODE_EQUALS = 1;
    private static final int CODE_DEFINES = 2;
    private static final int CODE_STRICT_SUBTYPE = 3;
    private static final String STRING_SUBTYPE = "<=";
    private static final String STRING_EQUALS = "==";
    private static final String STRING_DEFINES = "=^=";
    private static final String STRING_STRICT_SUBTYPE = "<";
    private static final Collection fgOperatorStrings = new HashSet<String>(Arrays.asList("<=", "==", "=^=", "<"));
    private static final TypeConstraintOperator fgSubtype = new TypeConstraintOperator("<=", 0);
    private static final TypeConstraintOperator fgEquals = new TypeConstraintOperator("==", 1);
    private static final TypeConstraintOperator fgDefines = new TypeConstraintOperator("=^=", 2);
    private static final TypeConstraintOperator fgStrictSubtype = new TypeConstraintOperator("<", 3);

    public static TypeConstraintOperator createSubTypeOperator() {
        return fgSubtype;
    }

    public static TypeConstraintOperator createEqualsOperator() {
        return fgEquals;
    }

    public static TypeConstraintOperator createDefinesOperator() {
        return fgDefines;
    }

    public static TypeConstraintOperator createStrictSubtypeOperator() {
        return fgStrictSubtype;
    }

    private TypeConstraintOperator(String string, int code) {
        Assert.isTrue((boolean)fgOperatorStrings.contains(string));
        Assert.isTrue((code == 2 || code == 1 || code == 3 || code == 0 ? 1 : 0) != 0);
        this.fOperatorString = string;
        this.fOperatorCode = code;
    }

    public String getOperatorString() {
        return this.fOperatorString;
    }

    public String toString() {
        return this.getOperatorString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeConstraintOperator)) {
            return false;
        }
        TypeConstraintOperator other = (TypeConstraintOperator)obj;
        return this.fOperatorCode == other.fOperatorCode;
    }

    public int hashCode() {
        return this.fOperatorString.hashCode();
    }

    public final boolean isSubtypeOperator() {
        return this.fOperatorCode == 0;
    }

    public final boolean isStrictSubtypeOperator() {
        return this.fOperatorCode == 3;
    }

    public final boolean isEqualsOperator() {
        return this.fOperatorCode == 1;
    }

    public final boolean isDefinesOperator() {
        return this.fOperatorCode == 2;
    }
}

