/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints.fastrep;

import org.eclipse.imp.analysis.type.constraints.fastrep.TType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TypeEnvironment;

public class PrimitiveType
extends TType {
    public static final int INT = 0;
    public static final int CHAR = 1;
    public static final int BOOLEAN = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int FLOAT = 5;
    public static final int DOUBLE = 6;
    public static final int BYTE = 7;
    static final String[] NAMES = new String[]{"int", "char", "boolean", "short", "long", "float", "double", "byte"};
    private int fId;

    protected PrimitiveType(TypeEnvironment environment, int id, String signature) {
        super(environment, signature);
        this.fId = id;
    }

    public int getId() {
        return this.fId;
    }

    public int getKind() {
        return 3;
    }

    protected boolean doEquals(TType type) {
        return this.fId == ((PrimitiveType)type).fId;
    }

    protected boolean doCanAssignTo(TType lhs) {
        if (lhs.getKind() != 3) {
            if (lhs.getKind() == 5) {
                throw new IllegalArgumentException("Unimplemented: PrimitiveType.doCanAssignTo()");
            }
            return false;
        }
        switch (((PrimitiveType)lhs).fId) {
            case 1: 
            case 2: 
            case 7: {
                return false;
            }
            case 6: {
                switch (this.fId) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                switch (this.fId) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                switch (this.fId) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                switch (this.fId) {
                    case 1: 
                    case 3: 
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                return this.fId == 7;
            }
        }
        return false;
    }

    public String getName() {
        return NAMES[this.fId];
    }

    protected String getPlainPrettySignature() {
        return NAMES[this.fId];
    }
}

