/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints.variables;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.imp.analysis.ICompilationUnitRange;
import org.eclipse.imp.analysis.PolyglotUtils;
import org.eclipse.imp.analysis.constraints.IConstraintTerm;
import org.eclipse.imp.analysis.type.constraints.ITypeVariableFactory;
import org.eclipse.imp.analysis.type.constraints.bindings.BindingKeyFactory;
import org.eclipse.imp.analysis.type.constraints.fastrep.TType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TypeEnvironment;
import org.eclipse.imp.analysis.type.constraints.variables.ArrayElementVariable;
import org.eclipse.imp.analysis.type.constraints.variables.DeclaringTypeVariable;
import org.eclipse.imp.analysis.type.constraints.variables.ExpressionVariable;
import org.eclipse.imp.analysis.type.constraints.variables.ITypeConstraintVariable;
import org.eclipse.imp.analysis.type.constraints.variables.ImmutableTypeVariable;
import org.eclipse.imp.analysis.type.constraints.variables.MethodParameterTypeVariable;
import org.eclipse.imp.analysis.type.constraints.variables.ReturnTypeVariable;
import org.eclipse.imp.analysis.type.constraints.variables.TypeConstraintVariable;
import org.eclipse.imp.analysis.type.constraints.variables.TypeParameterVariable;
import org.eclipse.imp.core.Assert;
import org.eclipse.imp.model.ICompilationUnit;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Lit;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Type;
import polyglot.types.VarInstance;

public class TypeVariableFactory
implements ITypeVariableFactory {
    private final TypeEnvironment fTypeEnv = new TypeEnvironment();
    private final BindingKeyFactory fKeyFactory;
    private ICompilationUnit fCU;
    private final Map<Object, ITypeConstraintVariable> fExpressionMap = new HashMap<Object, ITypeConstraintVariable>();
    private final Map<ICompilationUnitRange, TypeParameterVariable> fTypeVariableMap = new HashMap<ICompilationUnitRange, TypeParameterVariable>();
    private final Map<BindingKeyFactory.BindingKey, DeclaringTypeVariable> fDeclaringTypeVariableMap = new HashMap<BindingKeyFactory.BindingKey, DeclaringTypeVariable>();
    private final Map<BindingKeyFactory.BindingKey, MethodParameterTypeVariable> fParameterMap = new HashMap<BindingKeyFactory.BindingKey, MethodParameterTypeVariable>();
    private final Map<BindingKeyFactory.BindingKey, ImmutableTypeVariable> fRawBindingMap = new HashMap<BindingKeyFactory.BindingKey, ImmutableTypeVariable>();
    private final Map<BindingKeyFactory.BindingKey, ReturnTypeVariable> fReturnVariableMap = new HashMap<BindingKeyFactory.BindingKey, ReturnTypeVariable>();
    private final Map<IConstraintTerm, IConstraintTerm> fArrayElementMap = new HashMap<IConstraintTerm, IConstraintTerm>();
    protected int nrCreated = 0;
    protected int nrRetrieved = 0;
    public static final boolean REPORT = false;

    public TypeVariableFactory(BindingKeyFactory keyFactory) {
        this.fKeyFactory = keyFactory;
    }

    public int getNumCreated() {
        return this.nrCreated;
    }

    protected void dumpConstraintStats() {
        System.out.println("Constraint variables created: " + this.nrCreated + ", retrieved: " + this.nrRetrieved);
    }

    public void setCompilationUnit(ICompilationUnit unit) {
        this.fCU = unit;
    }

    public ITypeConstraintVariable makeVariableForExpression(Expr expr) {
        if (expr instanceof Lit) {
            return this.makeImmutableTypeVariable(expr.type());
        }
        BindingKeyFactory.BindingKey bindingKey = this.resolveExprBinding(expr);
        Object mapKey = bindingKey != null ? bindingKey : PolyglotUtils.unitRangeForNode((Node)expr, this.fCU);
        ExpressionVariable ev = (ExpressionVariable)this.fExpressionMap.get(mapKey);
        if (ev == null) {
            Type type = expr.type();
            ev = new ExpressionVariable(expr, this.fTypeEnv.createForType(type), PolyglotUtils.unitRangeForNode((Node)expr, this.fCU));
            this.fExpressionMap.put(mapKey, ev);
        }
        return ev;
    }

    private BindingKeyFactory.BindingKey resolveExprBinding(Expr expr) {
        if (expr instanceof Local) {
            Local local = (Local)expr;
            return this.fKeyFactory.getKeyForVariable(local);
        }
        if (expr instanceof Field) {
            Field field = (Field)expr;
            return this.fKeyFactory.getKeyForVariable(field);
        }
        return null;
    }

    public ITypeConstraintVariable makeVariableForDeclaration(VarInstance varDecl) {
        BindingKeyFactory.BindingKey bindingKey = this.fKeyFactory.getKeyForVariable(varDecl);
        Assert.isNotNull((Object)bindingKey);
        TypeConstraintVariable ev = (ExpressionVariable)this.fExpressionMap.get(bindingKey);
        if (ev == null) {
            Type type = varDecl.type();
            ev = new TypeConstraintVariable(bindingKey, this.fTypeEnv.createForType(type), PolyglotUtils.unitRangeForPosition(varDecl.position(), this.fCU));
            this.fExpressionMap.put(bindingKey, ev);
        }
        return ev;
    }

    public ArrayElementVariable makeArrayElementVariable(ITypeConstraintVariable arrayVar, ICompilationUnitRange range) {
        if (!this.fArrayElementMap.containsKey(arrayVar)) {
            this.fArrayElementMap.put(arrayVar, new ArrayElementVariable(arrayVar, range));
        }
        return (ArrayElementVariable)this.fArrayElementMap.get(arrayVar);
    }

    public DeclaringTypeVariable makeDeclaringTypeVariable(Type memberType) {
        BindingKeyFactory.BindingKey typeKey = this.fKeyFactory.getKeyForType(memberType);
        if (!this.fDeclaringTypeVariableMap.containsKey(typeKey)) {
            ClassType memberClass = (ClassType)memberType;
            TType declType = this.fTypeEnv.createForType((Type)memberClass.container());
            ICompilationUnitRange range = PolyglotUtils.unitRangeForPosition(memberType.position(), this.fCU);
            this.fDeclaringTypeVariableMap.put(typeKey, new DeclaringTypeVariable(typeKey, declType, range, this.fKeyFactory));
        }
        return this.fDeclaringTypeVariableMap.get(typeKey);
    }

    public DeclaringTypeVariable makeDeclaringTypeVariable(FieldInstance field) {
        BindingKeyFactory.BindingKey fieldKey = this.fKeyFactory.getKeyForVariable(field);
        if (!this.fDeclaringTypeVariableMap.containsKey(fieldKey)) {
            TType declType = this.fTypeEnv.createForType(field.type());
            this.fDeclaringTypeVariableMap.put(fieldKey, new DeclaringTypeVariable(fieldKey, declType, PolyglotUtils.unitRangeForPosition(field.position(), this.fCU), this.fKeyFactory));
        }
        return this.fDeclaringTypeVariableMap.get(fieldKey);
    }

    public DeclaringTypeVariable makeDeclaringTypeVariable(MethodInstance method) {
        BindingKeyFactory.BindingKey methodKey = this.fKeyFactory.getKeyForMethod(method);
        if (!this.fDeclaringTypeVariableMap.containsKey(methodKey)) {
            this.fDeclaringTypeVariableMap.put(methodKey, new DeclaringTypeVariable(methodKey, null, PolyglotUtils.unitRangeForPosition(method.position(), this.fCU), this.fKeyFactory));
        }
        return this.fDeclaringTypeVariableMap.get(methodKey);
    }

    public MethodParameterTypeVariable makeParameterTypeVariable(MethodInstance methodInstance, int parameterIndex, ICompilationUnitRange range) {
        BindingKeyFactory.BindingKey methodKey = this.fKeyFactory.getKeyForMethod(methodInstance);
        BindingKeyFactory.BindingKey paramKey = this.fKeyFactory.getKeyForMethodArgument(methodKey, parameterIndex);
        if (!this.fParameterMap.containsKey(paramKey)) {
            TType declType = this.fTypeEnv.createForType((Type)methodInstance.formalTypes().get(parameterIndex));
            this.fParameterMap.put(methodKey, new MethodParameterTypeVariable(methodKey, parameterIndex, declType, range, this.fKeyFactory));
        }
        return this.fParameterMap.get(methodKey);
    }

    public ImmutableTypeVariable makeImmutableTypeVariable(Type type) {
        Assert.isNotNull((Object)type);
        BindingKeyFactory.BindingKey typeKey = this.fKeyFactory.getKeyForType(type);
        if (!this.fRawBindingMap.containsKey(typeKey)) {
            TType fastType = this.fTypeEnv.createForType(type);
            this.fRawBindingMap.put(typeKey, new ImmutableTypeVariable(typeKey, fastType));
        }
        return this.fRawBindingMap.get(typeKey);
    }

    public ReturnTypeVariable makeReturnTypeVariable(MethodInstance method) {
        BindingKeyFactory.BindingKey methodKey = this.fKeyFactory.getKeyForMethod(method);
        if (!this.fReturnVariableMap.containsKey(methodKey)) {
            ICompilationUnitRange range = PolyglotUtils.unitRangeForPosition(method.position(), this.fCU);
            TType declaredReturnType = this.fTypeEnv.createForType(method.returnType());
            this.fReturnVariableMap.put(methodKey, new ReturnTypeVariable(methodKey, declaredReturnType, range, this.fKeyFactory));
        }
        return this.fReturnVariableMap.get(methodKey);
    }
}

