/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.constraints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.imp.analysis.constraints.IConstraint;
import org.eclipse.imp.analysis.constraints.IConstraintFactory;
import org.eclipse.imp.analysis.constraints.IConstraintOperator;
import org.eclipse.imp.analysis.constraints.IConstraintTerm;
import org.eclipse.imp.analysis.constraints.ISimpleConstraint;
import org.eclipse.imp.analysis.constraints.OrConstraint;
import org.eclipse.imp.analysis.constraints.SimpleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintFactory
implements IConstraintFactory {
    private Map<IConstraintTerm, Map<IConstraintTerm, Map<IConstraintOperator, IConstraint>>> fSimpleConstraints = new HashMap<IConstraintTerm, Map<IConstraintTerm, Map<IConstraintOperator, IConstraint>>>();
    private Map<IConstraintTerm, Map<String, OrConstraint>> fOrConstraints = new HashMap<IConstraintTerm, Map<String, OrConstraint>>();
    protected static final boolean PRINT_STATS = false;
    protected int fNrCreated = 0;
    protected int fNrFiltered = 0;
    protected int fNrRetrieved = 0;

    private ISimpleConstraint doCreateSimpleConstraint(IConstraintTerm v1, IConstraintTerm v2, IConstraintOperator operator) {
        if (this.fSimpleConstraints.containsKey(v1)) {
            Map<IConstraintTerm, Map<IConstraintOperator, IConstraint>> m2 = this.fSimpleConstraints.get(v1);
            if (m2.containsKey(v2)) {
                Map<IConstraintOperator, IConstraint> m3 = m2.get(v2);
                if (m3.containsKey(operator)) {
                    return (ISimpleConstraint)m3.get(operator);
                }
                return this.storeConstraint(v1, v2, operator, m3);
            }
            HashMap<IConstraintOperator, IConstraint> m3 = new HashMap<IConstraintOperator, IConstraint>();
            m2.put(v2, m3);
            return this.storeConstraint(v1, v2, operator, m3);
        }
        HashMap<IConstraintTerm, HashMap<IConstraintOperator, IConstraint>> m2 = new HashMap<IConstraintTerm, HashMap<IConstraintOperator, IConstraint>>();
        this.fSimpleConstraints.put(v1, m2);
        HashMap<IConstraintOperator, IConstraint> m3 = new HashMap<IConstraintOperator, IConstraint>();
        m2.put(v2, m3);
        return this.storeConstraint(v1, v2, operator, m3);
    }

    private ISimpleConstraint storeConstraint(IConstraintTerm v1, IConstraintTerm v2, IConstraintOperator operator, Map<IConstraintOperator, IConstraint> m3) {
        SimpleConstraint constraint = new SimpleConstraint(v1, v2, operator);
        m3.put(operator, constraint);
        return constraint;
    }

    @Override
    public ISimpleConstraint createSimpleConstraint(IConstraintTerm v1, IConstraintTerm v2, IConstraintOperator operator) {
        if (this.filterSimple(v1, v2, operator)) {
            return null;
        }
        return this.doCreateSimpleConstraint(v1, v2, operator);
    }

    public boolean filterSimple(IConstraintTerm v1, IConstraintTerm v2, IConstraintOperator operator) {
        return v1 == v2;
    }

    public OrConstraint createOrConstraint(IConstraint[] constraints) {
        OrConstraint constraint;
        IConstraintTerm left = ((SimpleConstraint)constraints[0]).getLeft();
        String signature = "";
        int i = 0;
        while (i < constraints.length) {
            IConstraintTerm right = ((SimpleConstraint)constraints[i]).getRight();
            String varName = right.toString();
            signature = String.valueOf(signature) + varName + ",";
            ++i;
        }
        if (this.fOrConstraints.containsKey(left)) {
            Map<String, OrConstraint> m2 = this.fOrConstraints.get(left);
            if (m2.containsKey(signature)) {
                return m2.get(signature);
            }
            constraint = new OrConstraint(constraints);
            m2.put(signature, constraint);
            return constraint;
        }
        HashMap<String, OrConstraint> m2 = new HashMap<String, OrConstraint>();
        this.fOrConstraints.put(left, m2);
        constraint = new OrConstraint(constraints);
        m2.put(signature, constraint);
        return constraint;
    }

    protected void dumpStats() {
        System.out.println("Constraints: " + this.fNrCreated + " created, " + this.fNrRetrieved + " retrieved, " + this.fNrFiltered + " filtered");
    }
}

