/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.constraints;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.imp.analysis.constraints.ConstraintGraph;
import org.eclipse.imp.analysis.constraints.IConstraint;
import org.eclipse.imp.analysis.constraints.IConstraintTerm;
import org.eclipse.imp.analysis.constraints.IEstimateEnvironment;
import org.eclipse.imp.analysis.constraints.ITermEstimate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConstraintSolver {
    protected final Collection<IConstraint> fConstraints = new LinkedList<IConstraint>();
    protected ConstraintGraph fGraph;
    protected boolean fgDebug = false;
    protected Stack<IConstraintTerm> fWorkList = new Stack();
    private IEstimateEnvironment fEstimates;

    public ConstraintSolver(Collection<IConstraint> constraints) {
        this.fConstraints.addAll(constraints);
    }

    public boolean debug() {
        return this.fgDebug;
    }

    public <T extends ITermEstimate> IEstimateEnvironment<T> getEstimates() {
        return this.fEstimates;
    }

    protected abstract <T extends ITermEstimate> IEstimateEnvironment<T> createEstimateEnvironment();

    protected abstract ITermEstimate getInitialEstimate(IConstraintTerm var1);

    private void initializeEstimates(ConstraintGraph graph) {
        for (IConstraintTerm t : graph.getVariables()) {
            this.fEstimates.setEstimate(t, this.getInitialEstimate(t));
        }
    }

    public void solve() {
        this.fGraph = new ConstraintGraph(this.fConstraints);
        this.initializeEstimates(this.fGraph);
        if (this.fgDebug) {
            System.out.println("*** Beginning solution ***");
        }
        while (!this.fWorkList.empty()) {
            IConstraintTerm t = this.fWorkList.pop();
            List<IConstraint> usedIn = this.fGraph.getUsedIn(t);
            if (this.fgDebug) {
                System.out.println("Popped " + t + " off work-list.");
            }
            for (IConstraint c : usedIn) {
                c.satisfy(this.fEstimates, this);
            }
        }
    }

    public IEstimateEnvironment<?> getSolution() {
        return this.getEstimates();
    }

    public void reportResults() {
        IEstimateEnvironment estimates = this.getEstimates();
        for (IConstraintTerm t : ConstraintGraph.sortedConstraintVariables(this.fGraph.getVariables())) {
            System.out.println(String.valueOf(t.toString()) + " => " + estimates.getEstimate(t));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EstimateEnvironment<T extends ITermEstimate>
    implements IEstimateEnvironment<T> {
        private Map<IConstraintTerm, T> fEstimates = new LinkedHashMap<IConstraintTerm, T>();

        @Override
        public void setEstimate(IConstraintTerm t, T newEst) {
            ITermEstimate curEst = (ITermEstimate)this.fEstimates.get(t);
            if (curEst == null || !curEst.equals(newEst)) {
                this.fEstimates.put(t, newEst);
                if (!ConstraintSolver.this.fWorkList.contains(t)) {
                    ConstraintSolver.this.fWorkList.push(t);
                }
            }
        }

        @Override
        public T getEstimate(IConstraintTerm t) {
            return (T)((ITermEstimate)this.fEstimates.get(t));
        }
    }
}

