/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.constraints;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.imp.analysis.constraints.ConstraintSolver;
import org.eclipse.imp.analysis.constraints.IConstraint;
import org.eclipse.imp.analysis.constraints.IEstimateEnvironment;
import org.eclipse.imp.analysis.constraints.ITermProcessor;
import org.eclipse.imp.core.Assert;

public class OrConstraint
implements IConstraint {
    private final IConstraint[] fConstraints;

    OrConstraint(IConstraint[] constraints) {
        Assert.isNotNull((Object)constraints);
        this.fConstraints = OrConstraint.sort(OrConstraint.getCopy(constraints));
    }

    public boolean isSimpleTypeConstraint() {
        return false;
    }

    public IConstraint[] getConstraints() {
        return this.fConstraints;
    }

    private static IConstraint[] getCopy(IConstraint[] constraints) {
        List<IConstraint> l = Arrays.asList(constraints);
        return l.toArray(new IConstraint[l.size()]);
    }

    private static IConstraint[] sort(IConstraint[] constraints) {
        Arrays.sort(constraints, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o2.toString().compareTo(o1.toString());
            }
        });
        return constraints;
    }

    public void processTerms(ITermProcessor processor) {
        IConstraint[] iConstraintArray = this.fConstraints;
        int n = this.fConstraints.length;
        int n2 = 0;
        while (n2 < n) {
            IConstraint c = iConstraintArray[n2];
            c.processTerms(processor);
            ++n2;
        }
    }

    public void satisfy(IEstimateEnvironment env, ConstraintSolver solver) {
        throw new UnsupportedOperationException("Unable to satisfy OR constraint");
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.fConstraints.length) {
            IConstraint constraint = this.fConstraints[i];
            if (i > 0) {
                buff.append(" or ");
            }
            buff.append(constraint.toString());
            ++i;
        }
        return buff.toString();
    }
}

