/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.constraints;

import org.eclipse.imp.analysis.constraints.ConstraintSolver;
import org.eclipse.imp.analysis.constraints.IConstraintOperator;
import org.eclipse.imp.analysis.constraints.IConstraintTerm;
import org.eclipse.imp.analysis.constraints.IEstimateEnvironment;
import org.eclipse.imp.analysis.constraints.ISimpleConstraint;
import org.eclipse.imp.analysis.constraints.ITermProcessor;

public class SimpleConstraint
implements ISimpleConstraint {
    private final IConstraintTerm fLeft;
    private final IConstraintTerm fRight;
    private final IConstraintOperator fOperator;

    public SimpleConstraint(IConstraintTerm left, IConstraintTerm right, IConstraintOperator operator) {
        this.fLeft = left;
        this.fRight = right;
        this.fOperator = operator;
    }

    public IConstraintTerm getLeft() {
        return this.fLeft;
    }

    public IConstraintTerm getRight() {
        return this.fRight;
    }

    public IConstraintOperator getOperator() {
        return this.fOperator;
    }

    public void processTerms(ITermProcessor processor) {
        processor.processTerm(this.fLeft);
        processor.processTerm(this.fRight);
    }

    public void satisfy(IEstimateEnvironment env, ConstraintSolver solver) {
        this.fOperator.satisfyConstraint(this, env, solver);
    }

    public String toString() {
        return String.valueOf(this.fLeft.toString()) + this.fOperator + this.fRight;
    }
}

