/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.reachingdefs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.imp.analysis.constraints.ConstraintFactory;
import org.eclipse.imp.analysis.constraints.IConstraint;
import org.eclipse.imp.analysis.constraints.IConstraintFactory;
import org.eclipse.imp.analysis.constraints.IConstraintTerm;
import org.eclipse.imp.analysis.reachingdefs.ConstraintCreatorBase;
import org.eclipse.imp.analysis.reachingdefs.DefinitionLiteral;
import org.eclipse.imp.analysis.reachingdefs.ReachingDefsDifference;
import org.eclipse.imp.analysis.reachingdefs.ReachingDefsEntry;
import org.eclipse.imp.analysis.reachingdefs.ReachingDefsExit;
import org.eclipse.imp.analysis.reachingdefs.ReachingDefsVariableFactory;
import org.eclipse.imp.analysis.reachingdefs.SubsetOperator;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class ReachingDefsConstraintCreator
extends ConstraintCreatorBase {
    private final ReachingDefsVariableFactory fVariableFactory = new ReachingDefsVariableFactory();
    private final IConstraintFactory fConstraintFactory = new ConstraintFactory();

    public ReachingDefsVariableFactory getVariableFactory() {
        return this.fVariableFactory;
    }

    private IConstraint newSubsetConstraint(IConstraintTerm lhs, IConstraintTerm rhs) {
        return this.fConstraintFactory.createSimpleConstraint(lhs, rhs, SubsetOperator.getInstance());
    }

    private IConstraint[] createPassThroughConstraint(ASTNode node) {
        return new IConstraint[]{this.newSubsetConstraint(this.fVariableFactory.createEntryLabel(node), this.fVariableFactory.createExitLabel(node))};
    }

    public IConstraint[] create(SimpleName name) {
        if (name.resolveBinding().getKind() == 3) {
            return this.createPassThroughConstraint((ASTNode)name);
        }
        return EMPTY_ARRAY;
    }

    public IConstraint[] create(QualifiedName name) {
        if (name.resolveBinding().getKind() == 3) {
            return this.createPassThroughConstraint((ASTNode)name);
        }
        return EMPTY_ARRAY;
    }

    public IConstraint[] create(BooleanLiteral node) {
        return this.createPassThroughConstraint((ASTNode)node);
    }

    public IConstraint[] create(NumberLiteral node) {
        return this.createPassThroughConstraint((ASTNode)node);
    }

    public IConstraint[] create(Assignment assign) {
        Expression lhs = assign.getLeftHandSide();
        Expression rhs = assign.getRightHandSide();
        if (lhs.getNodeType() != 42) {
            return EMPTY_ARRAY;
        }
        SimpleName name = (SimpleName)lhs;
        IBinding nameBinding = name.resolveBinding();
        if (nameBinding.getKind() != 3) {
            return EMPTY_ARRAY;
        }
        IVariableBinding varBinding = (IVariableBinding)nameBinding;
        if (varBinding.isField()) {
            return EMPTY_ARRAY;
        }
        DefinitionLiteral defLit = this.fVariableFactory.createDefinitionLiteral(varBinding, (ASTNode)assign);
        ReachingDefsExit rdExit = this.fVariableFactory.createExitLabel((ASTNode)assign);
        return new IConstraint[]{this.newSubsetConstraint(this.fVariableFactory.createEntryLabel((ASTNode)assign), this.fVariableFactory.createEntryLabel((ASTNode)rhs)), this.newSubsetConstraint(defLit, rdExit), this.newSubsetConstraint(new ReachingDefsDifference(this.fVariableFactory.createExitLabel((ASTNode)rhs), this.fVariableFactory.createDefinitionLiteral(varBinding, null)), rdExit)};
    }

    public IConstraint[] create(VariableDeclarationFragment vdf) {
        SimpleName name = vdf.getName();
        IVariableBinding nameBinding = (IVariableBinding)name.resolveBinding();
        vdf.getInitializer();
        return new IConstraint[]{this.newSubsetConstraint(new ReachingDefsDifference(this.fVariableFactory.createEntryLabel((ASTNode)vdf), this.fVariableFactory.createDefinitionLiteral(nameBinding, null)), this.fVariableFactory.createExitLabel((ASTNode)vdf)), this.newSubsetConstraint(this.fVariableFactory.createDefinitionLiteral(nameBinding, (ASTNode)vdf), this.fVariableFactory.createExitLabel((ASTNode)vdf))};
    }

    public IConstraint[] create(VariableDeclarationExpression vde) {
        ASTNode firstFrag = (ASTNode)vde.fragments().get(0);
        return new IConstraint[]{this.newSubsetConstraint(this.fVariableFactory.createEntryLabel((ASTNode)vde), this.fVariableFactory.createEntryLabel(firstFrag)), this.newSubsetConstraint(this.fVariableFactory.createExitLabel(firstFrag), this.fVariableFactory.createExitLabel((ASTNode)vde))};
    }

    public IConstraint[] create(MethodInvocation inv) {
        Expression rcvr = inv.getExpression();
        List arguments = inv.arguments();
        ArrayList<IConstraint> result = new ArrayList<IConstraint>();
        ReachingDefsEntry invEntry = this.fVariableFactory.createEntryLabel((ASTNode)inv);
        ReachingDefsExit invExit = this.fVariableFactory.createExitLabel((ASTNode)inv);
        ReachingDefsEntry rcvrEntry = this.fVariableFactory.createEntryLabel((ASTNode)rcvr);
        ReachingDefsExit rcvrExit = this.fVariableFactory.createExitLabel((ASTNode)rcvr);
        result.add(this.newSubsetConstraint(invEntry, rcvrEntry));
        if (arguments.size() > 0) {
            Expression prevArg = (Expression)arguments.get(0);
            result.add(this.newSubsetConstraint(rcvrExit, this.fVariableFactory.createEntryLabel((ASTNode)prevArg)));
            int i = 1;
            while (i < arguments.size()) {
                Expression thisArg = (Expression)arguments.get(i);
                result.add(this.newSubsetConstraint(this.fVariableFactory.createExitLabel((ASTNode)prevArg), this.fVariableFactory.createEntryLabel((ASTNode)thisArg)));
                prevArg = thisArg;
                ++i;
            }
            Expression lastArg = (Expression)arguments.get(arguments.size() - 1);
            result.add(this.newSubsetConstraint(this.fVariableFactory.createExitLabel((ASTNode)lastArg), invExit));
        } else {
            result.add(this.newSubsetConstraint(rcvrExit, invExit));
        }
        return result.toArray(new IConstraint[result.size()]);
    }

    private IConstraint[] createUnaryOpDefinitionConstraints(Expression pfe, Expression operand) {
        if (operand.getNodeType() != 42) {
            return this.createPassThroughConstraint((ASTNode)pfe);
        }
        Name name = (Name)operand;
        IVariableBinding nameBinding = (IVariableBinding)name.resolveBinding();
        ReachingDefsExit pfeExit = this.fVariableFactory.createExitLabel((ASTNode)pfe);
        DefinitionLiteral defWildcard = this.fVariableFactory.createDefinitionLiteral(nameBinding, null);
        DefinitionLiteral defLit = this.fVariableFactory.createDefinitionLiteral(nameBinding, (ASTNode)pfe);
        return new IConstraint[]{this.newSubsetConstraint(new ReachingDefsDifference(this.fVariableFactory.createEntryLabel((ASTNode)pfe), defWildcard), pfeExit), this.newSubsetConstraint(defLit, pfeExit)};
    }

    public IConstraint[] create(PostfixExpression pfe) {
        Expression operand = pfe.getOperand();
        return this.createUnaryOpDefinitionConstraints((Expression)pfe, operand);
    }

    public IConstraint[] create(PrefixExpression pfe) {
        PrefixExpression.Operator operator = pfe.getOperator();
        if (operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) {
            return this.createUnaryOpDefinitionConstraints((Expression)pfe, pfe.getOperand());
        }
        return this.createPassThroughConstraint((ASTNode)pfe);
    }

    public IConstraint[] create(InfixExpression ife) {
        Expression left = ife.getLeftOperand();
        Expression right = ife.getRightOperand();
        return new IConstraint[]{this.newSubsetConstraint(this.fVariableFactory.createEntryLabel((ASTNode)ife), this.fVariableFactory.createEntryLabel((ASTNode)left)), this.newSubsetConstraint(this.fVariableFactory.createExitLabel((ASTNode)left), this.fVariableFactory.createEntryLabel((ASTNode)right)), this.newSubsetConstraint(this.fVariableFactory.createExitLabel((ASTNode)right), this.fVariableFactory.createExitLabel((ASTNode)ife))};
    }

    public IConstraint[] create(ExpressionStatement es) {
        Expression expression = es.getExpression();
        return new IConstraint[]{this.newSubsetConstraint(this.fVariableFactory.createEntryLabel((ASTNode)es), this.fVariableFactory.createEntryLabel((ASTNode)expression)), this.newSubsetConstraint(this.fVariableFactory.createExitLabel((ASTNode)expression), this.fVariableFactory.createExitLabel((ASTNode)es))};
    }

    public IConstraint[] create(VariableDeclarationStatement node) {
        ASTNode firstFrag = (ASTNode)node.fragments().get(0);
        return new IConstraint[]{this.newSubsetConstraint(this.fVariableFactory.createEntryLabel((ASTNode)node), this.fVariableFactory.createEntryLabel(firstFrag)), this.newSubsetConstraint(this.fVariableFactory.createExitLabel(firstFrag), this.fVariableFactory.createExitLabel((ASTNode)node))};
    }

    public IConstraint[] create(Block block) {
        List stmts = block.statements();
        ArrayList<IConstraint> result = new ArrayList<IConstraint>();
        if (stmts.size() < 1) {
            return this.createPassThroughConstraint((ASTNode)block);
        }
        result.add(this.newSubsetConstraint(this.fVariableFactory.createEntryLabel((ASTNode)block), this.fVariableFactory.createEntryLabel((ASTNode)stmts.get(0))));
        int i = 1;
        while (i < stmts.size()) {
            result.add(this.newSubsetConstraint(this.fVariableFactory.createExitLabel((ASTNode)stmts.get(i - 1)), this.fVariableFactory.createEntryLabel((ASTNode)stmts.get(i))));
            ++i;
        }
        result.add(this.newSubsetConstraint(this.fVariableFactory.createExitLabel((ASTNode)stmts.get(stmts.size() - 1)), this.fVariableFactory.createExitLabel((ASTNode)block)));
        return result.toArray(new IConstraint[result.size()]);
    }

    public IConstraint[] create(ForStatement forStmt) {
        Statement body = forStmt.getBody();
        Expression cond = forStmt.getExpression();
        List inits = forStmt.initializers();
        List updates = forStmt.updaters();
        Expression init = (Expression)inits.get(0);
        Expression update = (Expression)updates.get(0);
        ArrayList<IConstraint> result = new ArrayList<IConstraint>();
        ReachingDefsEntry forEntry = this.fVariableFactory.createEntryLabel((ASTNode)forStmt);
        ReachingDefsExit forExit = this.fVariableFactory.createExitLabel((ASTNode)forStmt);
        ReachingDefsEntry condEntry = this.fVariableFactory.createEntryLabel((ASTNode)cond);
        ReachingDefsExit condExit = this.fVariableFactory.createExitLabel((ASTNode)cond);
        ReachingDefsEntry bodyEntry = this.fVariableFactory.createEntryLabel((ASTNode)body);
        ReachingDefsExit bodyExit = this.fVariableFactory.createExitLabel((ASTNode)body);
        result.add(this.newSubsetConstraint(forEntry, this.fVariableFactory.createEntryLabel((ASTNode)init)));
        result.add(this.newSubsetConstraint(this.fVariableFactory.createExitLabel((ASTNode)init), condEntry));
        result.add(this.newSubsetConstraint(condExit, bodyEntry));
        result.add(this.newSubsetConstraint(bodyExit, this.fVariableFactory.createEntryLabel((ASTNode)update)));
        result.add(this.newSubsetConstraint(this.fVariableFactory.createExitLabel((ASTNode)update), condEntry));
        result.add(this.newSubsetConstraint(condExit, forExit));
        return result.toArray(new IConstraint[result.size()]);
    }

    public IConstraint[] create(IfStatement ifStmt) {
        Expression cond = ifStmt.getExpression();
        Statement thenStmt = ifStmt.getThenStatement();
        Statement elseStmt = ifStmt.getElseStatement();
        ReachingDefsExit condExit = this.fVariableFactory.createExitLabel((ASTNode)cond);
        IConstraint ifEntryToCondEntry = this.newSubsetConstraint(this.fVariableFactory.createEntryLabel((ASTNode)ifStmt), this.fVariableFactory.createEntryLabel((ASTNode)cond));
        IConstraint condExitToThenEntry = this.newSubsetConstraint(this.fVariableFactory.createEntryLabel((ASTNode)thenStmt), condExit);
        if (elseStmt == null) {
            return new IConstraint[]{ifEntryToCondEntry, condExitToThenEntry, this.newSubsetConstraint(this.fVariableFactory.createExitLabel((ASTNode)elseStmt), condExit)};
        }
        return new IConstraint[]{ifEntryToCondEntry, condExitToThenEntry};
    }

    private Statement findInnermostEnclosingLoop(ASTNode node) {
        while (node != null) {
            switch (node.getNodeType()) {
                case 19: 
                case 24: 
                case 61: {
                    return (Statement)node;
                }
            }
            node = node.getParent();
        }
        throw new IllegalStateException("Can't find loop enclosing loop control statement " + node);
    }

    public IConstraint[] create(ContinueStatement cont) {
        return new IConstraint[]{this.newSubsetConstraint(this.fVariableFactory.createExitLabel((ASTNode)cont), this.fVariableFactory.createEntryLabel((ASTNode)this.findInnermostEnclosingLoop((ASTNode)cont)))};
    }

    public IConstraint[] create(BreakStatement brk) {
        return new IConstraint[]{this.newSubsetConstraint(this.fVariableFactory.createExitLabel((ASTNode)brk), this.fVariableFactory.createEntryLabel((ASTNode)this.findInnermostEnclosingLoop((ASTNode)brk)))};
    }
}

