/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.reachingdefs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.imp.analysis.constraints.IConstraint;
import org.eclipse.imp.analysis.constraints.IEstimateEnvironment;
import org.eclipse.imp.analysis.reachingdefs.ConstraintVisitor;
import org.eclipse.imp.analysis.reachingdefs.DefinitionLiteral;
import org.eclipse.imp.analysis.reachingdefs.DefinitionSet;
import org.eclipse.imp.analysis.reachingdefs.ReachingDefsConstraintCreator;
import org.eclipse.imp.analysis.reachingdefs.ReachingDefsSolver;
import org.eclipse.imp.analysis.reachingdefs.ReachingDefsVariableFactory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseDefAnalyzer {
    private final CompilationUnit fCompilationUnit;
    private boolean USE_TRIVIAL_REF_FINDER = false;
    private Collection<IConstraint> fConstraints;
    private ReachingDefsVariableFactory fVariableFactory;

    public UseDefAnalyzer(CompilationUnit unit) {
        this.fCompilationUnit = unit;
    }

    public Set<ASTNode> findUsesDefsOf(ASTNode selectedNode) {
        if (selectedNode.getNodeType() != 42) {
            return Collections.emptySet();
        }
        Name selectedName = (Name)selectedNode;
        IBinding nodeBinding = selectedName.resolveBinding();
        if (!(nodeBinding instanceof IVariableBinding)) {
            return Collections.emptySet();
        }
        IVariableBinding varBinding = (IVariableBinding)nodeBinding;
        MethodDeclaration method = this.getOwningMethod(selectedNode);
        if (this.USE_TRIVIAL_REF_FINDER) {
            return this.findRefsToVariable(varBinding, method);
        }
        this.collectConstraints();
        ReachingDefsSolver solver = new ReachingDefsSolver(this.fConstraints);
        solver.solve();
        IEstimateEnvironment<DefinitionSet> reachingDefs = solver.getSolution();
        if (this.isDefinition(selectedNode)) {
            return this.findRefsToDef(selectedNode.getParent(), reachingDefs);
        }
        return this.findDefsForRef(selectedNode, varBinding, reachingDefs);
    }

    private Set<ASTNode> findRefsToDef(ASTNode def, final IEstimateEnvironment<DefinitionSet> reachingDefs) {
        final HashSet<ASTNode> result = new HashSet<ASTNode>();
        MethodDeclaration method = this.getOwningMethod(def);
        SimpleName name = (SimpleName)((Assignment)def).getLeftHandSide();
        final IVariableBinding defBinding = (IVariableBinding)name.resolveBinding();
        final DefinitionLiteral defLit = new DefinitionLiteral(defBinding, def);
        method.accept(new ASTVisitor(){

            public boolean visit(SimpleName node) {
                if (!node.resolveBinding().isEqualTo((IBinding)defBinding)) {
                    return false;
                }
                DefinitionSet rds = (DefinitionSet)reachingDefs.getEstimate(UseDefAnalyzer.this.fVariableFactory.createEntryLabel((ASTNode)node));
                if (rds.contains(defLit)) {
                    result.add(node);
                }
                return false;
            }
        });
        return result;
    }

    private Set<ASTNode> findDefsForRef(ASTNode ref, IVariableBinding varBinding, IEstimateEnvironment<DefinitionSet> reachingDefs) {
        DefinitionSet defs = reachingDefs.getEstimate(this.fVariableFactory.createEntryLabel(ref));
        HashSet<ASTNode> result = new HashSet<ASTNode>();
        Iterator iter = defs.iterator();
        while (iter.hasNext()) {
            DefinitionLiteral def = (DefinitionLiteral)iter.next();
            if (!varBinding.isEqualTo((IBinding)def.getVarBinding())) continue;
            result.add(def.getLabel());
        }
        return result;
    }

    private Set<ASTNode> defsToNodes(Set<DefinitionLiteral> defs) {
        HashSet<ASTNode> result = new HashSet<ASTNode>();
        for (DefinitionLiteral def : defs) {
            if (def.isWildcard()) continue;
            result.add(def.getLabel());
        }
        return result;
    }

    private boolean isDefinition(ASTNode selectedNode) {
        return selectedNode.getParent().getNodeType() == 7;
    }

    private void dumpConstraints() {
        System.out.println("*** Constraints ***");
        for (IConstraint constraint : this.fConstraints) {
            System.out.println(constraint);
        }
    }

    private void collectConstraints() {
        ReachingDefsConstraintCreator rdcc = new ReachingDefsConstraintCreator();
        ConstraintVisitor cv = new ConstraintVisitor(rdcc);
        this.fCompilationUnit.accept((ASTVisitor)cv);
        this.fConstraints = cv.getConstraints();
        this.fVariableFactory = rdcc.getVariableFactory();
    }

    private MethodDeclaration getOwningMethod(ASTNode selectedNode) {
        ASTNode parent = selectedNode;
        while (parent.getNodeType() != 31) {
            parent = parent.getParent();
        }
        return (MethodDeclaration)parent;
    }

    private Set<ASTNode> findRefsToVariable(final IVariableBinding varBinding, MethodDeclaration method) {
        final HashSet<ASTNode> refs = new HashSet<ASTNode>();
        method.accept(new ASTVisitor(){

            public boolean visit(SimpleName node) {
                if (node.resolveBinding().equals((Object)varBinding)) {
                    refs.add(node);
                }
                return false;
            }
        });
        return refs;
    }
}

