/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints.bindings;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.imp.analysis.ISourceRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingKeyFactory {
    protected Map<Object, BindingKey> fTypeBindingMap = new HashMap<Object, BindingKey>();
    protected Map<Object, BindingKey> fMethodBindingMap = new HashMap<Object, BindingKey>();
    protected Map<Object, BindingKey> fPackageBindingMap = new HashMap<Object, BindingKey>();
    protected Map<Object, BindingKey> fVariableBindingMap = new HashMap<Object, BindingKey>();
    protected Map<Object, BindingKey> fReturnBindingMap = new HashMap<Object, BindingKey>();
    protected Map<Object, BindingKey> fDeclTypeBindingMap = new HashMap<Object, BindingKey>();
    protected Map<Object, Map<Integer, BindingKey>> fMethodArgBindingMap = new HashMap<Object, Map<Integer, BindingKey>>();
    private IKeyCreator fTypeCreator = new IKeyCreator(){

        public BindingKey createKey(Object obj) {
            return BindingKeyFactory.this.createKeyForType(obj);
        }
    };
    private IKeyCreator fMethodCreator = new IKeyCreator(){

        public BindingKey createKey(Object obj) {
            return BindingKeyFactory.this.createKeyForMethod(obj);
        }
    };
    private IKeyCreator fPackageCreator = new IKeyCreator(){

        public BindingKey createKey(Object obj) {
            return BindingKeyFactory.this.createKeyForPackage(obj);
        }
    };
    private IKeyCreator fVariableCreator = new IKeyCreator(){

        public BindingKey createKey(Object obj) {
            return BindingKeyFactory.this.createKeyForVariable(obj);
        }
    };
    private IKeyCreator fReturnCreator = new IKeyCreator(){

        public BindingKey createKey(Object methodKey) {
            return new ReturnKey((BindingKey)methodKey);
        }
    };
    private IKeyCreator fDeclTypeCreator = new IKeyCreator(){

        public BindingKey createKey(Object memberKey) {
            return new DeclaringTypeKey((BindingKey)memberKey);
        }
    };

    private BindingKey getKeyFor(Object obj, Map<Object, BindingKey> map, IKeyCreator creator) {
        if (map.containsKey(obj)) {
            return map.get(obj);
        }
        BindingKey newKey = creator.createKey(obj);
        map.put(obj, newKey);
        return newKey;
    }

    public BindingKey getKeyForType(Object type) {
        return this.getKeyFor(type, this.fTypeBindingMap, this.fTypeCreator);
    }

    public BindingKey getKeyForMethod(Object method) {
        return this.getKeyFor(method, this.fMethodBindingMap, this.fMethodCreator);
    }

    public BindingKey getKeyForPackage(Object pkg) {
        return this.getKeyFor(pkg, this.fPackageBindingMap, this.fPackageCreator);
    }

    public BindingKey getKeyForVariable(Object var) {
        return this.getKeyFor(var, this.fVariableBindingMap, this.fVariableCreator);
    }

    public BindingKey getKeyForReturn(BindingKey methodKey) {
        return this.getKeyFor(methodKey, this.fReturnBindingMap, this.fReturnCreator);
    }

    public BindingKey getKeyForDeclaringType(BindingKey memberKey) {
        return this.getKeyFor(memberKey, this.fDeclTypeBindingMap, this.fDeclTypeCreator);
    }

    public BindingKey getKeyForMethodArgument(BindingKey methodKey, int argIndex) {
        Map<Object, Object> argMap;
        if (this.fMethodArgBindingMap.containsKey(methodKey)) {
            argMap = this.fMethodArgBindingMap.get(methodKey);
        } else {
            argMap = new HashMap();
            this.fMethodArgBindingMap.put(methodKey, argMap);
        }
        Integer boxedArgIndex = new Integer(argIndex);
        if (argMap.containsKey(boxedArgIndex)) {
            return (BindingKey)argMap.get(boxedArgIndex);
        }
        MethodArgumentKey key = new MethodArgumentKey(methodKey, argIndex);
        argMap.put(boxedArgIndex, key);
        return key;
    }

    protected abstract BindingKey createKeyForType(Object var1);

    protected abstract BindingKey createKeyForMethod(Object var1);

    protected abstract BindingKey createKeyForPackage(Object var1);

    protected abstract BindingKey createKeyForVariable(Object var1);

    public abstract Object findType(BindingKey var1);

    public abstract Object findMethod(BindingKey var1);

    public abstract Object findPackage(BindingKey var1);

    public abstract Object findVariable(BindingKey var1);

    public static interface BindingKey {
    }

    public static class CompositeKey
    implements BindingKey {
        private final BindingKey fKey1;
        private final BindingKey fKey2;

        public CompositeKey(BindingKey k1, BindingKey k2) {
            this.fKey1 = k1;
            this.fKey2 = k2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CompositeKey)) {
                return false;
            }
            CompositeKey other = (CompositeKey)o;
            return this.fKey1.equals(other.fKey1) && this.fKey1.equals(other.fKey2);
        }

        public int hashCode() {
            return 61 + 157 * (4049 * this.fKey1.hashCode() + 6691 * this.fKey2.hashCode());
        }

        public String toString() {
            return "<compoundKey: " + this.fKey1 + "#" + this.fKey2 + ">";
        }
    }

    protected final class DeclaringTypeKey
    implements BindingKey {
        private final BindingKey fMemberKey;

        public DeclaringTypeKey(BindingKey memberKey) {
            this.fMemberKey = memberKey;
        }

        public int hashCode() {
            return 23 * this.fMemberKey.hashCode() + 419;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeclaringTypeKey)) {
                return false;
            }
            DeclaringTypeKey other = (DeclaringTypeKey)obj;
            return other.fMemberKey.equals(this.fMemberKey);
        }

        public String toString() {
            return "declaringTypeOf[" + this.fMemberKey + "]";
        }
    }

    private static interface IKeyCreator {
        public BindingKey createKey(Object var1);
    }

    protected final class MethodArgumentKey
    implements BindingKey {
        private final BindingKey fMethodKey;
        private final int fArgIndex;

        public MethodArgumentKey(BindingKey methodKey, int argIndex) {
            this.fMethodKey = methodKey;
            this.fArgIndex = argIndex;
        }

        public int hashCode() {
            return 53 * this.fMethodKey.hashCode() + 461 * this.fArgIndex + 167;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodArgumentKey)) {
                return false;
            }
            MethodArgumentKey other = (MethodArgumentKey)obj;
            return other.fMethodKey.equals(this.fMethodKey) && other.fArgIndex == this.fArgIndex;
        }

        public String toString() {
            return "arg[" + this.fMethodKey + "," + this.fArgIndex + "]";
        }
    }

    protected final class ReturnKey
    implements BindingKey {
        private final BindingKey fMethodKey;

        public ReturnKey(BindingKey methodKey) {
            this.fMethodKey = methodKey;
        }

        public int hashCode() {
            return 17 * this.fMethodKey.hashCode() + 391;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReturnKey)) {
                return false;
            }
            ReturnKey other = (ReturnKey)obj;
            return other.fMethodKey.equals(this.fMethodKey);
        }

        public String toString() {
            return "return[" + this.fMethodKey + "]";
        }
    }

    public static class SourceRangeKey
    implements BindingKey {
        private final ISourceRange fRange;

        public SourceRangeKey(ISourceRange range) {
            this.fRange = range;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SourceRangeKey)) {
                return false;
            }
            SourceRangeKey other = (SourceRangeKey)o;
            return this.fRange.equals(other.fRange);
        }

        public int hashCode() {
            return 61 + 4049 * this.fRange.hashCode();
        }

        public String toString() {
            return "<rangeKey " + this.fRange + ">";
        }
    }

    protected final class StringBindingKey
    implements BindingKey {
        private final String fTheKey;

        public StringBindingKey(String key) {
            this.fTheKey = key;
        }

        public String getKey() {
            return this.fTheKey;
        }

        public int hashCode() {
            return 311 * this.fTheKey.hashCode() + 839;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StringBindingKey)) {
                return false;
            }
            StringBindingKey other = (StringBindingKey)obj;
            return other.fTheKey.equals(this.fTheKey);
        }

        public String toString() {
            return this.fTheKey;
        }
    }
}

