/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints.bindings;

import org.eclipse.imp.analysis.PolyglotUtils;
import org.eclipse.imp.analysis.type.constraints.bindings.BindingKeyFactory;
import polyglot.ast.Field;
import polyglot.ast.Local;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Package;
import polyglot.types.PrimitiveType;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.util.Position;

public class PolyglotBindingKeyFactory
extends BindingKeyFactory {
    protected BindingKeyFactory.BindingKey createKeyForType(Object type) {
        Type t = (Type)type;
        if (t.isPrimitive()) {
            PrimitiveType pt = (PrimitiveType)t;
            return new BindingKeyFactory.StringBindingKey(pt.toString());
        }
        if (t.isClass()) {
            ClassType ct = (ClassType)t;
            return new BindingKeyFactory.StringBindingKey(ct.fullName());
        }
        if (t.isArray()) {
            ArrayType at = (ArrayType)t;
            Type base = at.base();
            int dims = at.dims();
            BindingKeyFactory.BindingKey baseKey = this.createKeyForType(base);
            String dimSuffix = "";
            int i = 0;
            while (i < dims) {
                dimSuffix = String.valueOf(dimSuffix) + "[]";
                ++i;
            }
            return new BindingKeyFactory.CompositeKey(baseKey, new BindingKeyFactory.StringBindingKey(dimSuffix));
        }
        throw new IllegalArgumentException("Unable to create key for type " + type);
    }

    protected BindingKeyFactory.BindingKey createKeyForMethod(Object method) {
        MethodInstance mi = (MethodInstance)method;
        BindingKeyFactory.BindingKey containerKey = this.getKeyForType(mi.container());
        return new BindingKeyFactory.CompositeKey(containerKey, new BindingKeyFactory.StringBindingKey(mi.signature()));
    }

    protected BindingKeyFactory.BindingKey createKeyForPackage(Object pkg) {
        Package p = (Package)pkg;
        return new BindingKeyFactory.StringBindingKey(p.fullName());
    }

    protected BindingKeyFactory.BindingKey createKeyForVariable(Object var) {
        if (var instanceof Local) {
            Local local = (Local)var;
            LocalInstance li = local.localInstance();
            Position pos = li.declaration().position();
            return new BindingKeyFactory.SourceRangeKey(PolyglotUtils.srcRangeForPosition(pos, null));
        }
        if (var instanceof LocalInstance) {
            LocalInstance li = (LocalInstance)var;
            Position pos = li.declaration().position();
            return new BindingKeyFactory.SourceRangeKey(PolyglotUtils.srcRangeForPosition(pos, null));
        }
        if (var instanceof Field) {
            Field field = (Field)var;
            ReferenceType container = field.fieldInstance().container();
            return new BindingKeyFactory.CompositeKey(this.getKeyForType(container), new BindingKeyFactory.StringBindingKey(field.name()));
        }
        if (var instanceof FieldInstance) {
            FieldInstance field = (FieldInstance)var;
            ReferenceType container = field.container();
            return new BindingKeyFactory.CompositeKey(this.getKeyForType(container), new BindingKeyFactory.StringBindingKey(field.name()));
        }
        return null;
    }

    public Object findType(BindingKeyFactory.BindingKey typeKey) {
        return null;
    }

    public Object findMethod(BindingKeyFactory.BindingKey methodKey) {
        return null;
    }

    public Object findPackage(BindingKeyFactory.BindingKey pkgKey) {
        return null;
    }

    public Object findVariable(BindingKeyFactory.BindingKey varKey) {
        return null;
    }
}

