/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints.fastrep;

import org.eclipse.imp.analysis.type.constraints.bindings.ITypeBinding;
import org.eclipse.imp.analysis.type.constraints.fastrep.FastTypeAdapter;
import org.eclipse.imp.analysis.type.constraints.fastrep.HierarchyType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TypeEnvironment;
import org.eclipse.imp.analysis.type.constraints.fastrep.TypeVariable;
import org.eclipse.imp.core.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericType<T>
extends HierarchyType<T> {
    private TypeVariable[] fTypeParameters;

    protected GenericType(TypeEnvironment environment) {
        super(environment);
    }

    @Override
    protected void initialize(ITypeBinding binding, T javaElementType) {
        Assert.isTrue((boolean)binding.isGenericType());
        super.initialize(binding, javaElementType);
        TypeEnvironment environment = this.getEnvironment();
        ITypeBinding[] typeParameters = binding.getTypeParameters();
        this.fTypeParameters = new TypeVariable[typeParameters.length];
        int i = 0;
        while (i < typeParameters.length) {
            this.fTypeParameters[i] = (TypeVariable)environment.create(typeParameters[i]);
            ++i;
        }
    }

    @Override
    public int getKind() {
        return 6;
    }

    public TypeVariable[] getTypeParameters() {
        return (TypeVariable[])this.fTypeParameters.clone();
    }

    @Override
    public boolean doEquals(TType type) {
        return this.getTypeRepresentation().equals(((GenericType)type).getTypeRepresentation());
    }

    public int hashCode() {
        return this.getTypeRepresentation().hashCode();
    }

    @Override
    protected boolean doCanAssignTo(TType type) {
        return false;
    }

    @Override
    protected boolean isTypeEquivalentTo(TType other) {
        int otherElementType = other.getKind();
        if (otherElementType == 8 || otherElementType == 7) {
            return this.getErasure().isTypeEquivalentTo(other.getErasure());
        }
        return super.isTypeEquivalentTo(other);
    }

    @Override
    public String getName() {
        return this.getTypeRepresentation().toString();
    }

    @Override
    protected String getPlainPrettySignature() {
        StringBuffer result = new StringBuffer(FastTypeAdapter.getInstance().getFullyQualifiedName(this.getTypeRepresentation()));
        result.append("<");
        result.append(this.fTypeParameters[0].getPrettySignature());
        int i = 1;
        while (i < this.fTypeParameters.length) {
            result.append(", ");
            result.append(this.fTypeParameters[i].getPrettySignature());
            ++i;
        }
        result.append(">");
        return result.toString();
    }
}

