/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints.fastrep;

import java.util.Map;
import org.eclipse.imp.analysis.type.constraints.bindings.ITypeBinding;
import org.eclipse.imp.analysis.type.constraints.fastrep.StandardType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TypeEnvironment;
import org.eclipse.imp.analysis.type.constraints.fastrep.TypeTuple;
import org.eclipse.imp.core.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HierarchyType<T>
extends TType {
    private HierarchyType fSuperclass;
    private HierarchyType[] fInterfaces;
    private T fTypeRepresentation;

    protected HierarchyType(TypeEnvironment environment) {
        super(environment);
    }

    protected void initialize(ITypeBinding binding, T typeRep) {
        super.initialize(binding);
        Assert.isNotNull(typeRep);
        this.fTypeRepresentation = typeRep;
        TypeEnvironment environment = this.getEnvironment();
        ITypeBinding superclass = binding.getSuperclass();
        if (superclass != null) {
            this.fSuperclass = (HierarchyType)environment.create(superclass);
        }
        ITypeBinding[] interfaces = binding.getInterfaces();
        this.fInterfaces = new HierarchyType[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            this.fInterfaces[i] = (HierarchyType)environment.create(interfaces[i]);
            ++i;
        }
    }

    @Override
    public TType getSuperclass() {
        return this.fSuperclass;
    }

    @Override
    public TType[] getInterfaces() {
        return this.fInterfaces;
    }

    public T getTypeRepresentation() {
        return this.fTypeRepresentation;
    }

    public boolean isSubType(HierarchyType other) {
        if (this.getEnvironment() == other.getEnvironment()) {
            TypeTuple key;
            Map cache = this.getEnvironment().getSubTypeCache();
            Boolean value = (Boolean)cache.get(key = new TypeTuple(this, other));
            if (value != null) {
                return value;
            }
            boolean isSub = this.doIsSubType(other);
            value = isSub;
            cache.put(key, value);
            return isSub;
        }
        return this.doIsSubType(other);
    }

    private boolean doIsSubType(HierarchyType other) {
        if (this.fSuperclass != null && (other.isTypeEquivalentTo(this.fSuperclass) || this.fSuperclass.doIsSubType(other))) {
            return true;
        }
        int i = 0;
        while (i < this.fInterfaces.length) {
            if (other.isTypeEquivalentTo(this.fInterfaces[i]) || this.fInterfaces[i].doIsSubType(other)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean canAssignToStandardType(StandardType target) {
        if (target.isJavaLangObject()) {
            return true;
        }
        return this.isSubType(target);
    }
}

