/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.type.constraints.fastrep;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.imp.analysis.type.constraints.bindings.ITypeBinding;
import org.eclipse.imp.analysis.type.constraints.fastrep.ArrayType;
import org.eclipse.imp.analysis.type.constraints.fastrep.BindingKey;
import org.eclipse.imp.analysis.type.constraints.fastrep.GenericType;
import org.eclipse.imp.analysis.type.constraints.fastrep.NullType;
import org.eclipse.imp.analysis.type.constraints.fastrep.ParameterizedType;
import org.eclipse.imp.analysis.type.constraints.fastrep.PrimitiveType;
import org.eclipse.imp.analysis.type.constraints.fastrep.RawType;
import org.eclipse.imp.analysis.type.constraints.fastrep.StandardType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TType;
import org.eclipse.imp.analysis.type.constraints.fastrep.TypeVariable;
import org.eclipse.imp.analysis.type.constraints.fastrep.UnboundWildcardType;
import org.eclipse.imp.analysis.type.constraints.fastrep.VoidType;
import org.eclipse.imp.core.Assert;
import org.eclipse.imp.model.ISourceProject;
import polyglot.types.ClassType;
import polyglot.types.Type;

public class TypeEnvironment {
    public final PrimitiveType INT = new PrimitiveType(this, 0, BindingKey.createTypeBindingKey("int"));
    public final PrimitiveType CHAR = new PrimitiveType(this, 1, BindingKey.createTypeBindingKey("char"));
    public final PrimitiveType BOOLEAN = new PrimitiveType(this, 2, BindingKey.createTypeBindingKey("boolean"));
    public final PrimitiveType SHORT = new PrimitiveType(this, 3, BindingKey.createTypeBindingKey("short"));
    public final PrimitiveType LONG = new PrimitiveType(this, 4, BindingKey.createTypeBindingKey("long"));
    public final PrimitiveType FLOAT = new PrimitiveType(this, 5, BindingKey.createTypeBindingKey("float"));
    public final PrimitiveType DOUBLE = new PrimitiveType(this, 6, BindingKey.createTypeBindingKey("double"));
    public final PrimitiveType BYTE = new PrimitiveType(this, 7, BindingKey.createTypeBindingKey("byte"));
    public final NullType NULL = new NullType(this);
    public final VoidType VOID = new VoidType(this);
    final PrimitiveType[] PRIMITIVE_TYPES = new PrimitiveType[]{this.INT, this.CHAR, this.BOOLEAN, this.SHORT, this.LONG, this.FLOAT, this.DOUBLE, this.BYTE};
    private static final String[] BOXED_PRIMITIVE_NAMES = new String[]{"java.lang.Integer", "java.lang.Character", "java.lang.Boolean", "java.lang.Short", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Byte"};
    private TType OBJECT_TYPE = null;
    private Map[] fArrayTypes = new Map[]{new HashMap()};
    private Map fStandardTypes = new HashMap();
    private Map fGenericTypes = new HashMap();
    private Map fParameterizedTypes = new HashMap();
    private Map fRawTypes = new HashMap();
    private Map fTypeVariables = new HashMap();
    private Map fCaptureTypes = new HashMap();
    private Map fExtendsWildcardTypes = new HashMap();
    private Map fSuperWildcardTypes = new HashMap();
    private UnboundWildcardType fUnboundWildcardType = null;
    private static final int MAX_ENTRIES = 1024;
    private Map fSubTypeCache = new LinkedHashMap(50, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1024;
        }
    };
    private Map fSubTypes;
    private boolean fIdentityTest;

    public TypeEnvironment() {
        this(false);
    }

    public TypeEnvironment(boolean rememberSubtypes) {
        if (rememberSubtypes) {
            this.fSubTypes = new HashMap();
        }
    }

    public boolean isIdentityTest() {
        return this.fIdentityTest;
    }

    Map getSubTypeCache() {
        return this.fSubTypeCache;
    }

    public TType createForType(Type type) {
        if (type.isPrimitive()) {
            polyglot.types.PrimitiveType ptype = (polyglot.types.PrimitiveType)type;
            return this.createPrimitiveType(ptype);
        }
        if (type.isArray()) {
            polyglot.types.ArrayType atype = (polyglot.types.ArrayType)type;
            return this.createArrayType(atype);
        }
        if (type.isClass()) {
            ClassType ctype = (ClassType)type;
            return this.createRawType(ctype);
        }
        return null;
    }

    private TType createPrimitiveType(polyglot.types.PrimitiveType ptype) {
        if (ptype.isBoolean()) {
            return this.BOOLEAN;
        }
        if (ptype.isByte()) {
            return this.BYTE;
        }
        if (ptype.isChar()) {
            return this.CHAR;
        }
        if (ptype.isDouble()) {
            return this.DOUBLE;
        }
        if (ptype.isFloat()) {
            return this.FLOAT;
        }
        if (ptype.isInt()) {
            return this.INT;
        }
        if (ptype.isLong()) {
            return this.LONG;
        }
        if (ptype.isShort()) {
            return this.SHORT;
        }
        if (ptype.isVoid()) {
            return this.VOID;
        }
        return null;
    }

    public TType create(ITypeBinding binding) {
        throw new IllegalStateException("Unimplemented: TypeEnvironment.create(ITypeBinding)");
    }

    public TType getJavaLangObject() {
        return this.OBJECT_TYPE;
    }

    void initializeJavaLangObject(ITypeBinding object) {
        if (this.OBJECT_TYPE != null) {
            return;
        }
        throw new IllegalStateException("TType objectType= createStandardType(object);Assert.isTrue(objectType.isJavaLangObject());");
    }

    PrimitiveType createUnBoxed(StandardType type) {
        String name = type.getPlainPrettySignature();
        int i = 0;
        while (i < BOXED_PRIMITIVE_NAMES.length) {
            if (BOXED_PRIMITIVE_NAMES[i].equals(name)) {
                return this.PRIMITIVE_TYPES[i];
            }
            ++i;
        }
        return null;
    }

    Map getSubTypes() {
        return this.fSubTypes;
    }

    private void cacheSubType(TType supertype, TType result) {
        ArrayList<TType> subtypes;
        if (this.fSubTypes == null) {
            return;
        }
        if (supertype == null) {
            supertype = this.OBJECT_TYPE;
        }
        if ((subtypes = (ArrayList<TType>)this.fSubTypes.get(supertype)) == null) {
            subtypes = new ArrayList<TType>(5);
            this.fSubTypes.put(supertype, subtypes);
        } else {
            Assert.isTrue((!subtypes.contains(result) ? 1 : 0) != 0);
        }
        subtypes.add(result);
    }

    private void cacheSubTypes(TType[] interfaces, TType result) {
        int i = 0;
        while (i < interfaces.length) {
            this.cacheSubType(interfaces[i], result);
            ++i;
        }
    }

    private TType createPrimitiveType(ITypeBinding binding) {
        String name = binding.getName();
        String[] names = PrimitiveType.NAMES;
        int i = 0;
        while (i < names.length) {
            if (name.equals(names[i])) {
                return this.PRIMITIVE_TYPES[i];
            }
            ++i;
        }
        Assert.isTrue((boolean)false, (String)("Primitive type " + name + "unkown"));
        return null;
    }

    private ArrayType createArrayType(polyglot.types.ArrayType type) {
        int index = type.dims() - 1;
        TType elementType = this.createForType(type.base());
        Map arrayTypes = this.getArrayTypesMap(index);
        ArrayType result = (ArrayType)arrayTypes.get(elementType);
        if (result != null) {
            return result;
        }
        result = new ArrayType(this);
        arrayTypes.put(elementType, result);
        throw new IllegalStateException("result.initialize(type, elementType); return result;");
    }

    public ArrayType createArrayType(TType elementType, int dimensions) {
        Assert.isTrue((!elementType.isArrayType() ? 1 : 0) != 0);
        Assert.isTrue((!elementType.isAnonymous() ? 1 : 0) != 0);
        Assert.isTrue((dimensions > 0 ? 1 : 0) != 0);
        int index = dimensions - 1;
        Map arrayTypes = this.getArrayTypesMap(index);
        ArrayType result = (ArrayType)arrayTypes.get(elementType);
        if (result != null) {
            return result;
        }
        result = new ArrayType(this, BindingKey.createArrayTypeBindingKey(elementType.getBindingKey(), dimensions));
        arrayTypes.put(elementType, result);
        result.initialize(elementType, dimensions);
        return result;
    }

    private Map getArrayTypesMap(int index) {
        HashMap arrayTypes;
        int oldLength = this.fArrayTypes.length;
        if (index >= oldLength) {
            Map[] newArray = new Map[index + 1];
            System.arraycopy(this.fArrayTypes, 0, newArray, 0, oldLength);
            this.fArrayTypes = newArray;
        }
        if ((arrayTypes = this.fArrayTypes[index]) == null) {
            this.fArrayTypes[index] = arrayTypes = new HashMap();
        }
        return arrayTypes;
    }

    private StandardType createStandardType(Type type) {
        StandardType result = (StandardType)this.fStandardTypes.get(type);
        if (result != null) {
            return result;
        }
        result = new StandardType(this);
        this.fStandardTypes.put(type, result);
        throw new IllegalStateException("result.initialize(binding, type);if (OBJECT_TYPE == null && result.isJavaLangObject())   OBJECT_TYPE= result;return result;");
    }

    private GenericType createGenericType(ITypeBinding binding) {
        throw new IllegalStateException("Unimplemented: TypeEnvironment.createGenericType(ITypeBinding)");
    }

    private ParameterizedType createParameterizedType(ITypeBinding binding) {
        throw new IllegalStateException("Unimplemented: TypeEnvironment.createParameterizedType(ITypeBinding)");
    }

    private RawType createRawType(ClassType type) {
        RawType result = (RawType)this.fRawTypes.get(type);
        if (result != null) {
            return result;
        }
        result = new RawType(this);
        this.fRawTypes.put(type, result);
        throw new IllegalStateException("result.initialize(type);cacheSubType(result.getSuperclass(), result);cacheSubTypes(result.getInterfaces(), result);return result;");
    }

    private TypeVariable createTypeVariable(ITypeBinding binding) {
        throw new IllegalStateException("Unimplemented: TypeEnvironment.createTypeVariable(ITypeBinding)");
    }

    private static class ProjectKeyPair {
        private final ISourceProject fProject;
        private final BindingKey fBindingKey;

        public ProjectKeyPair(ISourceProject project, BindingKey bindingKey) {
            this.fProject = project;
            this.fBindingKey = bindingKey;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectKeyPair)) {
                return false;
            }
            ProjectKeyPair otherPair = (ProjectKeyPair)other;
            return this.fProject.equals(otherPair.fProject) && this.fBindingKey.equals(otherPair.fBindingKey);
        }

        public int hashCode() {
            return this.fProject.hashCode() + this.fBindingKey.hashCode();
        }
    }
}

