/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.reachingdefs;

import org.eclipse.imp.analysis.constraints.ConstraintSolver;
import org.eclipse.imp.analysis.constraints.IConstraintOperator;
import org.eclipse.imp.analysis.constraints.IConstraintTerm;
import org.eclipse.imp.analysis.constraints.IEstimateEnvironment;
import org.eclipse.imp.analysis.constraints.ISimpleConstraint;
import org.eclipse.imp.analysis.reachingdefs.DefinitionSet;

public class SubsetOperator
implements IConstraintOperator {
    private static final SubsetOperator fgInstance = new SubsetOperator();

    private SubsetOperator() {
    }

    public static SubsetOperator getInstance() {
        return fgInstance;
    }

    public void satisfyConstraint(ISimpleConstraint sc, IEstimateEnvironment env, ConstraintSolver solver) {
        IConstraintTerm lhs = sc.getLeft();
        IConstraintTerm rhs = sc.getRight();
        IConstraintOperator op = sc.getOperator();
        IEstimateEnvironment estimates = env;
        if (lhs.isComplexTerm()) {
            lhs.recomputeEstimate(estimates);
        }
        if (rhs.isComplexTerm()) {
            rhs.recomputeEstimate(estimates);
        }
        DefinitionSet lhsEst = (DefinitionSet)estimates.getEstimate(lhs);
        DefinitionSet rhsEst = (DefinitionSet)estimates.getEstimate(rhs);
        if (solver.debug()) {
            System.out.println("  Satisfying constraint " + sc);
            System.out.println("    " + lhs + " => " + lhsEst);
            System.out.println("    " + rhs + " => " + rhsEst);
        }
        if (!(op instanceof SubsetOperator)) {
            throw new UnsupportedOperationException("Unable to process constraint operator " + op);
        }
        if (!rhsEst.containsAll(lhsEst)) {
            estimates.setEstimate(rhs, rhsEst.unionWith(lhsEst));
        }
    }

    public String toString() {
        return "<=";
    }
}

