/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.analysis.cfg;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.imp.analysis.cfg.CFGEdge;
import org.eclipse.imp.analysis.cfg.CFGEntryNode;
import org.eclipse.imp.analysis.cfg.CFGExitNode;
import org.eclipse.imp.analysis.cfg.CFGNode;
import org.eclipse.imp.analysis.cfg.CFGNodeEdgeFactory;
import org.eclipse.imp.analysis.cfg.CFGPlainNode;

public class SourceCFG {
    public boolean fDebug = true;
    protected final List<CFGNode> fAllNodes = new ArrayList<CFGNode>();
    protected final List<CFGEdge> fAllEdges = new ArrayList<CFGEdge>();
    protected final CFGNodeEdgeFactory fFactory = new CFGNodeEdgeFactory(this);

    static String printRepFor(Object n) {
        String ns = n.toString();
        return ns.replaceAll("\n", " ").replaceAll("\"", "\\\\\"");
    }

    public void addNode(CFGNode n) {
        this.fAllNodes.add(n);
    }

    public void addEdge(CFGEdge e) {
        this.fAllEdges.add(e);
    }

    protected void reduce() {
        Stack<CFGEdge> edgeStack = new Stack<CFGEdge>();
        edgeStack.addAll(this.fAllEdges);
        while (!edgeStack.isEmpty()) {
            CFGEdge e = (CFGEdge)edgeStack.pop();
            CFGNode src = e.fSource;
            CFGNode dest = e.fDest;
            if (src.fOutgoingEdges.size() != 1 || dest.fIncomingEdges.size() != 1 || !e.isPlainEdge() || (!(src instanceof CFGEntryNode) || !(dest instanceof CFGExitNode) || ((CFGEntryNode)src).fASTNode != ((CFGExitNode)dest).fASTNode) && (!(src instanceof CFGPlainNode) || !(dest instanceof CFGPlainNode))) continue;
            System.out.println("Merge node " + src.getPrettyName() + " with node " + dest.getPrettyName());
            CFGNode newNode = this.fFactory.mergeNodes(src, dest);
            for (CFGEdge in : src.fIncomingEdges) {
                in.fDest = newNode;
                newNode.addIncomingEdge(in);
                if (edgeStack.contains(in)) continue;
                edgeStack.push(in);
            }
            for (CFGEdge out : dest.fOutgoingEdges) {
                out.fSource = newNode;
                newNode.addOutgoingEdge(out);
                if (edgeStack.contains(out)) continue;
                edgeStack.push(out);
            }
            this.fAllEdges.remove(e);
            this.fAllNodes.remove(src);
            this.fAllNodes.remove(dest);
        }
    }

    public String asDot() {
        StringBuffer buff = new StringBuffer();
        buff.append("digraph foo {\n");
        buff.append("    node [shape = ellipse, arrowhead = normal];\n");
        for (CFGNode n : this.fAllNodes) {
            buff.append("    ").append(n.getShortName()).append(' ').append("[label=\"").append(n.toString()).append("\"];\n");
        }
        for (CFGNode src : this.fAllNodes) {
            for (CFGEdge e : src.fOutgoingEdges) {
                CFGNode dest = e.fDest;
                String label = e.getLabel();
                buff.append("    ").append(src.getShortName()).append(" -> ").append(dest.getShortName());
                if (label.length() > 0) {
                    buff.append(" [label=\"").append(label).append("\"]");
                }
                buff.append(";\n");
            }
        }
        buff.append("}\n");
        return buff.toString();
    }

    public boolean sanityCheck() {
        boolean hasErrors = false;
        for (CFGNode node : this.fAllNodes) {
            if (node.fIncomingEdges.isEmpty() && node.isStartNode()) {
                System.err.println("Node " + node + " has no incoming edges!");
                hasErrors = true;
            }
            if (!node.fOutgoingEdges.isEmpty() || !node.isEndNode()) continue;
            System.err.println("Node " + node + " has no outgoing edges!");
            hasErrors = true;
        }
        return !hasErrors;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (CFGEdge e : this.fAllEdges) {
            buff.append(e).append('\n');
        }
        return buff.toString();
    }
}

